/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.AdapterStatusRequestHandler;
import de.ponton.xp.adapter.api.ErrorNotificationHandler;
import de.ponton.xp.adapter.api.MessageHandler;
import de.ponton.xp.adapter.api.OutboundMessageStatusUpdateHandler;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.internal.AbstractWebSocketEndpoint;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.AdapterStatusUpdateMessageHandler;
import de.ponton.xp.adapter.api.internal.ErrorNotificationInternalHandler;
import de.ponton.xp.adapter.api.internal.InboundMessageHandler;
import de.ponton.xp.adapter.api.internal.OnCloseListener;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.StatusUpdateHandler;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

class InboundWebSocketEndpoint
extends AbstractWebSocketEndpoint {
    private static final Logger LOG = Logger.getLogger(InboundWebSocketEndpoint.class.getName());
    private final InboundMessageHandler inboundMessageHandler;
    private final StatusUpdateHandler statusUpdateHandler;
    private final ErrorNotificationInternalHandler errorNotificationHandler;
    private final AdapterStatusUpdateMessageHandler adapterStatusUpdateMessageHandler;
    private final OnCloseListener onCloseListener;
    private StringBuilder metaData;

    InboundWebSocketEndpoint(Path inboundWorkFolder, MessageHandler messageHandler, OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler, ErrorNotificationHandler errorNotificationHandler, AdapterStatusRequestHandler adapterStatusRequestHandler, UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo, OnCloseListener onCloseListener) {
        super(uniqueId, signer, adapterInfo, new CompletableFuture<SimpleProperties>());
        this.errorNotificationHandler = new ErrorNotificationInternalHandler(errorNotificationHandler);
        this.onCloseListener = onCloseListener;
        this.inboundMessageHandler = new InboundMessageHandler(messageHandler, inboundWorkFolder);
        this.statusUpdateHandler = new StatusUpdateHandler(outboundMessageStatusUpdateHandler);
        this.adapterStatusUpdateMessageHandler = new AdapterStatusUpdateMessageHandler(adapterStatusRequestHandler);
        this.resetMetaData();
    }

    private void resetMetaData() {
        this.metaData = new StringBuilder();
    }

    @Override
    void handleOnText(WebSocket webSocket, CharSequence data, boolean last) {
        this.metaData.append(data);
        if (last) {
            SimpleProperties properties = new SimpleProperties();
            properties.load(this.metaData.toString());
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE, "UNKNOWN");
            try {
                ProtocolMessageTypeEnum messageTypeEnum = ProtocolMessageTypeEnum.valueOf(messageType);
                switch (messageTypeEnum) {
                    case InboundMessage: {
                        this.inboundMessageHandler.handleOnText(properties, webSocket);
                        break;
                    }
                    case OutboundMessageStatusUpdate: {
                        this.statusUpdateHandler.handleOnText(properties, webSocket);
                        break;
                    }
                    case ErrorNotification: {
                        this.errorNotificationHandler.handleOnText(properties, webSocket);
                        break;
                    }
                    case AdapterStatusRequest: {
                        this.adapterStatusUpdateMessageHandler.handleOnText(webSocket);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.SEVERE, "Received unknown message type '" + messageType + "'.");
                webSocket.sendClose(1000, "Received unknown message type '" + messageType + "'.");
            }
            this.resetMetaData();
        }
    }

    @Override
    void handleOnBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        this.inboundMessageHandler.handleOnBinary(webSocket, data, last);
    }

    @Override
    void handleOnClose(WebSocket webSocket, int statusCode, String reason) {
        this.inboundMessageHandler.purge();
        this.onCloseListener.onClose(webSocket);
    }
}

