/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ErrorNotificationHandler;
import de.ponton.xp.adapter.api.internal.ErrorNotificationResponseEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolErrorNotificationResponse;
import de.ponton.xp.adapter.api.messages.ErrorNotification;
import de.ponton.xp.adapter.api.messages.ErrorNotificationFactory;
import java.net.http.WebSocket;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorNotificationInternalHandler {
    private static final Logger LOG = Logger.getLogger(ErrorNotificationInternalHandler.class.getName());
    private final ErrorNotificationHandler errorNotificationHandler;

    public ErrorNotificationInternalHandler(ErrorNotificationHandler errorNotificationHandler) {
        this.errorNotificationHandler = errorNotificationHandler;
    }

    void handleOnText(SimpleProperties properties, WebSocket webSocket) {
        try {
            ErrorNotification errorNotification = ErrorNotificationFactory.getInstance().createErrorNotification(properties);
            if (Objects.nonNull(errorNotification)) {
                this.errorNotificationHandler.onErrorNotification(errorNotification);
            }
            this.sendResponse(webSocket, ErrorNotificationResponseEnum.SUCCESS, "Error notification successfully received.");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not process error notification.", e);
            this.sendResponse(webSocket, ErrorNotificationResponseEnum.REJECTED, "Could not process error notification: " + String.valueOf(e));
        }
    }

    private void sendResponse(WebSocket webSocket, ErrorNotificationResponseEnum result, String detailText) {
        ProtocolErrorNotificationResponse protocolErrorNotificationResponse = ProtocolErrorNotificationResponse.createBuilder().setResult(result).setDetailText(detailText).build();
        webSocket.sendText(protocolErrorNotificationResponse.toWireFormat(), true);
    }
}

