/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ConnectionStatusChangeHandler;
import de.ponton.xp.adapter.api.domainvalues.MessengerInstance;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionCountWatcher {
    private final MessengerInstance messengerInstance;
    private final ConnectionStatusChangeHandler connectionStatusChangeHandler;
    private final AtomicInteger lastConnOutCount = new AtomicInteger(0);
    private final AtomicInteger lastConnInCount = new AtomicInteger(0);
    private final AtomicInteger lastConnArchiveCount = new AtomicInteger(0);

    public ConnectionCountWatcher(MessengerInstance messengerInstance, ConnectionStatusChangeHandler connectionStatusChangeHandler) {
        this.messengerInstance = messengerInstance;
        this.connectionStatusChangeHandler = connectionStatusChangeHandler;
    }

    private void connectionStatusChanged(int currentOutCount, int currentInCount, int currentArchCount) {
        if (Objects.nonNull(this.connectionStatusChangeHandler)) {
            int lastOutCount = this.lastConnOutCount.getAndSet(currentOutCount);
            int lasInCount = this.lastConnInCount.getAndSet(currentInCount);
            int lastArchCount = this.lastConnArchiveCount.getAndSet(currentArchCount);
            if (lastOutCount != currentOutCount || lasInCount != currentInCount || lastArchCount != currentArchCount) {
                this.connectionStatusChangeHandler.connectionCountChanged(this.messengerInstance, currentOutCount, currentInCount, currentArchCount);
            }
        }
    }

    public void publishTotalOutboundConnectionCount(int totalCount) {
        this.connectionStatusChanged(totalCount, this.lastConnInCount.get(), this.lastConnArchiveCount.get());
    }

    public void publishTotalInboundConnectionCount(int totalCount) {
        this.connectionStatusChanged(this.lastConnOutCount.get(), totalCount, this.lastConnArchiveCount.get());
    }

    public void publishTotalArchiveConnectionCount(int totalCount) {
        this.connectionStatusChanged(this.lastConnOutCount.get(), this.lastConnInCount.get(), totalCount);
    }
}

