/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.internal.AbstractWebSocketEndpoint;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchiveDeleteMessageHandler;
import de.ponton.xp.adapter.api.internal.ArchiveGetMessageHandler;
import de.ponton.xp.adapter.api.internal.ArchiveStoreMessageHandler;
import de.ponton.xp.adapter.api.internal.OnCloseListener;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

class ArchiveWebSocketEndpoint
extends AbstractWebSocketEndpoint {
    private static final Logger LOG = Logger.getLogger(ArchiveWebSocketEndpoint.class.getName());
    private final ArchiveStoreMessageHandler archiveStoreMessageHandler;
    private final ArchiveGetMessageHandler archiveGetMessageHandler;
    private final ArchiveDeleteMessageHandler archiveDeleteMessageHandler;
    private final OnCloseListener onCloseListener;
    private StringBuilder metaData;

    ArchiveWebSocketEndpoint(Path archiveWorkFolder, ArchiveHandler archiveHandler, UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo, OnCloseListener onCloseListener) {
        super(uniqueId, signer, adapterInfo, new CompletableFuture<SimpleProperties>());
        Objects.requireNonNull(archiveHandler, "archiveHandler must not be NULL");
        this.onCloseListener = onCloseListener;
        this.archiveStoreMessageHandler = this.createArchiveStoreMessageHandler(archiveHandler, archiveWorkFolder);
        this.archiveGetMessageHandler = this.createArchiveGetMessageHandler(archiveHandler);
        this.archiveDeleteMessageHandler = this.createArchiveDeleteMessageHandler(archiveHandler);
        this.resetMetaData();
    }

    private void resetMetaData() {
        this.metaData = new StringBuilder();
    }

    @Override
    void handleOnText(WebSocket webSocket, CharSequence data, boolean last) {
        this.metaData.append(data);
        if (last) {
            SimpleProperties properties = new SimpleProperties();
            properties.load(this.metaData.toString());
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE, "UNKNOWN");
            try {
                ProtocolMessageTypeEnum messageTypeEnum = ProtocolMessageTypeEnum.valueOf(messageType);
                switch (messageTypeEnum) {
                    case ArchiveStoreData: {
                        this.archiveStoreMessageHandler.handleOnText(properties, webSocket);
                        break;
                    }
                    case ArchiveGetData: {
                        this.archiveGetMessageHandler.handleOnText(properties, webSocket);
                        break;
                    }
                    case ArchiveDeleteData: {
                        this.archiveDeleteMessageHandler.handleOnText(properties, webSocket);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.SEVERE, "Received unknown message type '" + messageType + "'.");
                webSocket.sendClose(1000, "Received unknown message type '" + messageType + "'.");
            }
            this.resetMetaData();
        }
    }

    @Override
    void handleOnBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        this.archiveStoreMessageHandler.handleOnBinary(webSocket, data, last);
    }

    @Override
    void handleOnClose(WebSocket webSocket, int statusCode, String reason) {
        this.archiveStoreMessageHandler.purge();
        this.onCloseListener.onClose(webSocket);
    }

    ArchiveStoreMessageHandler createArchiveStoreMessageHandler(ArchiveHandler archiveHandler, Path archiveWorkFolder) {
        return new ArchiveStoreMessageHandler(archiveHandler, archiveWorkFolder);
    }

    ArchiveGetMessageHandler createArchiveGetMessageHandler(ArchiveHandler archiveHandler) {
        return new ArchiveGetMessageHandler(archiveHandler);
    }

    ArchiveDeleteMessageHandler createArchiveDeleteMessageHandler(ArchiveHandler archiveHandler) {
        return new ArchiveDeleteMessageHandler(archiveHandler);
    }
}

