/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ArchiveException;
import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.ArtifactTypeEnum;
import de.ponton.xp.adapter.api.domainvalues.Filename;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageUniqueId;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchivePropertiesEnum;
import de.ponton.xp.adapter.api.internal.ByteBufferBackedInputStream;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.messages.ArchiveStoreResponse;
import de.ponton.xp.adapter.api.messages.internal.ArchiveStoreMessageImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveStoreMessageHandler {
    private static final Logger LOG = Logger.getLogger(ArchiveStoreMessageHandler.class.getName());
    private final ArchiveHandler archiveHandler;
    private final Path archiveWorkFolder;
    private SimpleProperties properties;
    private Path dataPath;
    private OutputStream dataStream;

    ArchiveStoreMessageHandler(ArchiveHandler archiveHandler, Path archiveWorkFolder) {
        this.archiveHandler = archiveHandler;
        this.archiveWorkFolder = archiveWorkFolder;
    }

    void handleOnText(SimpleProperties properties, WebSocket webSocket) {
        this.properties = properties;
        try {
            this.dataPath = Files.createTempFile(this.archiveWorkFolder, "archive-message_", ".dat", new FileAttribute[0]);
            this.dataStream = Files.newOutputStream(this.dataPath, new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "could not create temp file " + String.valueOf(this.dataPath) + ": " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOnBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        block15: {
            try {
                ArchiveStoreResponse archiveStoreResponse;
                ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(data);
                inputStream.transferTo(this.dataStream);
                if (!last) break block15;
                this.dataStream.close();
                LOG.log(Level.FINE, "received " + Files.size(this.dataPath) + " bytes");
                ArchiveStoreMessageImpl archiveStoreMessage = this.createArchiveStoreMessage(this.properties, this.dataPath);
                try {
                    archiveStoreResponse = this.archiveHandler.onMessage(archiveStoreMessage);
                }
                catch (ArchiveException e) {
                    this.sendError(e.getMessage(), webSocket);
                    return;
                }
                finally {
                    archiveStoreMessage.purge();
                    try {
                        Files.delete(this.dataPath);
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "could not delete temp file " + String.valueOf(this.dataPath) + ": " + String.valueOf(e));
                    }
                }
                this.sendResponse(webSocket, archiveStoreResponse);
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "could not write to temp file " + String.valueOf(this.dataPath) + ": " + String.valueOf(e));
                if (last) {
                    LOG.log(Level.SEVERE, "could not write to temp file " + String.valueOf(this.dataPath) + ": " + String.valueOf(e));
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "could not process inbound message.", e);
                if (!last) break block15;
                LOG.log(Level.SEVERE, "could not process inbound message.", e);
            }
        }
    }

    private void sendError(String errorMessage, WebSocket webSocket) throws IOException, ExecutionException, InterruptedException {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveStoreDataResponse.name());
        properties.setProperty(ArchivePropertiesEnum.ERROR_MESSAGE, errorMessage);
        this.waitForWebSocketTransmission(webSocket.sendText(properties.getWireFormat(), true));
    }

    private void sendResponse(WebSocket webSocket, ArchiveStoreResponse archiveStoreResponse) throws IOException, ExecutionException, InterruptedException {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveStoreDataResponse.name());
        properties.setProperty(ArchivePropertiesEnum.REFERENCE_ID, String.valueOf(archiveStoreResponse.getArchiveReferenceId().getStringValue()));
        this.waitForWebSocketTransmission(webSocket.sendText(properties.getWireFormat(), true));
    }

    private ArchiveStoreMessageImpl createArchiveStoreMessage(SimpleProperties properties, Path dataPath) {
        return ArchiveStoreMessageImpl.newBuilder().setMessageId(new MessageId(properties.getProperty(ArchivePropertiesEnum.MESSAGE_ID))).setMessageUniqueId(new MessageUniqueId(Long.parseLong(properties.getProperty(ArchivePropertiesEnum.MESSAGE_UNIQUE_ID)))).setInbound(Boolean.valueOf(properties.getProperty(ArchivePropertiesEnum.IS_INBOUND))).setArtifactType(ArtifactTypeEnum.valueOf(properties.getProperty(ArchivePropertiesEnum.ARTIFACT_TYPE))).setFailed(Boolean.valueOf(properties.getProperty(ArchivePropertiesEnum.FAILED))).setTimestamp(Instant.ofEpochMilli(Long.parseLong(properties.getProperty(ArchivePropertiesEnum.TIMESTAMP)))).setFilename(properties.getProperty(ArchivePropertiesEnum.FILE_NAME) == null ? null : new Filename(properties.getProperty(ArchivePropertiesEnum.FILE_NAME))).setPath(dataPath).build();
    }

    private void waitForWebSocketTransmission(CompletableFuture<WebSocket> future) throws InterruptedException, ExecutionException, IOException {
        WebSocket webSocket = future.get();
        if (webSocket.isOutputClosed() || webSocket.isInputClosed()) {
            throw new IOException("WebSocket is closed");
        }
    }

    void purge() {
        if (this.dataStream != null) {
            try {
                this.dataStream.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "could not close data stream: " + String.valueOf(e));
            }
        }
        if (this.dataPath != null) {
            try {
                Files.deleteIfExists(this.dataPath);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "could not delete temp file " + String.valueOf(this.dataPath) + ": " + String.valueOf(e));
            }
        }
    }
}

