/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ConnectionException;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.AuthenticationState;
import de.ponton.xp.adapter.api.internal.ByteBufferBackedInputStream;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolChallengeResponseMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.io.IOException;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractWebSocketEndpoint
implements WebSocket.Listener {
    private static final Logger LOG = Logger.getLogger(AbstractWebSocketEndpoint.class.getName());
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private final UniqueId uniqueId;
    private final Signer signer;
    private final AdapterInfo adapterInfo;
    private final CompletableFuture<SimpleProperties> authExpected;
    private AuthenticationState authenticationState;

    AbstractWebSocketEndpoint(UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo, CompletableFuture<SimpleProperties> authenticationExpected) {
        this.uniqueId = uniqueId;
        this.signer = signer;
        this.adapterInfo = adapterInfo;
        this.authenticationState = AuthenticationState.EXPECTING_CHALLENGE;
        this.authExpected = authenticationExpected;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        LOG.finer(() -> "onOpen() " + String.valueOf(webSocket));
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        LOG.finer(() -> "onText() " + String.valueOf(webSocket) + " data:" + String.valueOf(data));
        if (this.authenticationState != AuthenticationState.AUTHENTICATED) {
            webSocket.sendClose(1000, "shutdown");
        } else {
            this.handleOnText(webSocket, data, last);
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    abstract void handleOnText(WebSocket var1, CharSequence var2, boolean var3);

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        switch (this.authenticationState) {
            case AUTHENTICATED: {
                this.handleOnBinary(webSocket, data, last);
                break;
            }
            case EXPECTING_REGISTER_SUCCESS: {
                this.onBinaryRegisterSuccess(webSocket, data, last);
                break;
            }
            default: {
                this.onBinaryAuthentication(webSocket, data, last);
            }
        }
        return WebSocket.Listener.super.onBinary(webSocket, data, last);
    }

    private void onBinaryRegisterSuccess(WebSocket webSocket, ByteBuffer data, boolean last) {
        LOG.finer(() -> "onBinaryRegisterSuccess() " + String.valueOf(webSocket));
        try (ByteBufferBackedInputStream dataStream = new ByteBufferBackedInputStream(data);){
            SimpleProperties properties = new SimpleProperties();
            properties.load(dataStream);
            String apiMessageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE.toString(), "UNKNOWN");
            if (!ProtocolMessageTypeEnum.RegisterSuccessMessage.name().equals(apiMessageType)) {
                throw new IOException("unexpected message type " + apiMessageType);
            }
            LOG.finer(() -> "successfully registered at messenger:" + properties.getProperty(AdapterPropertiesEnum.MESSENGER_NAME));
            this.authenticationState = AuthenticationState.AUTHENTICATED;
            this.authExpected.complete(properties);
        }
        catch (IOException e) {
            this.authExpected.completeExceptionally(e);
        }
    }

    private void onBinaryAuthentication(WebSocket webSocket, ByteBuffer data, boolean last) {
        LOG.finer(() -> "onBinaryAuthentication() " + String.valueOf(webSocket));
        ByteBuffer buffer = ByteBuffer.allocate(2000);
        try {
            byte[] signature = this.signer.sign(data);
            byte[] encodedPublicKey = this.uniqueId.getEncodedPublicKey();
            ProtocolChallengeResponseMessage challengeResponseMessage = ProtocolChallengeResponseMessage.createBuilder().setAdapterApiVersion("2.0").setAdapterId(this.adapterInfo.getId()).setAdapterVersion(this.adapterInfo.getVersion()).setAdapterProcessingTimeout(this.adapterInfo.getProcessingTimeout()).setSupportStatusUpdate(this.adapterInfo.isSupportStatusUpdate()).setSupportErrorNotification(this.adapterInfo.isSupportErrorNotification()).setSupportInboundMessage(this.adapterInfo.isSupportInboundMessage()).setSupportArchiving(this.adapterInfo.isSupportArchiving()).build();
            byte[] challengeResponse = challengeResponseMessage.toWireFormat().getBytes(StandardCharsets.UTF_8);
            buffer.putShort((short)signature.length);
            buffer.put(signature);
            buffer.putShort((short)encodedPublicKey.length);
            buffer.put(encodedPublicKey);
            buffer.put(challengeResponse);
            buffer.flip();
            this.authenticationState = AuthenticationState.EXPECTING_REGISTER_SUCCESS;
            webSocket.sendBinary(buffer, true);
        }
        catch (GeneralSecurityException e) {
            LOG.severe(() -> "could not sign challenge. " + String.valueOf(e));
            webSocket.sendClose(1000, "could not sign challenge");
        }
    }

    abstract void handleOnBinary(WebSocket var1, ByteBuffer var2, boolean var3);

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        LOG.finer(() -> "onClose() " + String.valueOf(webSocket) + " status:" + statusCode + " reason:" + reason);
        this.authExpected.completeExceptionally(new ConnectionException(reason + " (" + statusCode + ")", null));
        this.handleOnClose(webSocket, statusCode, reason);
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    abstract void handleOnClose(WebSocket var1, int var2, String var3);

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        LOG.log(Level.SEVERE, "onError() " + String.valueOf(webSocket), error);
        WebSocket.Listener.super.onError(webSocket, error);
        this.onClose(webSocket, 1000, error.toString());
    }

    public void waitForAuthentication() throws ConnectionException {
        try {
            this.authExpected.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConnectionException("could not register at Messenger", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConnectionException) {
                throw (ConnectionException)e.getCause();
            }
            throw new ConnectionException(e.getCause().getMessage(), e.getCause());
        }
        catch (TimeoutException e) {
            throw new ConnectionException("timeout while registering at Messenger", e);
        }
    }

    AuthenticationState getAuthenticationState() {
        return this.authenticationState;
    }
}

