/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp;

import de.ponton.securelistener.ftp.FtpExchangeUser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FtpExchangeUserProperties {
    private static final String CRLF = "\r\n";
    private static final String EQUAL = " = ";
    private static final String PREFIX = "user.";
    private static final String NAME = ".name";
    private static final String PASSWORD = ".password";
    private static final String ENCRYPTED_PASSWORD = ".encrypted.password";
    private static final String PARTNER_LOCALID = ".partner.localid";
    private List<FtpExchangeUser> _exchangeUsers;

    public FtpExchangeUserProperties(InputStream inputStream) {
        try {
            Properties config = new Properties();
            config.load(inputStream);
            this.readConfig(config);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FtpExchangeUserProperties(List<FtpExchangeUser> exchangeUsers) {
        this._exchangeUsers = exchangeUsers == null ? new ArrayList() : exchangeUsers;
    }

    private void readConfig(Properties config) {
        String userName;
        this._exchangeUsers = new ArrayList<FtpExchangeUser>();
        int i = 0;
        while ((userName = config.getProperty(PREFIX + i + NAME)) != null) {
            FtpExchangeUser user = new FtpExchangeUser();
            user.setUserName(userName);
            String temp = config.getProperty(PREFIX + i + PASSWORD);
            if (temp == null || temp.length() == 0) {
                user.setPassword(null);
            } else {
                user.setPassword(temp);
            }
            temp = config.getProperty(PREFIX + i + ENCRYPTED_PASSWORD);
            if (temp == null || temp.length() == 0) {
                user.setEncryptedPassword(null);
            } else {
                user.setEncryptedPassword(temp);
            }
            temp = config.getProperty(PREFIX + i + PARTNER_LOCALID);
            if (temp == null || temp.length() == 0) {
                user.setPartnerLocalId(null);
            } else {
                user.setPartnerLocalId(temp);
            }
            this._exchangeUsers.add(user);
            ++i;
        }
    }

    public StringBuilder createConfig() {
        StringBuilder config = new StringBuilder();
        config.append("# FTP Exchange User Configuration");
        for (int i = 0; i < this._exchangeUsers.size(); ++i) {
            FtpExchangeUser user = this._exchangeUsers.get(i);
            config.append(CRLF);
            this.writeEntry(config, PREFIX + i + NAME, user.getUserName());
            this.writeEntry(config, PREFIX + i + PASSWORD, user.getPassword());
            this.writeEntry(config, PREFIX + i + ENCRYPTED_PASSWORD, user.getEncryptedPassword());
            this.writeEntry(config, PREFIX + i + PARTNER_LOCALID, user.getPartnerLocalId());
        }
        return config;
    }

    private void writeEntry(StringBuilder config, String key, String value) {
        if (value != null) {
            config.append(key);
            config.append(EQUAL);
            config.append(value);
            config.append(CRLF);
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        outputStream.write(this.createConfig().toString().getBytes());
    }

    public List<FtpExchangeUser> getFtpExchangeUsers() {
        return this._exchangeUsers;
    }
}

