/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.config;

import de.ponton.securelistener.security.PasswordCrypt;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;

@Singleton
public class ListenerProperties {
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    public static final String DEFAULT_PRIVATEKEY_PASSWORD = "changeit";
    public static final String DEFAULT_PRIVATEKEY_ALIAS = "jetty";
    private boolean sniEnabled = true;
    private static final String DEFAULT_IDLE_CONNECTION_TIMEOUT = "360";
    private static final String SSL_DISABLED_CIPHERS = "SSLDisabledCiphers";
    private static final String SSL_DISABLED_PROTOCOLS = "SSLDisabledProtocols";
    private static final Logger _log = LogManager.getLogger((String)"Listener.Config");
    private static final String ANY_IP = "*";
    public static final int MODE_CALLBACK = 1;
    public static final int MODE_SECURELISTENER = 2;
    public static final int MODE_SECURECALLBACK = 3;
    private static final String LISTENER_INTERNAL_IP = "InternalCommunication.IP";
    private static final String LISTENER_INTERNAL_PORT = "InternalCommunication.Port";
    private static final String LISTENER_INTERNAL_TIMEOUT = "InternalCommunication.Timeout";
    private static final String LISTENER_INTERNAL_SSL = "InternalCommunication.UseSSL";
    private static final String LISTENER_INTERNAL_ACCEPT_FIST_CLIENT = "InternalCommunication.AutomaticallyAcceptFirstClient";
    private static final String LISTENER_INTERNAL_AUTHORIZATION_STORE = "InternalCommunication.AuthorizationStore";
    private static final String LISTENER_HTTP_PORT = "HttpPort";
    private static final String LISTENER_HTTP_ENABLED = "HttpEnabled";
    private static final String LISTENER_HTTPS_PORT = "HttpsPort";
    private static final String LISTENER_HTTPS_ENABLED = "HttpsEnabled";
    private static final String LISTENER_SNI_ENABLED = "SniEnabled";
    private static final String IGNORE_ID_EXCHANGE = "IgnoreIdExchange";
    private static final String LISTENER_IDLE_CONNECTION_TIMEOUT = "SecureListener.IdleConnectionTimeout";
    private static final String HTTP_PROXY_PORT = "HttpProxyPort";
    private static final String HTTP_PROXY_ENABLED = "HttpProxyEnabled";
    private static final String HTTP_PROXY_TIMEOUT = "HttpProxyTimeout";
    private static final String HTTP_PROXY_ACCESS = "HttpProxyAccessList";
    private static final String HTTP_PROXY_DESTINATION_WHITE_LIST = "HttpProxyDestinationWhiteList";
    private static final String SENDER_CERTIFICATE_CHECK = "SenderCertificateCheck";
    private static final String SENDER_CERTIFICATE_AUTH = "SenderCertificateAuth";
    private static final String DESTINATION_MAX_DATASIZE = "DestinationMaxDatasize";
    private static final String LISTENER_TYPE = "Listener.";
    private static final String TRUST_KEYSTORE_LOCATION = "TrustKeystoreLocation";
    private static final String SERVER_KEYSTORE_LOCATION = "ServerKeystoreLocation";
    private static final String PRIVATE_KEY_PASSWORD = "PrivateKeyPassword";
    private static final String SERVER_PRIVATE_KEY_PREFIX = "ServerPrivateKey.";
    private static final String SYNCHRONIZE_PARTNER_CERTIFICATES = "SynchronizePartnerCertificates";
    private static final String FTP_LISTENER_ENABLED = "FtpListenerEnabled";
    private static final String FTP_LISTENER_ADDRESS = "FtpListenerAddress";
    private static final String FTP_LISTENER_PORT = "FtpListenerPort";
    private static final String FTP_DATA_CONNECTION_ADDRESS = "FtpListenerDataConnectionAddress";
    private static final String FTP_DATA_CONNECTION_PORTS = "FtpListenerDataConnectionPorts";
    private static final String FTP_DATA_CONNECTION_ACTIVE_MODE_ALLOWED = "FtpListenerDataConnectionActiveModeAllowed";
    private static final String FTP_DATA_CONNECTION_ACTIVE_LOCAL_ADDRESS = "FtpListenerDataConnectionActiveLocalAddress";
    private static final String FTP_DATA_CONNECTION_ACTIVE_LOCAL_PORT = "FtpListenerDataConnectionActiveLocalPort";
    private static final String STARTUP_RETRIES = "StartupRetries";
    private static final String FTP_INBOUND_DIR = "FtpInboundDir.";
    private static final String FTP_PATH = ".Path";
    private static final String FTP_LISTENER = ".Listener";
    private static final String EQUAL = " = ";
    private static final byte[] CRYPTED_PW_IDENTIFIER = "PXPSLPWC".getBytes();
    private static final String COLON = ":";
    private static final String CRLF = "\r\n";
    private static final String SLASH = "/";
    private static final String HEADER_COMMENT = "#\r\n# Ponton X/P Listener configuration\r\n#\r\n# use * instead of IP if Socket should be bound to all available IP Addresses\r\n#\r\n\r\n";
    private static PasswordCrypt _passwordCrypt;
    private String _internalCommunicationHost;
    private int _internalCommunicationPort;
    private int _internalCommunicationTimeout;
    private boolean _internalCommunicationSSL;
    private String _internalCommunicationAuthorizationStore;
    private int _secureListenerIdleConnectionTimeout;
    private boolean _secureListenerHttpEnabled;
    private String _secureListenerHttpAddress;
    private int _secureListenerHttpPort;
    private boolean _secureListenerHttpsEnabled;
    private String _secureListenerHttpsAddress;
    private int _secureListenerHttpsPort;
    private boolean _senderCertificateCheck;
    private boolean _senderCertificateAuth;
    private String _serverKeystoreLocation;
    private String _trustKeystoreLocation;
    private final List<PrivateKeyInfo> _privateKeyInfos = new ArrayList<PrivateKeyInfo>();
    private boolean _synchronizePartnerCertificates;
    private Map<String, String> _listenerTypes;
    private long _forwardMaxDatasize;
    private boolean _proxyEnabled;
    private String _proxyAddress;
    private int _proxyPort;
    private String[] _proxyAccessList;
    private String[] _proxyDestinationWhiteList;
    private int _proxyTimeout;
    private boolean _ftpListenerEnabled;
    private String _ftpListenerAddress;
    private int _ftpListenerPort;
    private String _ftpDataConnectionAddress;
    private String _ftpDataConnectionPorts;
    private boolean _ftpDataConnectionActiveModeAllowed;
    private String _ftpDataConnectionActiveLocalAddress;
    private int _ftpDataConnectionActiveLocalPort;
    private Map<String, String> _ftpPathes;
    private int _startupRetries;
    private String[] _disabledSSLCiphers;
    private String _disabledSSLCiphersRegEx;
    private String[] _disabledSSLProtocols;
    private String _disabledSSLProtocolsRegEx;
    private boolean _internalCommunicationAutomaticallyAcceptFirstClient;
    private boolean ignoreIdExchange;

    public ListenerProperties(byte[] cfg) {
        this.updateConfig(cfg);
    }

    public ListenerProperties() {
    }

    private HostAndPort parseSocketAddress(String value) {
        HostAndPort result = null;
        if (value != null) {
            String[] parts = value.split(COLON);
            if (parts.length == 2) {
                String ip = parts[0];
                int port = Integer.parseInt(parts[1]);
                result = new HostAndPort(ip, port);
            } else {
                _log.error("invalid Address: " + value + " it has to be formatted   'ip:port'");
            }
        }
        return result;
    }

    private String getDecryptedPassword(String password) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        byte[] decodedPw;
        try {
            decodedPw = Base64.decode((byte[])password.getBytes());
        }
        catch (DecoderException e) {
            return password;
        }
        boolean encryptedPwFound = true;
        if (decodedPw.length > CRYPTED_PW_IDENTIFIER.length) {
            for (int i = 0; i < CRYPTED_PW_IDENTIFIER.length && encryptedPwFound; ++i) {
                if (decodedPw[i] == CRYPTED_PW_IDENTIFIER[i]) continue;
                encryptedPwFound = false;
                break;
            }
        } else {
            encryptedPwFound = false;
        }
        if (encryptedPwFound) {
            byte[] encryptedPw = new byte[decodedPw.length - CRYPTED_PW_IDENTIFIER.length];
            System.arraycopy(decodedPw, CRYPTED_PW_IDENTIFIER.length, encryptedPw, 0, encryptedPw.length);
            return _passwordCrypt.decryptPassword(encryptedPw);
        }
        return password;
    }

    private boolean readConfig(Properties config) {
        HostAndPort addr;
        boolean createDefault = config.isEmpty();
        boolean encryptedPwFound = true;
        this.setInternalCommunicationHost(config.getProperty(LISTENER_INTERNAL_IP, ANY_IP));
        this.setInternalCommunicationPort(Integer.parseInt(config.getProperty(LISTENER_INTERNAL_PORT, "9000")));
        this.setInternalCommunicationTimeout(Integer.parseInt(config.getProperty(LISTENER_INTERNAL_TIMEOUT, "10")));
        this.setInternalCommunicationSSL(Boolean.parseBoolean(config.getProperty(LISTENER_INTERNAL_SSL, "true")));
        this.setInternalCommunicationAuthorizationStore(config.getProperty(LISTENER_INTERNAL_AUTHORIZATION_STORE, "config/authorization.txt"));
        this.setAutomaticallyAcceptingFirstClient(Boolean.parseBoolean(config.getProperty(LISTENER_INTERNAL_ACCEPT_FIST_CLIENT, "true")));
        String value = config.getProperty(LISTENER_IDLE_CONNECTION_TIMEOUT, DEFAULT_IDLE_CONNECTION_TIMEOUT);
        if (value != null) {
            this.setSecureListenerIdleConnectionTimeout(Integer.parseInt(value) * 1000);
        }
        if ((value = config.getProperty(LISTENER_HTTP_ENABLED, "false")) != null) {
            this.setSecureListenerHttpEnabled(Boolean.valueOf(value));
        }
        if ((value = config.getProperty(IGNORE_ID_EXCHANGE, "false")) != null) {
            this.setIgnoreIdExchange(Boolean.valueOf(value));
        }
        if ((addr = this.parseSocketAddress(config.getProperty(LISTENER_HTTP_PORT, "*:80"))) != null) {
            this.setSecureListenerHttpAddress(addr.getHost());
            this.setSecureListenerHttpPort(addr.getPort());
        }
        if ((value = config.getProperty(LISTENER_HTTPS_ENABLED, "false")) != null) {
            this.setSecureListenerHttpsEnabled(Boolean.parseBoolean(value));
        }
        if ((value = config.getProperty(LISTENER_SNI_ENABLED, "false")) != null) {
            this.setSecureListenerSniEnabled(Boolean.parseBoolean(value));
        }
        if ((addr = this.parseSocketAddress(config.getProperty(LISTENER_HTTPS_PORT, "*:443"))) != null) {
            this.setSecureListenerHttpsAddress(addr.getHost());
            this.setSecureListenerHttpsPort(addr.getPort());
        }
        this._disabledSSLCiphersRegEx = value = config.getProperty(SSL_DISABLED_CIPHERS, "*EXPORT*,*anon*,*DES*,*_DH*,*NULL*,*SHA");
        this._disabledSSLCiphers = this.getRegExValues(value);
        this._disabledSSLProtocolsRegEx = value = config.getProperty(SSL_DISABLED_PROTOCOLS, "SSL*,TLSv1,TLSv1.1");
        this._disabledSSLProtocols = this.getRegExValues(value);
        value = config.getProperty(SENDER_CERTIFICATE_CHECK, "true");
        if (value != null) {
            this.setSenderCertificateCheck(Boolean.parseBoolean(value));
        }
        if ((value = config.getProperty(SENDER_CERTIFICATE_AUTH, "true")) != null) {
            this.setSenderCertificateAuth(Boolean.parseBoolean(value));
        }
        if ((value = config.getProperty(SERVER_KEYSTORE_LOCATION, "config/serverKeystore")) != null) {
            this.setServerKeystoreLocation(value);
        }
        if ((value = config.getProperty(TRUST_KEYSTORE_LOCATION, "config/trustKeystore")) != null) {
            this.setTrustKeystoreLocation(value);
        }
        this._privateKeyInfos.clear();
        int index = 0;
        do {
            String decryptedPassword;
            String alias = config.getProperty(SERVER_PRIVATE_KEY_PREFIX + ++index + ".Alias");
            String password = config.getProperty(SERVER_PRIVATE_KEY_PREFIX + index + ".Password");
            if (alias == null || password == null) continue;
            try {
                decryptedPassword = this.getDecryptedPassword(password);
            }
            catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                decryptedPassword = password;
            }
            if (decryptedPassword.equals(password)) {
                encryptedPwFound = false;
            }
            this._privateKeyInfos.add(new PrivateKeyInfo(alias, decryptedPassword));
        } while (this._privateKeyInfos.size() == index);
        value = config.getProperty(PRIVATE_KEY_PASSWORD);
        if (value != null) {
            try {
                String decryptedPassword = this.getDecryptedPassword(value);
                this._privateKeyInfos.add(0, new PrivateKeyInfo(DEFAULT_PRIVATEKEY_ALIAS, decryptedPassword));
            }
            catch (Exception e) {
                this._privateKeyInfos.add(0, new PrivateKeyInfo(DEFAULT_PRIVATEKEY_ALIAS, "changeit"));
            }
            encryptedPwFound = false;
        }
        if ((value = config.getProperty(SYNCHRONIZE_PARTNER_CERTIFICATES, "false")) != null) {
            this.setSynchronizePartnerCertificates(Boolean.valueOf(value));
        }
        Map<String, String> listeners = ListenerProperties.getPropertyPairs(config, LISTENER_TYPE);
        if (createDefault || listeners.isEmpty()) {
            listeners.put("Listener.0", "SoapListener");
            listeners.put("Listener.1", "AS2Listener");
            listeners.put("Listener.2", "HttpListener");
            listeners.put("Listener.3", "PlainListener");
        }
        this.setListenerTypes(listeners);
        value = config.getProperty(DESTINATION_MAX_DATASIZE, "4194304");
        if (value != null) {
            this.setForwardMaxDatasize(Integer.parseInt(value));
        }
        if ((addr = this.parseSocketAddress(config.getProperty(HTTP_PROXY_PORT, "127.0.0.1:3128"))) != null) {
            this.setProxyAddress(addr.getHost());
            this.setProxyPort(addr.getPort());
        }
        if ((value = config.getProperty(HTTP_PROXY_ACCESS, ANY_IP)) != null) {
            this._proxyAccessList = value.split(",");
        }
        if ((value = config.getProperty(HTTP_PROXY_DESTINATION_WHITE_LIST, ANY_IP)) != null) {
            this._proxyDestinationWhiteList = value.split(",");
        }
        if ((value = config.getProperty(HTTP_PROXY_ENABLED, "false")) != null) {
            this.setProxyEnabled(Boolean.valueOf(value));
        }
        if ((value = config.getProperty(HTTP_PROXY_TIMEOUT, "60000")) != null) {
            this.setProxyTimeout(Integer.valueOf(value));
        }
        if ((value = config.getProperty(FTP_LISTENER_ENABLED, "false")) != null) {
            this.setFtpListenerEnabled(Boolean.parseBoolean(value));
        }
        if ((value = config.getProperty(FTP_LISTENER_ADDRESS, ANY_IP)) != null) {
            this.setFtpListenerAddress(value);
        }
        if ((value = config.getProperty(FTP_LISTENER_PORT, "21")) != null) {
            this.setFtpListenerPort(Integer.parseInt(value));
        }
        if ((value = config.getProperty(FTP_DATA_CONNECTION_ADDRESS, ANY_IP)) != null) {
            this.setFtpDataConnectionAddress(value);
        }
        if ((value = config.getProperty(FTP_DATA_CONNECTION_PORTS, "50000-50010")) != null) {
            this.setFtpDataConnectionPorts(value);
        }
        if ((value = config.getProperty(FTP_DATA_CONNECTION_ACTIVE_MODE_ALLOWED, "false")) != null) {
            this.setFtpDataConnectionActiveModeAllowed(Boolean.valueOf(value));
        }
        if ((value = config.getProperty(FTP_DATA_CONNECTION_ACTIVE_LOCAL_ADDRESS, ANY_IP)) != null) {
            this.setFtpDataConnectionActiveLocalAddress(value);
        }
        if ((value = config.getProperty(FTP_DATA_CONNECTION_ACTIVE_LOCAL_PORT, "0")) != null) {
            this.setFtpDataConnectionActiveLocalPort(Integer.parseInt(value));
        }
        if ((value = config.getProperty(STARTUP_RETRIES, "15")) != null) {
            this.setStartupRetries(Integer.parseInt(value));
        }
        HashMap<String, String> ftpPathes = new HashMap<String, String>();
        int i = 0;
        while (true) {
            String ftpPath = config.getProperty(FTP_INBOUND_DIR + i + FTP_PATH);
            String ftpListener = config.getProperty(FTP_INBOUND_DIR + i + FTP_LISTENER);
            if (ftpPath == null || ftpListener == null) break;
            if (ftpPath.length() > 0 && ftpListener.length() > 0) {
                ftpPathes.put(ftpPath, ftpListener);
            }
            ++i;
        }
        if (createDefault || ftpPathes.isEmpty()) {
            ftpPathes.put("/inbound/plain", "PlainListener");
            ftpPathes.put("/inbound/ebxml", "SoapListener");
            ftpPathes.put("/inbound/as3", "AS3Listener");
        }
        this.setFtpPathes(ftpPathes);
        return encryptedPwFound;
    }

    public void setSecureListenerSniEnabled(boolean sniEnabled) {
        this.sniEnabled = sniEnabled;
    }

    public String getInternalCommunicationHost() {
        return this._internalCommunicationHost;
    }

    public void setInternalCommunicationHost(String internalCommunicationHost) {
        this._internalCommunicationHost = internalCommunicationHost;
    }

    public int getInternalCommunicationPort() {
        return this._internalCommunicationPort;
    }

    public void setInternalCommunicationPort(int internalCommunicationPort) {
        this._internalCommunicationPort = internalCommunicationPort;
    }

    public int getInternalCommunicationTimeout() {
        return this._internalCommunicationTimeout;
    }

    public void setInternalCommunicationTimeout(int seconds) {
        this._internalCommunicationTimeout = seconds;
    }

    public boolean isInternalCommunicationSSL() {
        return this._internalCommunicationSSL;
    }

    public void setInternalCommunicationSSL(boolean internalCommunicationSSL) {
        this._internalCommunicationSSL = internalCommunicationSSL;
    }

    public String getInternalCommunicationAuthorizationStore() {
        return this._internalCommunicationAuthorizationStore;
    }

    public void setInternalCommunicationAuthorizationStore(String authorizationFile) {
        this._internalCommunicationAuthorizationStore = authorizationFile;
    }

    public boolean isAutomaticallyAcceptingFirstClient() {
        return this._internalCommunicationAutomaticallyAcceptFirstClient;
    }

    public void setAutomaticallyAcceptingFirstClient(boolean value) {
        this._internalCommunicationAutomaticallyAcceptFirstClient = value;
    }

    public boolean getSynchronizePartnerCertificates() {
        return this._synchronizePartnerCertificates;
    }

    public void setSynchronizePartnerCertificates(boolean synchronizePartnerCertificates) {
        this._synchronizePartnerCertificates = synchronizePartnerCertificates;
    }

    public long getForwardMaxDatasize() {
        return this._forwardMaxDatasize;
    }

    public void setForwardMaxDatasize(long forwardMaxDatasize) {
        this._forwardMaxDatasize = forwardMaxDatasize;
    }

    public String getProxyAddress() {
        return this._proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this._proxyAddress = proxyAddress;
    }

    public boolean isProxyEnabled() {
        return this._proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this._proxyEnabled = proxyEnabled;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public int getSecureListenerIdleConnectionTimeout() {
        return this._secureListenerIdleConnectionTimeout;
    }

    public void setSecureListenerIdleConnectionTimeout(int secureListenerIdleConnectionTimeout) {
        this._secureListenerIdleConnectionTimeout = secureListenerIdleConnectionTimeout;
    }

    public String getSecureListenerHttpAddress() {
        return this._secureListenerHttpAddress;
    }

    public void setSecureListenerHttpAddress(String secureListenerHttpAddress) {
        this._secureListenerHttpAddress = secureListenerHttpAddress;
    }

    public boolean isSecureListenerHttpEnabled() {
        return this._secureListenerHttpEnabled;
    }

    public void setSecureListenerHttpEnabled(boolean secureListenerHttpEnabled) {
        this._secureListenerHttpEnabled = secureListenerHttpEnabled;
    }

    public int getSecureListenerHttpPort() {
        return this._secureListenerHttpPort;
    }

    public void setSecureListenerHttpPort(int secureListenerHttpPort) {
        this._secureListenerHttpPort = secureListenerHttpPort;
    }

    public String getSecureListenerHttpsAddress() {
        return this._secureListenerHttpsAddress;
    }

    public void setSecureListenerHttpsAddress(String secureListenerHttpsAddress) {
        this._secureListenerHttpsAddress = secureListenerHttpsAddress;
    }

    public boolean isSecureListenerHttpsEnabled() {
        return this._secureListenerHttpsEnabled;
    }

    public void setSecureListenerHttpsEnabled(boolean secureListenerHttpsEnabled) {
        this._secureListenerHttpsEnabled = secureListenerHttpsEnabled;
    }

    public int getSecureListenerHttpsPort() {
        return this._secureListenerHttpsPort;
    }

    public void setSecureListenerHttpsPort(int secureListenerHttpsPort) {
        this._secureListenerHttpsPort = secureListenerHttpsPort;
    }

    public boolean isSenderCertificateCheck() {
        return this._senderCertificateCheck;
    }

    public void setSenderCertificateCheck(boolean senderCertificateCheck) {
        this._senderCertificateCheck = senderCertificateCheck;
    }

    public boolean isSenderCertificateAuth() {
        return this._senderCertificateAuth;
    }

    public void setSenderCertificateAuth(boolean senderCertificateAuth) {
        this._senderCertificateAuth = senderCertificateAuth;
    }

    public String getServerKeystoreLocation() {
        return this._serverKeystoreLocation;
    }

    public void setServerKeystoreLocation(String serverKeystoreLocation) {
        this._serverKeystoreLocation = serverKeystoreLocation;
    }

    public String getTrustKeystoreLocation() {
        return this._trustKeystoreLocation;
    }

    public void setTrustKeystoreLocation(String trustKeystoreLocation) {
        this._trustKeystoreLocation = trustKeystoreLocation;
    }

    public void addPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        this._privateKeyInfos.add(privateKeyInfo);
    }

    public List<PrivateKeyInfo> getPrivateKeyInfos() {
        return List.copyOf(this._privateKeyInfos);
    }

    public void removePrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        this._privateKeyInfos.remove(privateKeyInfo);
    }

    private String getEncodedPassword(String password) {
        try {
            byte[] cryptedPW = _passwordCrypt.encryptPassword(password);
            byte[] cryptedPwWithPrefix = new byte[CRYPTED_PW_IDENTIFIER.length + cryptedPW.length];
            System.arraycopy(CRYPTED_PW_IDENTIFIER, 0, cryptedPwWithPrefix, 0, CRYPTED_PW_IDENTIFIER.length);
            System.arraycopy(cryptedPW, 0, cryptedPwWithPrefix, CRYPTED_PW_IDENTIFIER.length, cryptedPW.length);
            return new String(Base64.encode((byte[])cryptedPwWithPrefix));
        }
        catch (Exception e) {
            return password;
        }
    }

    public StringBuilder createConfig() {
        StringBuilder config = new StringBuilder();
        config.append(HEADER_COMMENT);
        config.append("# Ponton XP Messenger instances will connect to this port.");
        config.append(CRLF);
        config.append("# this should not be accessible from the internet");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, LISTENER_INTERNAL_IP, this.getInternalCommunicationHost());
        ListenerProperties.writeEntry(config, LISTENER_INTERNAL_PORT, this.getInternalCommunicationPort());
        ListenerProperties.writeEntry(config, LISTENER_INTERNAL_TIMEOUT, this.getInternalCommunicationTimeout());
        ListenerProperties.writeEntry(config, LISTENER_INTERNAL_SSL, this.isInternalCommunicationSSL());
        ListenerProperties.writeEntry(config, LISTENER_INTERNAL_ACCEPT_FIST_CLIENT, this.isAutomaticallyAcceptingFirstClient());
        ListenerProperties.writeEntry(config, LISTENER_INTERNAL_AUTHORIZATION_STORE, this.getInternalCommunicationAuthorizationStore());
        ListenerProperties.writeEntry(config, IGNORE_ID_EXCHANGE, this.isIgnoreIdExchange());
        config.append(CRLF);
        config.append("# SecureListener");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, LISTENER_IDLE_CONNECTION_TIMEOUT, this.getSecureListenerIdleConnectionTimeout() / 1000);
        ListenerProperties.writeEntry(config, LISTENER_HTTP_PORT, this.getSecureListenerHttpAddress() + COLON + this.getSecureListenerHttpPort());
        ListenerProperties.writeEntry(config, LISTENER_HTTP_ENABLED, this.isSecureListenerHttpEnabled());
        ListenerProperties.writeEntry(config, LISTENER_HTTPS_PORT, this.getSecureListenerHttpsAddress() + COLON + this.getSecureListenerHttpsPort());
        ListenerProperties.writeEntry(config, LISTENER_HTTPS_ENABLED, this.isSecureListenerHttpsEnabled());
        ListenerProperties.writeEntry(config, LISTENER_SNI_ENABLED, this.isSecureListenerSniEnabled());
        ListenerProperties.writeEntry(config, SENDER_CERTIFICATE_CHECK, this.isSenderCertificateCheck());
        ListenerProperties.writeEntry(config, SENDER_CERTIFICATE_AUTH, this.isSenderCertificateAuth());
        ListenerProperties.writeEntry(config, SERVER_KEYSTORE_LOCATION, this.getServerKeystoreLocation());
        ListenerProperties.writeEntry(config, TRUST_KEYSTORE_LOCATION, this.getTrustKeystoreLocation());
        for (int i = 0; i < this._privateKeyInfos.size(); ++i) {
            PrivateKeyInfo privateKeyInfo = this._privateKeyInfos.get(i);
            ListenerProperties.writeEntry(config, SERVER_PRIVATE_KEY_PREFIX + (i + 1) + ".Alias", privateKeyInfo.alias());
            ListenerProperties.writeEntry(config, SERVER_PRIVATE_KEY_PREFIX + (i + 1) + ".Password", this.getEncodedPassword(privateKeyInfo.password()));
        }
        ListenerProperties.writeEntry(config, SYNCHRONIZE_PARTNER_CERTIFICATES, this.getSynchronizePartnerCertificates());
        config.append("# any listed Cipher ID that is known to the Listener will be rejected on incoming SSL connections. ");
        config.append(CRLF);
        config.append("# the list of known cipher-IDs is logged at startup in the listener.log");
        config.append(CRLF);
        config.append("# '*' can be used as wildcard to disable multiple ciphers. ");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, SSL_DISABLED_CIPHERS, this.getDisabledSSLCiphersRegEx());
        ListenerProperties.writeEntry(config, SSL_DISABLED_PROTOCOLS, this.getDisabledSSLProtocolsRegEx());
        this.writeListeners(config);
        config.append("# incoming data is accepted up to this size in bytes");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, DESTINATION_MAX_DATASIZE, this.getForwardMaxDatasize());
        config.append(CRLF);
        config.append("# HttpProxyServer");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, HTTP_PROXY_PORT, this.getProxyAddress() + COLON + this.getProxyPort());
        ListenerProperties.writeEntry(config, HTTP_PROXY_ENABLED, this.isProxyEnabled());
        config.append("# use one or more IP addresses separated by commas for the proxy access list");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, HTTP_PROXY_ACCESS, this.getProxyAccessList());
        config.append("# the values for the white list need to be the host names/IPs used in the URLs that are given in the request URL.");
        config.append(CRLF);
        config.append("# multiple entries need to be comma separated.  use * to allow all destinations");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, HTTP_PROXY_DESTINATION_WHITE_LIST, this.getProxyDestinationWhiteList());
        config.append(CRLF);
        config.append("# Ftp configuration");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, FTP_LISTENER_ENABLED, this.isFtpListenerEnabled());
        ListenerProperties.writeEntry(config, FTP_LISTENER_ADDRESS, this.getFtpListenerAddress());
        ListenerProperties.writeEntry(config, FTP_LISTENER_PORT, this.getFtpListenerPort());
        config.append(CRLF);
        config.append("# settings for FTP passive mode transmissions");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, FTP_DATA_CONNECTION_ADDRESS, this.getFtpDataConnectionAddress());
        config.append("# when 0 is set, a random available port is used as server port for data transmissions");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, FTP_DATA_CONNECTION_PORTS, this.getFtpDataConnectionPorts());
        config.append(CRLF);
        config.append("# Passive mode is always allowed, but active mode is disabled by default");
        config.append(CRLF);
        config.append("# settings for FTP active mode transmissions");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, FTP_DATA_CONNECTION_ACTIVE_MODE_ALLOWED, this.isFtpDataConnectionActiveModeAllowed());
        ListenerProperties.writeEntry(config, FTP_DATA_CONNECTION_ACTIVE_LOCAL_ADDRESS, this.getFtpDataConnectionActiveLocalAddress());
        config.append("# when 0 is set, a random available port is used as local client port for data transmissions");
        config.append(CRLF);
        ListenerProperties.writeEntry(config, FTP_DATA_CONNECTION_ACTIVE_LOCAL_PORT, this.getFtpDataConnectionActiveLocalPort());
        config.append(CRLF);
        config.append("# Ftp inbound folders mapping. (FTP folder to Messenger URLs)");
        config.append(CRLF);
        this.writeFtpPathes(config);
        config.append(CRLF);
        ListenerProperties.writeEntry(config, STARTUP_RETRIES, this.getStartupRetries());
        return config;
    }

    public boolean isSecureListenerSniEnabled() {
        return this.sniEnabled;
    }

    private void writeFtpPathes(StringBuilder config) {
        Set<String> ftpPathesSet = this.getFtpPathes().keySet();
        ArrayList<String> ftpPathes = new ArrayList<String>(ftpPathesSet);
        Collections.sort(ftpPathes);
        for (int i = 0; i < ftpPathes.size(); ++i) {
            ListenerProperties.writeEntry(config, FTP_INBOUND_DIR + i + FTP_PATH, (String)ftpPathes.get(i));
            ListenerProperties.writeEntry(config, FTP_INBOUND_DIR + i + FTP_LISTENER, this.getFtpPathes().get(ftpPathes.get(i)));
        }
    }

    private void writeListeners(StringBuilder config) {
        Set<String> listenersKeysSet = this.getListenerTypes().keySet();
        ArrayList<String> listenersKeys = new ArrayList<String>(listenersKeysSet);
        Collections.sort(listenersKeys);
        for (String listenerKey : listenersKeys) {
            ListenerProperties.writeEntry(config, listenerKey, this.getListenerTypes().get(listenerKey));
        }
    }

    public static void writeEntry(StringBuilder config, String key, String value) {
        config.append(key);
        config.append(EQUAL);
        config.append(value);
        config.append(CRLF);
    }

    public static void writeEntry(StringBuilder config, String key, String[] value) {
        config.append(key);
        config.append(EQUAL);
        for (int i = 0; value != null && i < value.length; ++i) {
            if (i > 0) {
                config.append(",");
            }
            config.append(value[i]);
        }
        config.append(CRLF);
    }

    public static void writeEntry(StringBuilder config, String key, boolean value) {
        ListenerProperties.writeEntry(config, key, String.valueOf(value));
    }

    public static void writeEntry(StringBuilder config, String key, int value) {
        ListenerProperties.writeEntry(config, key, String.valueOf(value));
    }

    public static void writeEntry(StringBuilder config, String key, long value) {
        ListenerProperties.writeEntry(config, key, String.valueOf(value));
    }

    public static String[] getPropertiesValues(Properties properties, String keyPart) {
        Collection<String> values = ListenerProperties.getPropertyPairs(properties, keyPart).values();
        return values.toArray(new String[values.size()]);
    }

    public static String[] getPropertiesFullKeys(Properties property, String keyPart) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<Object> keys = property.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(keyPart)) continue;
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    public static Map<String, String> getPropertyPairs(Properties properties, String keyPart) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] keys = ListenerProperties.getPropertiesFullKeys(properties, keyPart);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            result.put(key, properties.getProperty(key));
        }
        return result;
    }

    public void storeConfig(File toFile) throws IOException {
        try (FileOutputStream configFileStream = new FileOutputStream(toFile.getAbsoluteFile());){
            this.storeConfig(configFileStream);
        }
    }

    public void storeConfig(OutputStream outputStream) throws IOException {
        try {
            outputStream.write(this.createConfig().toString().getBytes());
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (Exception e) {
                _log.error("could not flush config." + String.valueOf(e));
            }
        }
    }

    public Map<String, String> getListenerTypes() {
        return this._listenerTypes;
    }

    public void setListenerTypes(Map<String, String> listenerTypes) {
        this._listenerTypes = listenerTypes;
    }

    public String[] getAllowedListenerTypes() {
        Collection<String> allowedListerTypes = this.getListenerTypes().values();
        return allowedListerTypes.toArray(new String[allowedListerTypes.size()]);
    }

    public String getForwardPath(String path) {
        return "http://127.0.0.1/pontonxp/" + path;
    }

    public String getListenerPath(String listener) {
        return "pontonxp/" + listener;
    }

    public boolean isFtpListenerEnabled() {
        return this._ftpListenerEnabled;
    }

    public void setFtpListenerEnabled(boolean ftpListenerEnabled) {
        this._ftpListenerEnabled = ftpListenerEnabled;
    }

    public String getFtpDataConnectionAddress() {
        return this._ftpDataConnectionAddress;
    }

    public void setFtpDataConnectionAddress(String ftpDataConnectionAddress) {
        this._ftpDataConnectionAddress = ftpDataConnectionAddress;
    }

    public String getFtpDataConnectionPorts() {
        return this._ftpDataConnectionPorts;
    }

    public Integer getFtpDataConnectionFromPort() {
        if (this.getFtpDataConnectionPorts() == null) {
            return null;
        }
        String[] portArray = this.getFtpDataConnectionPorts().split("-");
        if (portArray.length > 0) {
            return Integer.valueOf(portArray[0]);
        }
        return null;
    }

    public Integer getFtpDataConnectionToPort() {
        if (this.getFtpDataConnectionPorts() == null) {
            return null;
        }
        String[] portArray = this.getFtpDataConnectionPorts().split("-");
        if (portArray.length > 1) {
            return Integer.valueOf(portArray[1]);
        }
        return null;
    }

    public void setFtpDataConnectionPorts(String ftpDataConnectionPorts) {
        this._ftpDataConnectionPorts = ftpDataConnectionPorts;
    }

    public boolean isFtpDataConnectionActiveModeAllowed() {
        return this._ftpDataConnectionActiveModeAllowed;
    }

    public void setFtpDataConnectionActiveModeAllowed(boolean ftpDataConnectionActiveModeAllowed) {
        this._ftpDataConnectionActiveModeAllowed = ftpDataConnectionActiveModeAllowed;
    }

    public String getFtpDataConnectionActiveLocalAddress() {
        return this._ftpDataConnectionActiveLocalAddress;
    }

    public void setFtpDataConnectionActiveLocalAddress(String ftpDataConnectionActiveLocalAddress) {
        this._ftpDataConnectionActiveLocalAddress = ftpDataConnectionActiveLocalAddress;
    }

    public int getFtpDataConnectionActiveLocalPort() {
        return this._ftpDataConnectionActiveLocalPort;
    }

    public void setFtpDataConnectionActiveLocalPort(int ftpDataConnectionActiveLocalPort) {
        this._ftpDataConnectionActiveLocalPort = ftpDataConnectionActiveLocalPort;
    }

    public String getFtpListenerAddress() {
        return this._ftpListenerAddress;
    }

    public void setFtpListenerAddress(String ftpListenerAddress) {
        this._ftpListenerAddress = ftpListenerAddress;
    }

    public int getFtpListenerPort() {
        return this._ftpListenerPort;
    }

    public void setFtpListenerPort(int ftpListenerPort) {
        this._ftpListenerPort = ftpListenerPort;
    }

    public Map<String, String> getFtpPathes() {
        return this._ftpPathes;
    }

    public void setFtpPathes(Map<String, String> ftpPathes) {
        this._ftpPathes = ftpPathes;
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    public String[] getProxyAccessList() {
        return this._proxyAccessList;
    }

    public void setProxyAccessList(String[] list) {
        this._proxyAccessList = list;
    }

    public String[] getProxyDestinationWhiteList() {
        return this._proxyDestinationWhiteList;
    }

    public void setProxyDestinationWhiteList(String[] list) {
        this._proxyDestinationWhiteList = list;
    }

    private void setProxyTimeout(int timeout) {
        this._proxyTimeout = timeout;
    }

    public String[] getDisabledSSLCiphers() {
        return this._disabledSSLCiphers;
    }

    private String getDisabledSSLCiphersRegEx() {
        return this._disabledSSLCiphersRegEx;
    }

    public String[] getDisabledProtocols() {
        return this._disabledSSLProtocols;
    }

    private String getDisabledSSLProtocolsRegEx() {
        return this._disabledSSLProtocolsRegEx;
    }

    public int getStartupRetries() {
        return this._startupRetries;
    }

    public boolean isIgnoreIdExchange() {
        return this.ignoreIdExchange;
    }

    public ListenerProperties setIgnoreIdExchange(boolean ignoreIdExchange) {
        this.ignoreIdExchange = ignoreIdExchange;
        return this;
    }

    public void setStartupRetries(int startupRetries) {
        this._startupRetries = startupRetries;
    }

    public void updateConfig(byte[] cfg) {
        try {
            Properties config = new Properties();
            config.load(new ByteArrayInputStream(cfg));
            this.updateConfig(config);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateConfig(Properties config) {
        this.readConfig(new NoDefaultsProperties(config));
    }

    public void readConfig(File fromFile, File toFile) throws IOException {
        try (FileInputStream configIn = new FileInputStream(fromFile);){
            boolean passwordEncrypted;
            Properties config = new Properties();
            if (fromFile.exists()) {
                config.load(configIn);
            }
            if (!(passwordEncrypted = this.readConfig(config))) {
                try {
                    this.storeConfig(toFile);
                }
                catch (IOException e) {
                    _log.error("config could not be stored to encrypt passwords. " + String.valueOf(e));
                }
            }
        }
    }

    private String[] getRegExValues(String values) {
        ArrayList<String> regExArray = new ArrayList<String>();
        for (String value : values.split(",")) {
            regExArray.add(value.trim().replace(ANY_IP, ".*"));
        }
        return regExArray.toArray(new String[0]);
    }

    static {
        if (_passwordCrypt == null) {
            try {
                _passwordCrypt = new PasswordCrypt("IpIndependent");
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    class HostAndPort {
        private final String host;
        private final int port;

        HostAndPort(String myHost, int myPort) {
            this.host = myHost;
            this.port = myPort;
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }
    }

    public record PrivateKeyInfo(String alias, String password) {
    }

    class NoDefaultsProperties
    extends Properties {
        private static final long serialVersionUID = 1041542084071583333L;

        public NoDefaultsProperties(Properties properties) {
            super(properties);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return this.getProperty(key);
        }
    }
}

