/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcherEntry;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerWebExchangeDelegatingServerHttpHeadersWriter
implements ServerHttpHeadersWriter {
    private final ServerWebExchangeMatcherEntry<ServerHttpHeadersWriter> headersWriter;

    public ServerWebExchangeDelegatingServerHttpHeadersWriter(ServerWebExchangeMatcherEntry<ServerHttpHeadersWriter> headersWriter) {
        Assert.notNull(headersWriter, (String)"headersWriter cannot be null");
        Assert.notNull((Object)headersWriter.getMatcher(), (String)"webExchangeMatcher cannot be null");
        Assert.notNull((Object)headersWriter.getEntry(), (String)"delegateHeadersWriter cannot be null");
        this.headersWriter = headersWriter;
    }

    public ServerWebExchangeDelegatingServerHttpHeadersWriter(ServerWebExchangeMatcher webExchangeMatcher, ServerHttpHeadersWriter delegateHeadersWriter) {
        this(new ServerWebExchangeMatcherEntry<ServerHttpHeadersWriter>(webExchangeMatcher, delegateHeadersWriter));
    }

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange) {
        return this.headersWriter.getMatcher().matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).flatMap(matchResult -> this.headersWriter.getEntry().writeHttpHeaders(exchange));
    }
}

