/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

public class WeightedRandomLoadBalancer
extends WeightedLoadBalancer {
    public WeightedRandomLoadBalancer(List<Integer> distributionRatioList) {
        super(distributionRatioList);
    }

    @Override
    protected AsyncProcessor chooseProcessor(AsyncProcessor[] processors, Exchange exchange) {
        this.lock.lock();
        try {
            int randomWeight = ThreadLocalRandom.current().nextInt(this.runtimeRatioSum);
            int choiceWeight = 0;
            int index = 0;
            while (true) {
                DistributionRatio ratio;
                if (randomWeight < (choiceWeight += (ratio = this.getRatios().get(index)).getRuntimeWeight())) {
                    ratio.decrement();
                    this.decrementSum();
                    this.lastIndex = index;
                    AsyncProcessor asyncProcessor = processors[index];
                    return asyncProcessor;
                }
                ++index;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

