/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.EncodingMap;
import de.pontonconsulting.xmlpipe.message.StopParsingException;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXWriter
extends DefaultHandler
implements LexicalHandler {
    private static final String TRANSMISSION_MODE = "TransmissionMode";
    private static final String TRANSMISSION_PROTOCOL = "TransmissionProtocol";
    private static final String TYPE = "Type";
    private static final String VALUE = "Value";
    private static final String EMPTY = "";
    private static final String PROCESSING_DIRECTIVES = "ProcessingDirectives";
    private static final String PAYLOAD = "Payload";
    private static final String MESSAGE_META_DATA = "MessageMetaData";
    private static final String DOCUMENT_INFO = "DocumentInfo";
    private static final String MESSAGE_NAME = "MessageName";
    private static final String TEST_FLAG = "TestFlag";
    private static final String LOG_INFO = "LogInfo";
    private static final String DTD_VERSION_NUMBER = "DTDVersionNumber";
    private static final String DTD_SET = "DTDSet";
    private static final String MESSAGE = "Message";
    private static final String ENVELOPE = "Envelope";
    private static final String TRANSMISSION_INFORMATION = "TransmissionInformation";
    private static final String TRANSMISSION_CHARACTERISTICS = "TransmissionCharacteristics";
    private static final String TRANSFER_ID = "TransferID";
    private static final String TRANSMISSION_TIMESTAMP = "TransmissionTimeStamp";
    private static final String CONVERSATION_ID = "ConversationID";
    private static final String SEQUENCE_NUMBER = "SequenceNumber";
    private static final String TRANSMISSION_ORG_ID = "TransmissionOrganisationIdentifiers";
    private static final String SENDER_ORG = "SenderOrganisation";
    private static final String RECEIVER_ORG = "ReceiverOrganisation";
    private static final char XPATH_SEPARATOR = '/';
    private static final String LF = "\n";
    private static final String CR_LF = "\r\n";
    private static final String CR = "\r";
    protected PrintWriter _out;
    protected int _elementDepth;
    protected boolean _inCDATA;
    private final HashMap _namespaces = new HashMap();
    private String _encoding = "UTF-8";
    private String _lineEnding = "\n";
    private final ArrayList _xpath = new ArrayList();
    private int _xpathLevel;
    private String _currentXPath;
    private String _startOnElement;
    private boolean _payloadStart;
    private boolean _foundElement;
    private BackEndMessage _backendMessage;
    private int _endDepth;
    private String _docType = null;

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            this._encoding = encoding;
        }
        String javaEncoding = EncodingMap.iana2java(encoding);
        OutputStreamWriter writer = new OutputStreamWriter(stream, javaEncoding);
        this._out = new PrintWriter(writer);
    }

    public void setOutput(Writer writer) {
        this._out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setBackendMessage(BackEndMessage backendMessage) {
        this._backendMessage = backendMessage;
    }

    @Override
    public void startDocument() throws SAXException {
        this._elementDepth = 0;
        this._inCDATA = false;
        this._xpath.add(0, EMPTY);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._namespaces.put(uri, prefix);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this._payloadStart && this._elementDepth > 0) {
            this._out.print("<?");
            this._out.print(target);
            if (data != null && data.length() > 0) {
                this._out.print(' ');
                this._out.print(data);
            }
            this._out.print("?>");
            this._out.flush();
        }
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        this._currentXPath = (String)this._xpath.get(this._xpathLevel) + '/' + local;
        ++this._xpathLevel;
        if (this._xpath.size() > this._xpathLevel && this._xpath.get(this._xpathLevel) != null) {
            this._xpath.remove(this._xpathLevel);
        }
        this._xpath.add(this._xpathLevel, this._currentXPath);
        if (this._startOnElement != null) {
            if (this._startOnElement.equals(this._currentXPath) && !this._foundElement) {
                this._foundElement = true;
                if (this._backendMessage != null) {
                    this.createEnvelopeHeader();
                }
                this._endDepth = this._elementDepth;
                return;
            }
        } else if (!this._foundElement) {
            this._foundElement = true;
            if (this._backendMessage != null) {
                this.createEnvelopeHeader();
            }
            this._endDepth = this._elementDepth;
        }
        if (!this._foundElement) {
            return;
        }
        this._payloadStart = true;
        this.writeElement(raw, attrs);
    }

    private void writeElement(String raw, Attributes attrs) {
        if (this._elementDepth == 0) {
            this._out.print("<?xml version=\"1.0\" encoding=\"" + this._encoding + "\"?>");
            this._out.print(this._lineEnding);
            this._out.flush();
            if (this._docType != null) {
                this._out.print(this._docType);
            }
            this._out.flush();
        }
        ++this._elementDepth;
        this._out.print('<');
        this._out.print(raw);
        for (String namespace : this._namespaces.keySet()) {
            String prefix = (String)this._namespaces.get(namespace);
            if (prefix.equals(EMPTY)) {
                this._out.print(" xmlns=\"");
            } else {
                this._out.print(" xmlns:");
                this._out.print(prefix);
                this._out.print("=\"");
            }
            this._out.print(namespace);
            this._out.print("\"");
        }
        this._namespaces.clear();
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                this._out.print(' ');
                this._out.print(attrs.getQName(i));
                this._out.print("=\"");
                this.normalizeAndPrint(attrs.getValue(i).toCharArray());
                this._out.print('\"');
            }
        }
        this._out.print('>');
        this._out.flush();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._payloadStart) {
            this.writeCharacters(ch, start, length);
        }
    }

    private void writeCharacters(char[] ch, int start, int length) {
        boolean hasR = false;
        for (int i = 0; i < length; ++i) {
            char tempChar = ch[start + i];
            if (tempChar == '\r') {
                if (hasR) {
                    this.writeCharacters(this._lineEnding);
                    hasR = true;
                    continue;
                }
                hasR = true;
                continue;
            }
            if (tempChar == '\n') {
                if (hasR) {
                    this.writeCharacters(this._lineEnding);
                    hasR = false;
                    continue;
                }
                this.writeCharacters(this._lineEnding);
                continue;
            }
            if (hasR) {
                this.writeCharacters(this._lineEnding);
                hasR = false;
            }
            if (!this._inCDATA) {
                this.normalizeAndPrint(tempChar);
                continue;
            }
            this._out.print(tempChar);
        }
        this._out.flush();
    }

    private void writeCharacters(String text) {
        if (text != null) {
            this._out.print(text);
            this._out.flush();
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this._payloadStart) {
            this.characters(ch, start, length);
            this._out.flush();
        }
    }

    @Override
    public void endElement(String uri, String local, String raw) throws SAXException {
        --this._xpathLevel;
        if (this._payloadStart) {
            this.writeEndElement(raw);
            if (this._elementDepth == this._endDepth) {
                throw new StopParsingException("Current element depth equals the end depth.");
            }
        }
    }

    private void writeEndElement(String raw) {
        --this._elementDepth;
        this._out.print("</");
        this._out.print(raw);
        this._out.print('>');
        this._out.flush();
        if (this._elementDepth == this._endDepth && this._backendMessage != null && this._currentXPath != null) {
            this.createEnvelopeFooter();
            this._elementDepth = this._endDepth;
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this._docType = "<!DOCTYPE ";
        this._docType = this._docType + name + " ";
        if (publicId == null) {
            this._docType = this._docType + "SYSTEM ";
            this._docType = this._docType + "\"" + systemId + "\"";
        } else {
            this._docType = this._docType + "PUBLIC ";
            this._docType = this._docType + "\"" + publicId + "\"";
            this._docType = this._docType + " ";
            this._docType = this._docType + "\"" + systemId + "\"";
        }
    }

    @Override
    public void endDTD() throws SAXException {
        this._docType = this._docType + ">";
        this._docType = this._docType + this._lineEnding;
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this._payloadStart) {
            this._out.print("<![CDATA[");
            this._inCDATA = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this._payloadStart) {
            this._inCDATA = false;
            this._out.print("]]>");
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this._payloadStart && this._elementDepth > 0) {
            this._out.print("<!--");
            for (int i = 0; i < length; ++i) {
                this._out.print(ch[start + i]);
            }
            this._out.print("-->");
            this._out.flush();
        }
    }

    private void normalizeAndPrint(char[] ch) {
        for (int i = 0; i < ch.length; ++i) {
            this.normalizeAndPrint(ch[i]);
        }
    }

    private void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this._out.print("&lt;");
                break;
            }
            case '>': {
                this._out.print("&gt;");
                break;
            }
            case '&': {
                this._out.print("&amp;");
                break;
            }
            case '\'': {
                this._out.print("&apos;");
                break;
            }
            case '\"': {
                this._out.print("&quot;");
                break;
            }
            default: {
                this._out.print(c);
            }
        }
    }

    public void startOnElement(String xpath) {
        this._startOnElement = xpath;
    }

    private void createEnvelopeHeader() {
        String testFlag;
        this.writeElement(ENVELOPE, null);
        this.writeCharacters(this._lineEnding);
        this.writeElement(TRANSMISSION_INFORMATION, null);
        this.writeCharacters(this._lineEnding);
        AttributesImpl transmissionAttributes = new AttributesImpl();
        if (this._backendMessage.getTransmissionProtocol() != null) {
            transmissionAttributes.addAttribute(EMPTY, TRANSMISSION_PROTOCOL, TRANSMISSION_PROTOCOL, EMPTY, this._backendMessage.getTransmissionProtocol());
        }
        if (this._backendMessage.getTransmissionMode() != null) {
            transmissionAttributes.addAttribute(EMPTY, TRANSMISSION_MODE, TRANSMISSION_MODE, EMPTY, this._backendMessage.getTransmissionMode());
        }
        this.writeElement(TRANSMISSION_CHARACTERISTICS, transmissionAttributes);
        this.writeCharacters(this._lineEnding);
        this.writeElement(TRANSFER_ID, null);
        String transferId = this._backendMessage.getTransferIDText();
        if (transferId != null && transferId.length() > 0) {
            this.writeCharacters(transferId);
        }
        this.writeEndElement(TRANSFER_ID);
        this.writeCharacters(this._lineEnding);
        this.writeElement(TRANSMISSION_TIMESTAMP, null);
        String transmissionTime = this._backendMessage.getTransmissionTimeStampText();
        if (transmissionTime != null && transmissionTime.length() > 0) {
            this.writeCharacters(transmissionTime);
        }
        this.writeEndElement(TRANSMISSION_TIMESTAMP);
        this.writeCharacters(this._lineEnding);
        AttributesImpl conversationAttributes = new AttributesImpl();
        if (this._backendMessage.getSequenceNumberText() != null) {
            conversationAttributes.addAttribute(EMPTY, SEQUENCE_NUMBER, SEQUENCE_NUMBER, EMPTY, this._backendMessage.getSequenceNumberText());
        }
        this.writeElement(CONVERSATION_ID, conversationAttributes);
        String convId = this._backendMessage.getConversationIDText();
        if (convId != null && convId.length() > 0) {
            this.writeCharacters(convId);
        }
        this.writeEndElement(CONVERSATION_ID);
        this.writeCharacters(this._lineEnding);
        this.writeEndElement(TRANSMISSION_CHARACTERISTICS);
        this.writeCharacters(this._lineEnding);
        this.writeElement(TRANSMISSION_ORG_ID, null);
        this.writeCharacters(this._lineEnding);
        this.writeElement(SENDER_ORG, null);
        String sender = this._backendMessage.getSenderOrganisationText();
        if (sender != null && sender.length() > 0) {
            this.writeCharacters(sender);
        }
        this.writeEndElement(SENDER_ORG);
        this.writeCharacters(this._lineEnding);
        this.writeElement(RECEIVER_ORG, null);
        String receiver = this._backendMessage.getReceiverOrganisationText();
        if (receiver != null && receiver.length() > 0) {
            this.writeCharacters(receiver);
        }
        this.writeEndElement(RECEIVER_ORG);
        this.writeCharacters(this._lineEnding);
        this.writeEndElement(TRANSMISSION_ORG_ID);
        this.writeCharacters(this._lineEnding);
        HashMap<String, String> processingDirectives = this._backendMessage.getProcessingDirectivesMap();
        if (processingDirectives.size() > 0) {
            this.writeElement(PROCESSING_DIRECTIVES, null);
            for (String type : processingDirectives.keySet()) {
                String value = processingDirectives.get(type);
                AttributesImpl attr = new AttributesImpl();
                attr.addAttribute(EMPTY, TYPE, TYPE, EMPTY, type);
                this.writeElement(VALUE, attr);
                if (value != null) {
                    this.writeCharacters(value);
                }
                this.writeEndElement(VALUE);
                this.writeCharacters(this._lineEnding);
            }
            this.writeEndElement(PROCESSING_DIRECTIVES);
            this.writeCharacters(this._lineEnding);
        }
        this.writeEndElement(TRANSMISSION_INFORMATION);
        this.writeCharacters(this._lineEnding);
        this.writeElement(PAYLOAD, null);
        this.writeCharacters(this._lineEnding);
        this.writeElement(MESSAGE_META_DATA, null);
        this.writeCharacters(this._lineEnding);
        AttributesImpl docAttr = new AttributesImpl();
        String messageName = this._backendMessage.getMessageName();
        if (messageName != null && messageName.length() > 0) {
            docAttr.addAttribute(EMPTY, MESSAGE_NAME, MESSAGE_NAME, EMPTY, messageName);
        }
        if ((testFlag = this._backendMessage.getTestFlag()) != null && testFlag.length() > 0) {
            docAttr.addAttribute(EMPTY, TEST_FLAG, TEST_FLAG, EMPTY, testFlag);
        }
        this.writeElement(DOCUMENT_INFO, docAttr);
        this.writeCharacters(this._lineEnding);
        String logInfo = this._backendMessage.getLogInfoText();
        if (logInfo != null && logInfo.length() > 0) {
            this.writeElement(LOG_INFO, null);
            this.writeCharacters(logInfo);
            this.writeEndElement(LOG_INFO);
            this.writeCharacters(this._lineEnding);
        }
        this.writeElement(DTD_VERSION_NUMBER, null);
        String dtdVersion = this._backendMessage.getDTDVersionNumberText();
        if (dtdVersion != null && dtdVersion.length() > 0) {
            this.writeCharacters(dtdVersion);
        }
        this.writeEndElement(DTD_VERSION_NUMBER);
        this.writeCharacters(this._lineEnding);
        String dtdSet = this._backendMessage.getDTDSetText();
        if (dtdSet != null && dtdSet.length() > 0) {
            this.writeElement(DTD_SET, null);
            this.writeCharacters(dtdSet);
            this.writeEndElement(DTD_SET);
            this.writeCharacters(this._lineEnding);
        }
        this.writeEndElement(DOCUMENT_INFO);
        this.writeCharacters(this._lineEnding);
        this.writeEndElement(MESSAGE_META_DATA);
        this.writeCharacters(this._lineEnding);
        this.writeElement(MESSAGE, null);
        this.writeCharacters(this._lineEnding);
    }

    private void createEnvelopeFooter() {
        this.writeCharacters(this._lineEnding);
        this.writeEndElement(MESSAGE);
        this.writeCharacters(this._lineEnding);
        this.writeEndElement(PAYLOAD);
        this.writeCharacters(this._lineEnding);
        this.writeEndElement(ENVELOPE);
    }

    public void envelopeOnly() throws SAXException {
        this.createEnvelopeHeader();
        this.createEnvelopeFooter();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new ByteArrayInputStream(EMPTY.getBytes()));
    }

    public void setLineEnding(String lineEnding) {
        if ("LF".equals(lineEnding)) {
            this._lineEnding = LF;
        } else if ("CR LF".equals(lineEnding)) {
            this._lineEnding = CR_LF;
        } else if ("CR".equals(lineEnding)) {
            this._lineEnding = CR;
        }
    }
}

