/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.encoding;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class Base64Encoder
extends FilterOutputStream {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private int charCount;
    private int carryOver;
    private final int bytesPerLine;

    public Base64Encoder(OutputStream out) {
        this(out, 76);
    }

    public Base64Encoder(OutputStream out, int lineLength) {
        super(out);
        this.bytesPerLine = (int)((double)lineLength / 1.3333 + 0.5);
    }

    @Override
    public void write(int b) throws IOException {
        if (b < 0) {
            b += 256;
        }
        if (this.charCount % 3 == 0) {
            int lookup = b >> 2;
            this.carryOver = b & 3;
            this.out.write(chars[lookup]);
        } else if (this.charCount % 3 == 1) {
            int lookup = (this.carryOver << 4) + (b >> 4) & 0x3F;
            this.carryOver = b & 0xF;
            this.out.write(chars[lookup]);
        } else if (this.charCount % 3 == 2) {
            int lookup = (this.carryOver << 2) + (b >> 6) & 0x3F;
            this.out.write(chars[lookup]);
            lookup = b & 0x3F;
            this.out.write(chars[lookup]);
            this.carryOver = 0;
        }
        ++this.charCount;
        if (this.charCount % this.bytesPerLine == 0) {
            this.out.write(10);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.charCount % 3 == 1) {
            int lookup = this.carryOver << 4 & 0x3F;
            this.out.write(chars[lookup]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.charCount % 3 == 2) {
            int lookup = this.carryOver << 2 & 0x3F;
            this.out.write(chars[lookup]);
            this.out.write(61);
        }
        super.close();
    }

    public static String encode(String unencoded) {
        return Base64Encoder.encode(unencoded, 76);
    }

    public static String encode(String unencoded, int lineLength) {
        return Base64Encoder.encode(unencoded.getBytes(StandardCharsets.ISO_8859_1), lineLength);
    }

    public static String encode(byte[] unencoded) {
        return Base64Encoder.encode(unencoded, 76);
    }

    public static String encode(byte[] unencoded, int lineLength) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)((double)unencoded.length * 1.37));
        Base64Encoder encodedOut = new Base64Encoder(out, lineLength);
        try {
            encodedOut.write(unencoded);
            encodedOut.close();
            return out.toString("8859_1");
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

