/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageResult
implements Serializable {
    private static final String MESSAGE_CODE_DESCRIPTION_PROPERTIES_NAME = "properties.MessageCodeDescription";
    private static ResourceBundle MESSAGE_CODE_DESCRIPTION;
    private static final long serialVersionUID = -2642203363828042183L;
    private final int _httpCode;
    private final int _xpCode;
    private String _description;
    private String _messageId;
    private String _conversationId;
    private String _messageTime;
    private String _messageType;
    private String _schemaSet;
    private String _schemaVersion;
    private String _transmissionProtocol;
    private TransportURLType transportURLType = TransportURLType.FIXED;
    private static HashMap _messageResults;
    public static final MessageResultIdentifier MSG_SUCCESSFULLY_SEND;
    public static final MessageResultIdentifier MSG_SUCCESSFULLY_RECEIVED;
    public static final MessageResultIdentifier ADAPTER_SUCCESSFULLY_REGISTERED;
    public static final MessageResultIdentifier ADAPTER_SUCCESSFULLY_REGISTERED_OVERWRITTEN_ADAPTERID;
    public static final MessageResultIdentifier ADAPTER_SUCCESSFULLY_UNREGISTERED;
    public static final MessageResultIdentifier PARTNER_IS_KNOWN_AND_ENABLED;
    public static final MessageResultIdentifier PARTNER_IS_ALIVE;
    public static final MessageResultIdentifier PARTNERS_FOUND;
    public static final MessageResultIdentifier LOCAL_MESSENGER_COULD_NOT_BE_REACHED;
    public static final MessageResultIdentifier REMOTE_MESSENGER_COULD_NOT_BE_REACHED;
    public static final MessageResultIdentifier ADAPTER_COULD_NOT_BE_REACHED;
    public static final MessageResultIdentifier BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED;
    public static final MessageResultIdentifier NO_REPLY_FROM_ADAPTER;
    public static final MessageResultIdentifier COULD_NOT_ACCESS_ATTACHMENT_FILE;
    public static final MessageResultIdentifier TRANSPORT_PROVIDER_NOT_FOUND;
    public static final MessageResultIdentifier MESSAGE_COULD_NOT_BE_REGISTERED;
    public static final MessageResultIdentifier COULD_NOT_DECRYPT_PRIVATE_KEY_PASSWORD;
    public static final MessageResultIdentifier COULD_NOT_SAVE_MESSAGE_PAYLOAD;
    public static final MessageResultIdentifier COULD_NOT_INITIALIZE_PIPELINE;
    public static final MessageResultIdentifier COULD_NOT_INITIALIZE_PACKAGER;
    public static final MessageResultIdentifier COULD_NOT_INITIALIZE_MESSAGE_SENDER;
    public static final MessageResultIdentifier COULD_NOT_PACKAGE_MESSAGE;
    public static final MessageResultIdentifier ENCRYPTION_FAILED;
    public static final MessageResultIdentifier SIGNING_FAILED;
    public static final MessageResultIdentifier VALIDATION_FAILED;
    public static final MessageResultIdentifier COMPRESSION_FAILED;
    public static final MessageResultIdentifier COULD_NOT_PROCESS_MESSAGE;
    public static final MessageResultIdentifier LOGGING_INTO_DATABASE_FAILED;
    public static final MessageResultIdentifier PARTNER_IS_NOT_KNOWN;
    public static final MessageResultIdentifier PARTNER_IS_DISABLED;
    public static final MessageResultIdentifier PARTNER_STORE_COULD_NOT_BE_ACCESSED;
    public static final MessageResultIdentifier ADAPTER_SERVICE_COULD_NOT_BE_REACHED;
    public static final MessageResultIdentifier ADAPTER_COULD_NOT_BE_UNREGISTERED;
    public static final MessageResultIdentifier ADAPTER_COULD_NOT_BE_REGISTERED;
    public static final MessageResultIdentifier ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED;
    public static final MessageResultIdentifier MESSENGER_DOES_NOT_ACCEPT_REQUESTS;
    public static final MessageResultIdentifier NO_COMMAND_SUPPLIED;
    public static final MessageResultIdentifier CUSTOM_OK;
    public static final MessageResultIdentifier CUSTOM_ERROR;
    public static final MessageResultIdentifier ADAPTER_REJECTED_MESSAGE;
    public static final MessageResultIdentifier NO_AGREEMENT_FOUND;
    public static final MessageResultIdentifier DUPLICATE_MESSAGE_ID;
    public static final MessageResultIdentifier SENDER_IS_NOT_A_LOCAL_PARTNER;
    public static final MessageResultIdentifier RECEIVER_IS_NOT_A_REMOTE_PARTNER;
    public static final MessageResultIdentifier MSG_SUCCESSFULLY_ARCHIVED;
    public static final MessageResultIdentifier DUPLICATE_SEQUENCE_NUMBER;
    public static final MessageResultIdentifier MAINTENANCE_MODE;
    public static final MessageResultIdentifier COMMAND_NOT_RECOGNIZED;
    public static final MessageResultIdentifier PENDING_MESSAGE_ID;

    public TransportURLType getTransportURLType() {
        return this.transportURLType;
    }

    public MessageResult setTransportURLType(TransportURLType transportURLType) {
        this.transportURLType = transportURLType;
        return this;
    }

    public MessageResult(MessageResultIdentifier mri) {
        this._xpCode = mri.getXpCode();
        this._httpCode = mri.getHttpCode();
        this._description = mri.getDescription();
        this._messageId = "";
        this._messageType = "Unknown";
        this._messageTime = String.valueOf(System.currentTimeMillis());
    }

    public int getHttpCode() {
        return this._httpCode;
    }

    public int getXpCode() {
        return this._xpCode;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void appendToDescription(String description) {
        this._description = this._description + " " + description;
    }

    public void appendToDescription(Throwable throwable) {
        this._description = this._description + " Reason: " + throwable.getMessage();
        Throwable inner = throwable.getCause();
        if (inner != null) {
            this._description = this._description + " - " + inner.getMessage();
            if ((inner = inner.getCause()) != null) {
                this._description = this._description + " - " + inner.getMessage();
            }
        }
    }

    public static MessageResult identify(int xpCode) {
        MessageResultIdentifier lookup = (MessageResultIdentifier)_messageResults.get(xpCode);
        if (lookup != null) {
            return new MessageResult(lookup);
        }
        return null;
    }

    static HashMap getMessageResults() {
        return _messageResults;
    }

    public String toString() {
        return this._httpCode + ":" + this._xpCode + " - " + this._description;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public void setMessageId(String messageId) {
        this._messageId = messageId;
    }

    public String getConversationId() {
        return this._conversationId;
    }

    public String getMessageType() {
        return this._messageType;
    }

    public String getSchemaSet() {
        return this._schemaSet;
    }

    public String getSchemaVersion() {
        return this._schemaVersion;
    }

    public String getMessageTime() {
        return this._messageTime;
    }

    public void setConversationId(String conversationId) {
        this._conversationId = conversationId;
    }

    public void setMessageType(String messageType) {
        this._messageType = messageType;
    }

    public void setSchemaSet(String schemaSet) {
        this._schemaSet = schemaSet;
    }

    public void setSchemaVersion(String schemaVersion) {
        this._schemaVersion = schemaVersion;
    }

    public void setMessageTime(String messageTime) {
        this._messageTime = messageTime;
    }

    public String getTransmissionProtocol() {
        return this._transmissionProtocol;
    }

    public void setTransmissionProtocol(String protocol) {
        this._transmissionProtocol = protocol;
    }

    public boolean equals(Object obj) {
        MessageResult mr;
        MessageResultIdentifier mri;
        return obj instanceof MessageResultIdentifier ? this._httpCode == (mri = (MessageResultIdentifier)obj).getHttpCode() && this._xpCode == mri.getXpCode() : obj instanceof MessageResult && this._httpCode == (mr = (MessageResult)obj).getHttpCode() && this._xpCode == mr.getXpCode();
    }

    public String[] getErrorHelpDescription() {
        String[] errorHelpDescription = new String[]{};
        try {
            errorHelpDescription = MESSAGE_CODE_DESCRIPTION.getString(String.valueOf(this.getXpCode())).split("\r\n");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return errorHelpDescription;
    }

    static {
        try {
            MESSAGE_CODE_DESCRIPTION = ResourceBundle.getBundle(MESSAGE_CODE_DESCRIPTION_PROPERTIES_NAME, Locale.ENGLISH);
        }
        catch (RuntimeException e) {
            MESSAGE_CODE_DESCRIPTION = null;
        }
        MSG_SUCCESSFULLY_SEND = new MessageResultIdentifier(0, 200, "Message successfully sent.");
        MSG_SUCCESSFULLY_RECEIVED = new MessageResultIdentifier(1, 200, "Message successfully received.");
        ADAPTER_SUCCESSFULLY_REGISTERED = new MessageResultIdentifier(2, 200, "Adapter successfully registered");
        ADAPTER_SUCCESSFULLY_REGISTERED_OVERWRITTEN_ADAPTERID = new MessageResultIdentifier(3, 200, "Adapter successfully registered - Overwritten existing AdapterID");
        ADAPTER_SUCCESSFULLY_UNREGISTERED = new MessageResultIdentifier(4, 200, "Adapter successfully unregistered.");
        PARTNER_IS_KNOWN_AND_ENABLED = new MessageResultIdentifier(5, 200, "Partner is known and enabled");
        PARTNER_IS_ALIVE = new MessageResultIdentifier(6, 200, "Partner is alive.");
        PARTNERS_FOUND = new MessageResultIdentifier(7, 200, "Partners found.");
        LOCAL_MESSENGER_COULD_NOT_BE_REACHED = new MessageResultIdentifier(8, 500, "Local Messenger could not be reached.");
        REMOTE_MESSENGER_COULD_NOT_BE_REACHED = new MessageResultIdentifier(9, 500, "Remote Messenger could not be reached.");
        ADAPTER_COULD_NOT_BE_REACHED = new MessageResultIdentifier(10, 500, "Adapter could not be reached.");
        BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED = new MessageResultIdentifier(11, 500, "BackEndMessage could not be reconstructed.");
        NO_REPLY_FROM_ADAPTER = new MessageResultIdentifier(12, 500, "No reply from adapter.");
        COULD_NOT_ACCESS_ATTACHMENT_FILE = new MessageResultIdentifier(13, 500, "Could not access attachment file.");
        TRANSPORT_PROVIDER_NOT_FOUND = new MessageResultIdentifier(14, 500, "No TransportProvider for MessageService URI. Verify partner configuration.");
        MESSAGE_COULD_NOT_BE_REGISTERED = new MessageResultIdentifier(15, 500, "Could not register message in database");
        COULD_NOT_DECRYPT_PRIVATE_KEY_PASSWORD = new MessageResultIdentifier(16, 500, "Could not decrypt private key password.");
        COULD_NOT_SAVE_MESSAGE_PAYLOAD = new MessageResultIdentifier(17, 500, "Could not save message payload.");
        COULD_NOT_INITIALIZE_PIPELINE = new MessageResultIdentifier(18, 500, "Could not initialize pipeline.");
        COULD_NOT_INITIALIZE_PACKAGER = new MessageResultIdentifier(19, 500, "Could not initialize packager.");
        COULD_NOT_INITIALIZE_MESSAGE_SENDER = new MessageResultIdentifier(20, 500, "Could not initialize message sender.");
        COULD_NOT_PACKAGE_MESSAGE = new MessageResultIdentifier(21, 500, "Could not package the message.");
        ENCRYPTION_FAILED = new MessageResultIdentifier(22, 500, "Encryption failed.");
        SIGNING_FAILED = new MessageResultIdentifier(23, 500, "Signing failed.");
        VALIDATION_FAILED = new MessageResultIdentifier(24, 500, "Validation failed.");
        COMPRESSION_FAILED = new MessageResultIdentifier(25, 500, "Compression failed.");
        COULD_NOT_PROCESS_MESSAGE = new MessageResultIdentifier(26, 500, "Could not process message.");
        LOGGING_INTO_DATABASE_FAILED = new MessageResultIdentifier(27, 500, "Logging into database failed.");
        PARTNER_IS_NOT_KNOWN = new MessageResultIdentifier(28, 500, "Partner is not known.");
        PARTNER_IS_DISABLED = new MessageResultIdentifier(29, 500, "Partner is disabled.");
        PARTNER_STORE_COULD_NOT_BE_ACCESSED = new MessageResultIdentifier(30, 500, "Partner store could not be accessed.");
        ADAPTER_SERVICE_COULD_NOT_BE_REACHED = new MessageResultIdentifier(31, 500, "AdapterService could not be reached.");
        ADAPTER_COULD_NOT_BE_UNREGISTERED = new MessageResultIdentifier(32, 500, "Adapter could not be unregistered.");
        ADAPTER_COULD_NOT_BE_REGISTERED = new MessageResultIdentifier(33, 500, "Adapter could not be registered.");
        ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED = new MessageResultIdentifier(34, 500, "Adapter registry could not be accessed.");
        MESSENGER_DOES_NOT_ACCEPT_REQUESTS = new MessageResultIdentifier(35, 500, "Messenger is currently not accepting requests. Possible reasons: Not running. Not fully initialized. Not activated/licensed.");
        NO_COMMAND_SUPPLIED = new MessageResultIdentifier(36, 400, "No command supplied.");
        CUSTOM_OK = new MessageResultIdentifier(37, 200, "");
        CUSTOM_ERROR = new MessageResultIdentifier(38, 500, "");
        ADAPTER_REJECTED_MESSAGE = new MessageResultIdentifier(39, 500, "Adapter rejected Message.");
        NO_AGREEMENT_FOUND = new MessageResultIdentifier(40, 500, "No collaboration agreement found.");
        DUPLICATE_MESSAGE_ID = new MessageResultIdentifier(41, 500, "Duplicate message id.");
        SENDER_IS_NOT_A_LOCAL_PARTNER = new MessageResultIdentifier(42, 500, "Sender is not a local partner.");
        RECEIVER_IS_NOT_A_REMOTE_PARTNER = new MessageResultIdentifier(43, 500, "Receiver is not a remote partner.");
        MSG_SUCCESSFULLY_ARCHIVED = new MessageResultIdentifier(44, 200, "Message successfully archived.");
        DUPLICATE_SEQUENCE_NUMBER = new MessageResultIdentifier(45, 500, "Duplicate sequence number within conversation.");
        MAINTENANCE_MODE = new MessageResultIdentifier(46, 500, "Messenger is running in a Maintenance Mode.");
        COMMAND_NOT_RECOGNIZED = new MessageResultIdentifier(47, 400, "Command not recognized.");
        PENDING_MESSAGE_ID = new MessageResultIdentifier(48, 500, "Message with given ID has a pending status.");
        if (_messageResults == null) {
            _messageResults = new HashMap();
            _messageResults.put(ADAPTER_COULD_NOT_BE_REACHED.getXpCode(), ADAPTER_COULD_NOT_BE_REACHED);
            _messageResults.put(ADAPTER_COULD_NOT_BE_UNREGISTERED.getXpCode(), ADAPTER_COULD_NOT_BE_UNREGISTERED);
            _messageResults.put(ADAPTER_SERVICE_COULD_NOT_BE_REACHED.getXpCode(), ADAPTER_SERVICE_COULD_NOT_BE_REACHED);
            _messageResults.put(ADAPTER_SUCCESSFULLY_REGISTERED.getXpCode(), ADAPTER_SUCCESSFULLY_REGISTERED);
            _messageResults.put(ADAPTER_SUCCESSFULLY_REGISTERED_OVERWRITTEN_ADAPTERID.getXpCode(), ADAPTER_SUCCESSFULLY_REGISTERED_OVERWRITTEN_ADAPTERID);
            _messageResults.put(ADAPTER_SUCCESSFULLY_UNREGISTERED.getXpCode(), ADAPTER_SUCCESSFULLY_UNREGISTERED);
            _messageResults.put(BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED.getXpCode(), BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
            _messageResults.put(COMPRESSION_FAILED.getXpCode(), COMPRESSION_FAILED);
            _messageResults.put(ENCRYPTION_FAILED.getXpCode(), ENCRYPTION_FAILED);
            _messageResults.put(LOCAL_MESSENGER_COULD_NOT_BE_REACHED.getXpCode(), LOCAL_MESSENGER_COULD_NOT_BE_REACHED);
            _messageResults.put(MSG_SUCCESSFULLY_RECEIVED.getXpCode(), MSG_SUCCESSFULLY_RECEIVED);
            _messageResults.put(MSG_SUCCESSFULLY_SEND.getXpCode(), MSG_SUCCESSFULLY_SEND);
            _messageResults.put(NO_REPLY_FROM_ADAPTER.getXpCode(), NO_REPLY_FROM_ADAPTER);
            _messageResults.put(PARTNER_IS_ALIVE.getXpCode(), PARTNER_IS_ALIVE);
            _messageResults.put(COULD_NOT_ACCESS_ATTACHMENT_FILE.getXpCode(), COULD_NOT_ACCESS_ATTACHMENT_FILE);
            _messageResults.put(PARTNER_IS_DISABLED.getXpCode(), PARTNER_IS_DISABLED);
            _messageResults.put(PARTNER_IS_KNOWN_AND_ENABLED.getXpCode(), PARTNER_IS_KNOWN_AND_ENABLED);
            _messageResults.put(PARTNER_IS_NOT_KNOWN.getXpCode(), PARTNER_IS_NOT_KNOWN);
            _messageResults.put(PARTNER_STORE_COULD_NOT_BE_ACCESSED.getXpCode(), PARTNER_STORE_COULD_NOT_BE_ACCESSED);
            _messageResults.put(PARTNERS_FOUND.getXpCode(), PARTNERS_FOUND);
            _messageResults.put(REMOTE_MESSENGER_COULD_NOT_BE_REACHED.getXpCode(), REMOTE_MESSENGER_COULD_NOT_BE_REACHED);
            _messageResults.put(SIGNING_FAILED.getXpCode(), SIGNING_FAILED);
            _messageResults.put(VALIDATION_FAILED.getXpCode(), VALIDATION_FAILED);
            _messageResults.put(ADAPTER_COULD_NOT_BE_REGISTERED.getXpCode(), ADAPTER_COULD_NOT_BE_REGISTERED);
            _messageResults.put(ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED.getXpCode(), ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED);
            _messageResults.put(MESSENGER_DOES_NOT_ACCEPT_REQUESTS.getXpCode(), MESSENGER_DOES_NOT_ACCEPT_REQUESTS);
            _messageResults.put(COMMAND_NOT_RECOGNIZED.getXpCode(), COMMAND_NOT_RECOGNIZED);
            _messageResults.put(NO_COMMAND_SUPPLIED.getXpCode(), NO_COMMAND_SUPPLIED);
            _messageResults.put(TRANSPORT_PROVIDER_NOT_FOUND.getXpCode(), TRANSPORT_PROVIDER_NOT_FOUND);
            _messageResults.put(MESSAGE_COULD_NOT_BE_REGISTERED.getXpCode(), MESSAGE_COULD_NOT_BE_REGISTERED);
            _messageResults.put(COULD_NOT_DECRYPT_PRIVATE_KEY_PASSWORD.getXpCode(), COULD_NOT_DECRYPT_PRIVATE_KEY_PASSWORD);
            _messageResults.put(COULD_NOT_SAVE_MESSAGE_PAYLOAD.getXpCode(), COULD_NOT_SAVE_MESSAGE_PAYLOAD);
            _messageResults.put(COULD_NOT_INITIALIZE_PIPELINE.getXpCode(), COULD_NOT_INITIALIZE_PIPELINE);
            _messageResults.put(COULD_NOT_PROCESS_MESSAGE.getXpCode(), COULD_NOT_PROCESS_MESSAGE);
            _messageResults.put(LOGGING_INTO_DATABASE_FAILED.getXpCode(), LOGGING_INTO_DATABASE_FAILED);
            _messageResults.put(COULD_NOT_INITIALIZE_PACKAGER.getXpCode(), COULD_NOT_INITIALIZE_PACKAGER);
            _messageResults.put(COULD_NOT_INITIALIZE_MESSAGE_SENDER.getXpCode(), COULD_NOT_INITIALIZE_MESSAGE_SENDER);
            _messageResults.put(COULD_NOT_PACKAGE_MESSAGE.getXpCode(), COULD_NOT_PACKAGE_MESSAGE);
            _messageResults.put(CUSTOM_OK.getXpCode(), CUSTOM_OK);
            _messageResults.put(CUSTOM_ERROR.getXpCode(), CUSTOM_ERROR);
            _messageResults.put(ADAPTER_REJECTED_MESSAGE.getXpCode(), ADAPTER_REJECTED_MESSAGE);
            _messageResults.put(NO_AGREEMENT_FOUND.getXpCode(), NO_AGREEMENT_FOUND);
            _messageResults.put(DUPLICATE_MESSAGE_ID.getXpCode(), DUPLICATE_MESSAGE_ID);
            _messageResults.put(SENDER_IS_NOT_A_LOCAL_PARTNER.getXpCode(), SENDER_IS_NOT_A_LOCAL_PARTNER);
            _messageResults.put(RECEIVER_IS_NOT_A_REMOTE_PARTNER.getXpCode(), RECEIVER_IS_NOT_A_REMOTE_PARTNER);
            _messageResults.put(MSG_SUCCESSFULLY_ARCHIVED.getXpCode(), MSG_SUCCESSFULLY_ARCHIVED);
            _messageResults.put(DUPLICATE_SEQUENCE_NUMBER.getXpCode(), DUPLICATE_SEQUENCE_NUMBER);
            _messageResults.put(MAINTENANCE_MODE.getXpCode(), MAINTENANCE_MODE);
            _messageResults.put(PENDING_MESSAGE_ID.getXpCode(), PENDING_MESSAGE_ID);
        }
    }

    public static class MessageResultIdentifier
    implements Serializable {
        private static final long serialVersionUID = 8844926542826103511L;
        private final int _mrXpCode;
        private final int _mrHttpCode;
        private final String _mrDescription;

        protected MessageResultIdentifier(int xpCode, int httpCode, String description) {
            this._mrXpCode = xpCode;
            this._mrHttpCode = httpCode;
            this._mrDescription = description;
        }

        public int getXpCode() {
            return this._mrXpCode;
        }

        public int getHttpCode() {
            return this._mrHttpCode;
        }

        public String getDescription() {
            return this._mrDescription;
        }
    }
}

