/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;

public class ASN1Security {
    private ASN1Security() {
    }

    public static byte[] encrypt(byte[] plain, X509Certificate receiverCertificate) throws IOException, GeneralSecurityException, CMSException {
        if (plain == null) {
            return null;
        }
        CMSEnvelopedDataGenerator generator = new CMSEnvelopedDataGenerator();
        JceKeyTransRecipientInfoGenerator recipientGenerator = new JceKeyTransRecipientInfoGenerator(receiverCertificate);
        generator.addRecipientInfoGenerator((RecipientInfoGenerator)recipientGenerator);
        JceCMSContentEncryptorBuilder builder = new JceCMSContentEncryptorBuilder(PKCSObjectIdentifiers.des_EDE3_CBC);
        builder.setProvider("BC");
        OutputEncryptor contentEncryptor = builder.build();
        CMSEnvelopedData cms = generator.generate((CMSTypedData)new CMSProcessableByteArray(plain), contentEncryptor);
        byte[] cipher = cms.getEncoded();
        return cipher;
    }

    public static byte[] decrypt(byte[] pkcs7envelopedData, PrivateKey privateKey) throws GeneralSecurityException, CMSException {
        CMSEnvelopedData cms = new CMSEnvelopedData(pkcs7envelopedData);
        Collection recipients = cms.getRecipientInfos().getRecipients();
        Iterator iterator = recipients.iterator();
        if (iterator.hasNext()) {
            RecipientInformation iter = (RecipientInformation)iterator.next();
            KeyTransRecipientInformation rinfo = (KeyTransRecipientInformation)iter;
            JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(privateKey);
            return rinfo.getContent((Recipient)recipient);
        }
        return null;
    }

    public static List<RecipientId> getRecipientIDs(byte[] pkcs7envelopedData) throws CMSException {
        ArrayList<RecipientId> recipientIDs = new ArrayList<RecipientId>();
        CMSEnvelopedData cms = new CMSEnvelopedData(pkcs7envelopedData);
        Collection recipients = cms.getRecipientInfos().getRecipients();
        for (RecipientInformation iter : recipients) {
            KeyTransRecipientInformation rinfo = (KeyTransRecipientInformation)iter;
            RecipientId rid = rinfo.getRID();
            if (rid == null) continue;
            recipientIDs.add(rid);
        }
        return recipientIDs;
    }
}

