/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation;

import de.pontonconsulting.security.CertificateCreator;
import de.pontonconsulting.security.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public abstract class AbstractModel {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private X509Certificate _certificate;

    public AbstractModel(X509Certificate certificate) {
        this._certificate = certificate;
    }

    protected PublicKey getPublicKey() {
        if (this._certificate != null) {
            return this._certificate.getPublicKey();
        }
        return null;
    }

    public Date getEndDate() {
        if (this._certificate != null) {
            return this._certificate.getNotAfter();
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        if (this._certificate != null) {
            return this._certificate.getSerialNumber();
        }
        return null;
    }

    public X509Certificate getCertificate() {
        return this._certificate;
    }

    public String getProductName() {
        return this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.1");
    }

    public String getProductVersion() {
        return this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.2");
    }

    private String getCertExtension(String oid) {
        byte[] bytes = this.getCertExtensionBytes(oid);
        if (bytes != null) {
            try {
                ASN1Primitive o = X509ExtensionUtil.fromExtensionValue((byte[])bytes);
                if (o instanceof DERUTF8String) {
                    return ((DERUTF8String)o).getString();
                }
                return new String(bytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String[] getCertExtensionValues(String oid) {
        return new Extension(oid, this.getCertExtension(oid)).getValueAsStrings();
    }

    public String getCertExtensionFirstValue(String oid) {
        String[] values = this.getCertExtensionValues(oid);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private byte[] getCertExtensionBytes(String oid) {
        if (this._certificate != null) {
            byte[] bytes = this._certificate.getExtensionValue(oid);
            return bytes;
        }
        return null;
    }

    public String getSubjectCN() {
        if (this.getCertificate() == null) {
            return null;
        }
        return CertificateCreator.retrieveNameAttribute("cn", this.getCertificate().getSubjectX500Principal());
    }

    public boolean isFullVersion() {
        return !this.isTrialVersion();
    }

    public abstract boolean isTrialVersion();

    public boolean isASxMessagingEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.9"));
    }

    public boolean isEbXML2MessagingEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.8"));
    }

    public boolean isAS4MessagingEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.15"));
    }

    public boolean isAS4EllipticCurveEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.17"));
    }

    public boolean isPlainMessagingEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.11"));
    }

    public boolean isLegacyMessagingEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.10"));
    }

    public boolean isClusterModeEnabled() {
        return this.falseIfnotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.7"));
    }

    public int getPontonXPMaxNumberOfRemotePartners() {
        return this.maxIntegerIfNotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.14"));
    }

    public int getPontonXPMaxNumberOfLocalPartners() {
        return this.maxIntegerIfNotDefined(this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.13"));
    }

    public String getPontonXPHighestVersion() {
        return this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.12");
    }

    private int maxIntegerIfNotDefined(String maxNumber) {
        if (maxNumber != null) {
            return Integer.parseInt(maxNumber);
        }
        return Integer.MAX_VALUE;
    }

    private boolean falseIfnotDefined(String feature) {
        if (feature == null) {
            return false;
        }
        return Boolean.parseBoolean(feature);
    }

    public int getReactivationInterval() {
        String stringValue = this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.16");
        try {
            return Integer.parseInt(stringValue);
        }
        catch (RuntimeException e) {
            return 0;
        }
    }
}

