/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.EncryptionKeyInfo;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.EllipticCurveSupport;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ConcatKDFParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EncryptedKeyECDHResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedKeyECDHResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String baseURI, StorageResolver storage) {
        if (!XMLUtils.elementIsInEncryptionSpace(element, "AgreementMethod")) {
            return false;
        }
        Attr algorithm = element.getAttributeNode("Algorithm");
        if (algorithm == null) {
            return false;
        }
        return "http://www.w3.org/2009/xmlenc11#ECDH-ES".equals(algorithm.getValue());
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String baseURI, StorageResolver storage, boolean secureValidation) throws KeyResolverException {
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String baseURI, StorageResolver storage, boolean secureValidation) throws KeyResolverException {
        return null;
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String baseURI, StorageResolver storage, boolean secureValidation) throws KeyResolverException {
        LOG.debug("Can I resolve {}?", (Object)element.getTagName());
        try {
            KeyInfo publicKey = this.getPublicKey(element, baseURI);
            KeyInfo privateKey = this.getPrivateKey(element, baseURI);
            byte[] sharedSecret = EllipticCurveSupport.getInstance().getSharedSecret(privateKey.getPrivateKey(), publicKey.getPublicKey());
            String keyWrapAlgorithm = this.getKeyWrapAlgorithm(element);
            byte[] wrapKeyBytes = this.getWrappedKeyBytes(element, keyWrapAlgorithm, sharedSecret);
            return new SecretKeySpec(wrapKeyBytes, JCEMapper.getJCEKeyAlgorithmFromURI(keyWrapAlgorithm));
        }
        catch (Exception e) {
            LOG.warn("", (Throwable)e);
            return null;
        }
    }

    private KeyInfo getPublicKey(Element element, String baseURI) throws XMLSecurityException {
        Element originatorKeyInfoElement = this.getChildElement(element, "http://www.w3.org/2001/04/xmlenc#", "OriginatorKeyInfo");
        return new EncryptionKeyInfo(originatorKeyInfoElement, baseURI);
    }

    private KeyInfo getPrivateKey(Element element, String baseURI) throws XMLSecurityException {
        Element recipientKeyInfoElement = this.getChildElement(element, "http://www.w3.org/2001/04/xmlenc#", "RecipientKeyInfo");
        return new EncryptionKeyInfo(recipientKeyInfoElement, baseURI);
    }

    private String getKeyWrapAlgorithm(Element element) throws KeyResolverException {
        Element encryptionMethodElement = this.getChildElement((Element)element.getParentNode().getParentNode(), "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        return encryptionMethodElement.getAttribute("Algorithm");
    }

    private byte[] getSharedSecret(Key privateKey, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        try {
            KeyAgreement key_agreement = KeyAgreement.getInstance("ECDH");
            key_agreement.init(privateKey);
            key_agreement.doPhase(publicKey, true);
            return key_agreement.generateSecret();
        }
        catch (Exception e) {
            LOG.debug("Required KeyAgreement not support by default SecurityProvider ({}). Retry with BouncyCastle-Provider...", (Object)e.getMessage());
            KeyAgreement key_agreement = KeyAgreement.getInstance("ECDH", "BC");
            key_agreement.init(privateKey);
            key_agreement.doPhase(publicKey, true);
            return key_agreement.generateSecret();
        }
    }

    private Element getChildElement(Element parentElement, String namespace, String name) throws KeyResolverException {
        NodeList nodeList = parentElement.getElementsByTagNameNS(namespace, name);
        if (nodeList.getLength() == 0) {
            throw new KeyResolverException("ChildElement " + name + " not found");
        }
        if (nodeList.getLength() > 1) {
            throw new KeyResolverException("Found " + nodeList.getLength() + " ChildElements with name " + name);
        }
        return (Element)nodeList.item(0);
    }

    private byte[] getWrappedKeyBytes(Element parent, String keyWrapAlgorithm, byte[] sharedSecret) throws KeyResolverException, NoSuchAlgorithmException {
        Element concatKDFelement = this.getChildElement(parent, "http://www.w3.org/2009/xmlenc11#", "ConcatKDFParams");
        String algorithmID = concatKDFelement.getAttribute("AlgorithmID");
        String partyUInfo = concatKDFelement.getAttribute("PartyUInfo");
        String partyVInfo = concatKDFelement.getAttribute("PartyVInfo");
        String suppPubInfo = concatKDFelement.getAttribute("SuppPubInfo");
        String suppPrivInfo = concatKDFelement.getAttribute("SuppPubInfo");
        Element digestAlgorithmElement = this.getChildElement(concatKDFelement, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        String digestAlgorithmUri = digestAlgorithmElement.getAttribute("Algorithm");
        ConcatKDFParameters concatKDFParameters = new ConcatKDFParameters(keyWrapAlgorithm, digestAlgorithmUri, algorithmID, partyUInfo, partyVInfo);
        concatKDFParameters.setSuppPubInfo(suppPubInfo);
        concatKDFParameters.setSuppPrivInfo(suppPrivInfo);
        return EllipticCurveSupport.getInstance().getWrappedKeyBytes(concatKDFParameters, sharedSecret);
    }

    @Override
    protected PrivateKey engineResolvePrivateKey(Element element, String baseURI, StorageResolver storage, boolean secureValidation) {
        return null;
    }
}

