/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content;

import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import org.apache.commons.codec.binary.Hex;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.EncryptionKeyInfo;
import org.apache.xml.security.keys.content.KeyDerivationMethod;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.EllipticCurveSupport;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ConcatKDFParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AgreementMethod_ECDH
extends ElementProxy
implements KeyInfoContent {
    private byte[] wrappedKeyBytes;
    private KeyDerivationMethod keyDerivationMethod;
    private final String x509KeyIdentifier;
    private static final String BIT_PADDING_PREFIX = "00";

    public AgreementMethod_ECDH(Document doc, X509Certificate receiverCert, String x509KeyIdentifier, ConcatKDFParameters concatKDFParameters) throws XMLEncryptionException {
        super(doc);
        this.x509KeyIdentifier = x509KeyIdentifier;
        this.addReturnToSelf();
        this.setLocalAttribute("Algorithm", "http://www.w3.org/2009/xmlenc11#ECDH-ES");
        try {
            ECPublicKey receiverPublicKey = (ECPublicKey)receiverCert.getPublicKey();
            KeyPair ephermalKeyPair = EllipticCurveSupport.getInstance().generateOneTimeECKeyPair(receiverPublicKey);
            this.prepareConcatKDFParameters(concatKDFParameters, ephermalKeyPair.getPublic(), receiverPublicKey);
            this.addKeyDerivationMethod(doc, concatKDFParameters);
            byte[] sharedSecret = EllipticCurveSupport.getInstance().getSharedSecret(ephermalKeyPair.getPrivate(), receiverPublicKey);
            this.wrappedKeyBytes = EllipticCurveSupport.getInstance().getWrappedKeyBytes(concatKDFParameters, sharedSecret);
            this.addOriginatorKeyInfo(doc, ephermalKeyPair.getPublic());
            this.addRecipientKeyInfo(doc, receiverCert);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | XMLSecurityException e) {
            throw new XMLEncryptionException(e);
        }
    }

    private void addKeyDerivationMethod(Document doc, ConcatKDFParameters concatKDFParameters) throws XMLSecurityException {
        this.keyDerivationMethod = new KeyDerivationMethod(doc, concatKDFParameters);
        this.appendSelf(this.keyDerivationMethod);
        this.addReturnToSelf();
    }

    private void addOriginatorKeyInfo(Document doc, PublicKey ephermalPublicKey) throws XMLSecurityException {
        Element originatorKeyInfoElement = XMLUtils.createElementInEncryptionSpace(doc, "OriginatorKeyInfo");
        EncryptionKeyInfo originatorKeyInfo = new EncryptionKeyInfo(originatorKeyInfoElement, this.getBaseURI());
        originatorKeyInfo.add(new KeyValue(doc, ephermalPublicKey));
        this.appendSelf(originatorKeyInfo);
        this.addReturnToSelf();
    }

    private void addRecipientKeyInfo(Document doc, X509Certificate receiverCert) throws XMLSecurityException {
        X509Data x509Data = new X509Data(doc);
        if (this.x509KeyIdentifier == null || "X509IssuerSerial".equals(this.x509KeyIdentifier)) {
            x509Data.add(new XMLX509IssuerSerial(doc, receiverCert));
        }
        if (this.x509KeyIdentifier == null || "X509SubjectName".equals(this.x509KeyIdentifier)) {
            x509Data.add(new XMLX509SubjectName(doc, receiverCert));
        }
        if (this.x509KeyIdentifier == null || "X509Certificate".equals(this.x509KeyIdentifier)) {
            try {
                x509Data.add(new XMLX509Certificate(doc, receiverCert));
            }
            catch (XMLSecurityException e) {
                if (this.x509KeyIdentifier == null) {
                    LOG.debug("Can't add XMLX509Certificate: {}", (Object)e.getMessage());
                }
                throw e;
            }
        }
        if (this.x509KeyIdentifier == null || "X509SKI".equals(this.x509KeyIdentifier)) {
            try {
                x509Data.add(new XMLX509SKI(doc, receiverCert));
            }
            catch (XMLSecurityException e) {
                if (this.x509KeyIdentifier == null) {
                    LOG.debug("Can't add XMLX509SKI: {}", (Object)e.getMessage());
                }
                throw e;
            }
        }
        Element recipientKeyInfoElement = XMLUtils.createElementInEncryptionSpace(doc, "RecipientKeyInfo");
        EncryptionKeyInfo recipientKeyInfo = new EncryptionKeyInfo(recipientKeyInfoElement, this.getBaseURI());
        recipientKeyInfo.add(x509Data);
        this.appendSelf(recipientKeyInfo);
        this.addReturnToSelf();
    }

    private String getDigestMethodAlgorithmID() {
        String digestAlgorithmUri = this.keyDerivationMethod.getDigestMethodAlgorithm();
        return JCEMapper.translateURItoJCEID(digestAlgorithmUri);
    }

    public byte[] getWrappedKeyBytes() {
        return this.wrappedKeyBytes;
    }

    private void prepareConcatKDFParameters(ConcatKDFParameters concatKDFParameters, PublicKey ephermalPublicKey, ECPublicKey receiverPublicKey) {
        if (concatKDFParameters.getAlgorithmId() == null) {
            if (concatKDFParameters.isFillPartyAndAlgorithmAutomatically()) {
                concatKDFParameters.setAlgorithmId(BIT_PADDING_PREFIX + Hex.encodeHexString((byte[])concatKDFParameters.getEncryptionMethod().getBytes(StandardCharsets.US_ASCII)));
            } else {
                concatKDFParameters.setAlgorithmId("");
            }
        }
        if (concatKDFParameters.getPartyUInfo() == null) {
            if (concatKDFParameters.isFillPartyAndAlgorithmAutomatically()) {
                concatKDFParameters.setPartyUInfo(BIT_PADDING_PREFIX + Hex.encodeHexString((byte[])ephermalPublicKey.getEncoded()));
            } else {
                concatKDFParameters.setPartyUInfo("");
            }
        }
        if (concatKDFParameters.getPartyVInfo() == null) {
            if (concatKDFParameters.isFillPartyAndAlgorithmAutomatically()) {
                concatKDFParameters.setPartyVInfo(BIT_PADDING_PREFIX + Hex.encodeHexString((byte[])receiverPublicKey.getEncoded()));
            } else {
                concatKDFParameters.setPartyVInfo("");
            }
        }
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    @Override
    public String getBaseLocalName() {
        return "AgreementMethod";
    }
}

