/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;

@UriEndpoint(firstVersion="1.3.0", scheme="browse", title="Browse", syntax="browse:name", remote=false, category={Category.CORE, Category.MONITORING})
public class BrowseEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint {
    @UriPath(description="A name which can be any string to uniquely identify the endpoint")
    @Metadata(required=true)
    private String name;
    @UriParam(label="advanced", description="Maximum number of messages to keep in memory available for browsing. Use 0 for unlimited.")
    private int browseLimit;
    @UriParam(label="advanced", description="To use a predicate to filter whether to include the message for browsing. Return true to include, false to exclude.")
    private Predicate<Exchange> filter;
    private List<Exchange> exchanges;
    private volatile Processor onExchangeProcessor;

    public BrowseEndpoint() {
    }

    public BrowseEndpoint(String uri, Component component) {
        super(uri, component);
    }

    public boolean isRemote() {
        return false;
    }

    public int getBrowseLimit() {
        return this.browseLimit;
    }

    public void setBrowseLimit(int browseLimit) {
        this.browseLimit = browseLimit;
    }

    public List<Exchange> getExchanges() {
        if (this.exchanges == null) {
            this.exchanges = this.createExchangeList();
        }
        return this.exchanges;
    }

    public Producer createProducer() throws Exception {
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                boolean accept = true;
                if (BrowseEndpoint.this.filter != null) {
                    accept = BrowseEndpoint.this.filter.test(exchange);
                }
                if (accept) {
                    BrowseEndpoint.this.onExchange(exchange);
                }
            }
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.onExchangeProcessor = processor;
        DefaultConsumer answer = new DefaultConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Predicate<Exchange> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<Exchange> filter) {
        this.filter = filter;
    }

    protected List<Exchange> createExchangeList() {
        return new CopyOnWriteArrayList<Exchange>();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        int max;
        if (this.browseLimit > 0 && (max = this.exchanges.size()) >= this.browseLimit) {
            int space = Math.abs(max - (this.browseLimit - 1));
            this.exchanges = this.exchanges.subList(space, max);
        }
        this.exchanges.add(exchange);
        if (this.onExchangeProcessor != null) {
            this.onExchangeProcessor.process(exchange);
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.exchanges = this.createExchangeList();
    }

    protected void doStop() throws Exception {
        if (this.exchanges != null) {
            this.exchanges.clear();
            this.exchanges = null;
        }
        super.doStop();
    }
}

