/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.lms.LMSParameters;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class LmsUtils {
    LmsUtils() {
    }

    static void u32str(int n, Digest d) {
        d.update((byte)(n >>> 24));
        d.update((byte)(n >>> 16));
        d.update((byte)(n >>> 8));
        d.update((byte)n);
    }

    static void u16str(short n, Digest d) {
        d.update((byte)(n >>> 8));
        d.update((byte)n);
    }

    static void byteArray(byte[] array, Digest digest) {
        digest.update(array, 0, array.length);
    }

    static void byteArray(byte[] array, int start, int len, Digest digest) {
        digest.update(array, start, len);
    }

    static int calculateStrength(LMSParameters lmsParameters) {
        if (lmsParameters == null) {
            throw new NullPointerException("lmsParameters cannot be null");
        }
        LMSigParameters sigParameters = lmsParameters.getLMSigParam();
        return (1 << sigParameters.getH()) * sigParameters.getM();
    }
}

