/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntruprime;

import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SNTRUPrimePrivateKeyParameters
extends SNTRUPrimeKeyParameters {
    private final byte[] f;
    private final byte[] ginv;
    private final byte[] pk;
    private final byte[] rho;
    private final byte[] hash;

    public SNTRUPrimePrivateKeyParameters(SNTRUPrimeParameters params, byte[] f, byte[] ginv, byte[] pk, byte[] rho, byte[] hash) {
        super(true, params);
        this.f = Arrays.clone(f);
        this.ginv = Arrays.clone(ginv);
        this.pk = Arrays.clone(pk);
        this.rho = Arrays.clone(rho);
        this.hash = Arrays.clone(hash);
    }

    public byte[] getF() {
        return Arrays.clone(this.f);
    }

    public byte[] getGinv() {
        return Arrays.clone(this.ginv);
    }

    public byte[] getPk() {
        return Arrays.clone(this.pk);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getHash() {
        return Arrays.clone(this.hash);
    }

    public byte[] getEncoded() {
        byte[] key = new byte[this.getParameters().getPrivateKeyBytes()];
        System.arraycopy(this.f, 0, key, 0, this.f.length);
        System.arraycopy(this.ginv, 0, key, this.f.length, this.ginv.length);
        System.arraycopy(this.pk, 0, key, this.f.length + this.ginv.length, this.pk.length);
        System.arraycopy(this.rho, 0, key, this.f.length + this.ginv.length + this.pk.length, this.rho.length);
        System.arraycopy(this.hash, 0, key, this.f.length + this.ginv.length + this.pk.length + this.rho.length, this.hash.length);
        return key;
    }
}

