/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.resolvers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class X509CertFromCryptoResolver {
    private static final Logger LOG = LoggerFactory.getLogger(X509CertFromCryptoResolver.class);
    private final Crypto crypto;

    public X509CertFromCryptoResolver(Crypto crypto) {
        this.crypto = crypto;
    }

    public X509Certificate[] resolveX509Certificates(Element element) {
        LinkedHashSet<X509Certificate> certificates = new LinkedHashSet<X509Certificate>();
        try {
            X509Certificate[] certs;
            int i;
            X509Data x509Data = new X509Data(element, element.getBaseURI());
            for (i = 0; i < x509Data.lengthSKI(); ++i) {
                certs = this.resolveX509SKI(x509Data.itemSKI(i));
                if (certs == null) continue;
                certificates.addAll(Arrays.asList(certs));
            }
            for (i = 0; i < x509Data.lengthIssuerSerial(); ++i) {
                certs = this.resolveX509IssuerSerial(x509Data.itemIssuerSerial(i));
                if (certs == null) continue;
                certificates.addAll(Arrays.asList(certs));
            }
            for (i = 0; i < x509Data.lengthSubjectName(); ++i) {
                certs = this.resolveX509SubjectName(x509Data.itemSubjectName(i));
                if (certs == null) continue;
                certificates.addAll(Arrays.asList(certs));
            }
            for (i = 0; i < x509Data.lengthCertificate(); ++i) {
                certs = this.resolveX509Certificate(x509Data.itemCertificate(i));
                if (certs == null) continue;
                certificates.addAll(Arrays.asList(certs));
            }
        }
        catch (XMLSecurityException e) {
            LOG.debug(((Object)((Object)e)).getClass().getSimpleName() + " while resolving PrivateKey from X509Data", (Throwable)e);
        }
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }

    private X509Certificate[] resolveX509SKI(XMLX509SKI x509SKI) throws XMLSecurityException {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.SKI_BYTES);
        cryptoType.setBytes(x509SKI.getSKIBytes());
        return this.crypto.getX509Certificates(cryptoType);
    }

    private X509Certificate[] resolveX509IssuerSerial(XMLX509IssuerSerial x509Serial) throws WSSecurityException {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(x509Serial.getIssuerName(), x509Serial.getSerialNumber());
        return this.crypto.getX509Certificates(cryptoType);
    }

    private X509Certificate[] resolveX509SubjectName(XMLX509SubjectName x509SubjectName) throws WSSecurityException {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.SUBJECT_DN);
        cryptoType.setSubjectDN(x509SubjectName.getSubjectName());
        return this.crypto.getX509Certificates(cryptoType);
    }

    private X509Certificate[] resolveX509Certificate(XMLX509Certificate x509Cert) throws XMLSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(x509Cert.getCertificateBytes());
        return new X509Certificate[]{this.crypto.loadCertificate((InputStream)in)};
    }
}

