/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.util;

import java.net.Socket;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.util.CustomSSLSocketFactory;

public class SetHostSocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SetHostSocketFactory.class.getName());
    protected static final ThreadLocal<SetHostSocketFactory> threadLocal = new ThreadLocal();
    protected final String host;

    public static SocketFactory getDefault() {
        SSLSocketFactory sslSocketFactory = threadLocal.get();
        if (null != sslSocketFactory) {
            return sslSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SetHostSocketFactory(SSLSocketFactory delegate, URL url) {
        this(delegate, url == null ? null : url.getHost());
    }

    public SetHostSocketFactory(SSLSocketFactory delegate, String host) {
        super(delegate);
        this.host = host;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket s) {
        if (this.host != null && s instanceof BCSSLSocket) {
            BCSSLSocket ssl = (BCSSLSocket)((Object)s);
            LOG.fine("Setting host on socket: " + this.host);
            ssl.setHost(this.host);
        }
        return s;
    }
}

