/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.pqc.crypto.hqc.GF2PolynomialCalculator;
import org.bouncycastle.pqc.crypto.hqc.KeccakRandomGenerator;
import org.bouncycastle.pqc.crypto.hqc.ReedMuller;
import org.bouncycastle.pqc.crypto.hqc.ReedSolomon;
import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HQCEngine {
    private int n;
    private int n1;
    private int n2;
    private int k;
    private int delta;
    private int w;
    private int wr;
    private int we;
    private int g;
    private int rejectionThreshold;
    private int fft;
    private int mulParam;
    private int SEED_SIZE = 40;
    private byte G_FCT_DOMAIN = (byte)3;
    private byte H_FCT_DOMAIN = (byte)4;
    private byte K_FCT_DOMAIN = (byte)5;
    private int N_BYTE;
    private int n1n2;
    private int N_BYTE_64;
    private int K_BYTE;
    private int K_BYTE_64;
    private int N1_BYTE_64;
    private int N1N2_BYTE_64;
    private int N1N2_BYTE;
    private int N1_BYTE;
    private int GF_POLY_WT = 5;
    private int GF_POLY_M2 = 4;
    private int SALT_SIZE_BYTES = 16;
    private int SALT_SIZE_64 = 2;
    private int[] generatorPoly;
    private int SHA512_BYTES = 64;
    private long RED_MASK;
    private GF2PolynomialCalculator gfCalculator;

    public HQCEngine(int n, int n1, int n2, int k, int g, int delta, int w, int wr, int we, int rejectionThreshold, int fft, int[] generatorPoly) {
        this.n = n;
        this.k = k;
        this.delta = delta;
        this.w = w;
        this.wr = wr;
        this.we = we;
        this.n1 = n1;
        this.n2 = n2;
        this.n1n2 = n1 * n2;
        this.generatorPoly = generatorPoly;
        this.g = g;
        this.rejectionThreshold = rejectionThreshold;
        this.fft = fft;
        this.mulParam = (int)Math.ceil(n2 / 128);
        this.N_BYTE = Utils.getByteSizeFromBitSize(n);
        this.K_BYTE = k;
        this.N_BYTE_64 = Utils.getByte64SizeFromBitSize(n);
        this.K_BYTE_64 = Utils.getByteSizeFromBitSize(k);
        this.N1_BYTE_64 = Utils.getByteSizeFromBitSize(n1);
        this.N1N2_BYTE_64 = Utils.getByte64SizeFromBitSize(n1 * n2);
        this.N1N2_BYTE = Utils.getByteSizeFromBitSize(n1 * n2);
        this.N1_BYTE = Utils.getByteSizeFromBitSize(n1);
        this.RED_MASK = (1L << (int)((long)n % 64L)) - 1L;
        this.gfCalculator = new GF2PolynomialCalculator(this.N_BYTE_64, n, this.RED_MASK);
    }

    public void genKeyPair(byte[] pk, byte[] sk, byte[] seed) {
        byte[] secretKeySeed = new byte[this.SEED_SIZE];
        KeccakRandomGenerator randomGenerator = new KeccakRandomGenerator(256);
        randomGenerator.randomGeneratorInit(seed, null, seed.length, 0);
        randomGenerator.squeeze(secretKeySeed, 40);
        KeccakRandomGenerator secretKeySeedExpander = new KeccakRandomGenerator(256);
        secretKeySeedExpander.seedExpanderInit(secretKeySeed, secretKeySeed.length);
        long[] xLongBytes = new long[this.N_BYTE_64];
        long[] yLongBytes = new long[this.N_BYTE_64];
        this.generateRandomFixedWeight(xLongBytes, secretKeySeedExpander, this.w);
        this.generateRandomFixedWeight(yLongBytes, secretKeySeedExpander, this.w);
        byte[] publicKeySeed = new byte[this.SEED_SIZE];
        randomGenerator.squeeze(publicKeySeed, 40);
        KeccakRandomGenerator randomPublic = new KeccakRandomGenerator(256);
        randomPublic.seedExpanderInit(publicKeySeed, publicKeySeed.length);
        long[] hLongBytes = new long[this.N_BYTE_64];
        this.generatePublicKeyH(hLongBytes, randomPublic);
        long[] s = new long[this.N_BYTE_64];
        this.gfCalculator.multLongs(s, yLongBytes, hLongBytes);
        GF2PolynomialCalculator.addLongs(s, s, xLongBytes);
        byte[] sBytes = new byte[this.N_BYTE];
        Utils.fromLongArrayToByteArray(sBytes, s);
        byte[] tmpPk = Arrays.concatenate(publicKeySeed, sBytes);
        byte[] tmpSk = Arrays.concatenate(secretKeySeed, tmpPk);
        System.arraycopy(tmpPk, 0, pk, 0, tmpPk.length);
        System.arraycopy(tmpSk, 0, sk, 0, tmpSk.length);
    }

    public void encaps(byte[] u, byte[] v, byte[] K, byte[] d, byte[] pk, byte[] seed, byte[] salt) {
        byte[] m = new byte[this.K_BYTE];
        byte[] secretKeySeed = new byte[this.SEED_SIZE];
        KeccakRandomGenerator randomGenerator = new KeccakRandomGenerator(256);
        randomGenerator.randomGeneratorInit(seed, null, seed.length, 0);
        randomGenerator.squeeze(secretKeySeed, 40);
        byte[] publicKeySeed = new byte[this.SEED_SIZE];
        randomGenerator.squeeze(publicKeySeed, 40);
        randomGenerator.squeeze(m, this.K_BYTE);
        byte[] theta = new byte[this.SHA512_BYTES];
        byte[] tmp = new byte[this.K_BYTE + this.SEED_SIZE + this.SALT_SIZE_BYTES];
        randomGenerator.squeeze(salt, this.SALT_SIZE_BYTES);
        System.arraycopy(m, 0, tmp, 0, m.length);
        System.arraycopy(pk, 0, tmp, this.K_BYTE, this.SEED_SIZE);
        System.arraycopy(salt, 0, tmp, this.K_BYTE + this.SEED_SIZE, this.SALT_SIZE_BYTES);
        KeccakRandomGenerator shakeDigest = new KeccakRandomGenerator(256);
        shakeDigest.SHAKE256_512_ds(theta, tmp, tmp.length, new byte[]{this.G_FCT_DOMAIN});
        long[] h = new long[this.N_BYTE_64];
        byte[] s = new byte[this.N_BYTE];
        this.extractPublicKeys(h, s, pk);
        long[] vTmp = new long[this.N1N2_BYTE_64];
        this.encrypt(u, vTmp, h, s, m, theta);
        Utils.fromLongArrayToByteArray(v, vTmp);
        shakeDigest.SHAKE256_512_ds(d, m, m.length, new byte[]{this.H_FCT_DOMAIN});
        byte[] hashInputK = new byte[this.K_BYTE + this.N_BYTE + this.N1N2_BYTE];
        hashInputK = Arrays.concatenate(m, u);
        hashInputK = Arrays.concatenate(hashInputK, v);
        shakeDigest.SHAKE256_512_ds(K, hashInputK, hashInputK.length, new byte[]{this.K_FCT_DOMAIN});
    }

    public void decaps(byte[] ss, byte[] ct, byte[] sk) {
        long[] x = new long[this.N_BYTE_64];
        long[] y = new long[this.N_BYTE_64];
        byte[] pk = new byte[40 + this.N_BYTE];
        this.extractKeysFromSecretKeys(x, y, pk, sk);
        byte[] u = new byte[this.N_BYTE];
        byte[] v = new byte[this.N1N2_BYTE];
        byte[] d = new byte[this.SHA512_BYTES];
        byte[] salt = new byte[this.SALT_SIZE_BYTES];
        this.extractCiphertexts(u, v, d, salt, ct);
        byte[] mPrimeBytes = new byte[this.k];
        this.decrypt(mPrimeBytes, mPrimeBytes, u, v, y);
        byte[] theta = new byte[this.SHA512_BYTES];
        byte[] tmp = new byte[this.K_BYTE + this.SALT_SIZE_BYTES + this.SEED_SIZE];
        System.arraycopy(mPrimeBytes, 0, tmp, 0, mPrimeBytes.length);
        System.arraycopy(pk, 0, tmp, this.K_BYTE, this.SEED_SIZE);
        System.arraycopy(salt, 0, tmp, this.K_BYTE + this.SEED_SIZE, this.SALT_SIZE_BYTES);
        KeccakRandomGenerator shakeDigest = new KeccakRandomGenerator(256);
        shakeDigest.SHAKE256_512_ds(theta, tmp, tmp.length, new byte[]{this.G_FCT_DOMAIN});
        long[] h = new long[this.N_BYTE_64];
        byte[] s = new byte[this.N_BYTE];
        this.extractPublicKeys(h, s, pk);
        byte[] u2Bytes = new byte[this.N_BYTE];
        byte[] v2Bytes = new byte[this.N1N2_BYTE];
        long[] vTmp = new long[this.N1N2_BYTE_64];
        this.encrypt(u2Bytes, vTmp, h, s, mPrimeBytes, theta);
        Utils.fromLongArrayToByteArray(v2Bytes, vTmp);
        byte[] dPrime = new byte[this.SHA512_BYTES];
        shakeDigest.SHAKE256_512_ds(dPrime, mPrimeBytes, mPrimeBytes.length, new byte[]{this.H_FCT_DOMAIN});
        byte[] hashInputK = new byte[this.K_BYTE + this.N_BYTE + this.N1N2_BYTE];
        hashInputK = Arrays.concatenate(mPrimeBytes, u);
        hashInputK = Arrays.concatenate(hashInputK, v);
        shakeDigest.SHAKE256_512_ds(ss, hashInputK, hashInputK.length, new byte[]{this.K_FCT_DOMAIN});
        boolean result = true;
        if (!Arrays.areEqual(u, u2Bytes)) {
            result = false;
        }
        if (!Arrays.areEqual(v, v2Bytes)) {
            result = false;
        }
        if (!Arrays.areEqual(d, dPrime)) {
            result = false;
        }
        if (!result) {
            for (int i = 0; i < this.getSessionKeySize(); ++i) {
                ss[i] = 0;
            }
        }
    }

    int getSessionKeySize() {
        return this.SHA512_BYTES;
    }

    private void encrypt(byte[] u, long[] v, long[] h, byte[] s, byte[] m, byte[] theta) {
        KeccakRandomGenerator randomGenerator = new KeccakRandomGenerator(256);
        randomGenerator.seedExpanderInit(theta, this.SEED_SIZE);
        long[] e = new long[this.N_BYTE_64];
        long[] r1 = new long[this.N_BYTE_64];
        long[] r2 = new long[this.N_BYTE_64];
        this.generateRandomFixedWeight(r1, randomGenerator, this.wr);
        this.generateRandomFixedWeight(r2, randomGenerator, this.wr);
        this.generateRandomFixedWeight(e, randomGenerator, this.we);
        long[] uLong = new long[this.N_BYTE_64];
        this.gfCalculator.multLongs(uLong, r2, h);
        GF2PolynomialCalculator.addLongs(uLong, uLong, r1);
        Utils.fromLongArrayToByteArray(u, uLong);
        byte[] res = new byte[this.n1];
        long[] vLong = new long[this.N1N2_BYTE_64];
        long[] tmpVLong = new long[this.N_BYTE_64];
        ReedSolomon.encode(res, m, this.K_BYTE * 8, this.n1, this.k, this.g, this.generatorPoly);
        ReedMuller.encode(vLong, res, this.n1, this.mulParam);
        System.arraycopy(vLong, 0, tmpVLong, 0, vLong.length);
        long[] sLong = new long[this.N_BYTE_64];
        Utils.fromByteArrayToLongArray(sLong, s);
        long[] tmpLong = new long[this.N_BYTE_64];
        this.gfCalculator.multLongs(tmpLong, r2, sLong);
        GF2PolynomialCalculator.addLongs(tmpLong, tmpLong, tmpVLong);
        GF2PolynomialCalculator.addLongs(tmpLong, tmpLong, e);
        Utils.resizeArray(v, this.n1n2, tmpLong, this.n, this.N1N2_BYTE_64, this.N1N2_BYTE_64);
    }

    private void decrypt(byte[] output, byte[] m, byte[] u, byte[] v, long[] y) {
        long[] uLongs = new long[this.N_BYTE_64];
        Utils.fromByteArrayToLongArray(uLongs, u);
        long[] vLongs = new long[this.N1N2_BYTE_64];
        Utils.fromByteArrayToLongArray(vLongs, v);
        long[] tmpV = new long[this.N_BYTE_64];
        System.arraycopy(vLongs, 0, tmpV, 0, vLongs.length);
        long[] tmpLong = new long[this.N_BYTE_64];
        this.gfCalculator.multLongs(tmpLong, y, uLongs);
        GF2PolynomialCalculator.addLongs(tmpLong, tmpLong, tmpV);
        byte[] tmp = new byte[this.n1];
        ReedMuller.decode(tmp, tmpLong, this.n1, this.mulParam);
        ReedSolomon.decode(m, tmp, this.n1, this.fft, this.delta, this.k, this.g);
        System.arraycopy(m, 0, output, 0, output.length);
    }

    private void generateRandomFixedWeight(long[] output, KeccakRandomGenerator random, int weight) {
        int i;
        int[] rand_u32 = new int[this.wr];
        byte[] rand_bytes = new byte[this.wr * 4];
        int[] support = new int[this.wr];
        int[] index_tab = new int[this.wr];
        long[] bit_tab = new long[this.wr];
        random.expandSeed(rand_bytes, 4 * weight);
        Pack.littleEndianToInt(rand_bytes, 0, rand_u32, 0, rand_u32.length);
        for (i = 0; i < weight; ++i) {
            support[i] = (int)((long)i + ((long)rand_u32[i] & 0xFFFFFFFFL) % (long)(this.n - i));
        }
        for (i = weight - 1; i >= 0; --i) {
            int found = 0;
            for (int j = i + 1; j < weight; ++j) {
                if (support[j] != support[i]) continue;
                found |= 1;
            }
            int mask = -found;
            support[i] = mask & i ^ ~mask & support[i];
        }
        for (i = 0; i < weight; ++i) {
            index_tab[i] = support[i] >>> 6;
            int pos = support[i] & 0x3F;
            bit_tab[i] = 1L << pos;
        }
        long val = 0L;
        int i2 = 0;
        while (i2 < this.N_BYTE_64) {
            val = 0L;
            for (int j = 0; j < weight; ++j) {
                int tmp = i2 - index_tab[j];
                int val1 = 1 ^ (tmp | -tmp) >>> 31;
                long mask = -val1;
                val |= bit_tab[j] & mask;
            }
            int n = i2++;
            output[n] = output[n] | val;
        }
    }

    void generatePublicKeyH(long[] out, KeccakRandomGenerator random) {
        byte[] randBytes = new byte[this.N_BYTE];
        random.expandSeed(randBytes, this.N_BYTE);
        long[] tmp = new long[this.N_BYTE_64];
        Utils.fromByteArrayToLongArray(tmp, randBytes);
        int n = this.N_BYTE_64 - 1;
        tmp[n] = tmp[n] & Utils.bitMask(this.n, 64L);
        System.arraycopy(tmp, 0, out, 0, out.length);
    }

    private void extractPublicKeys(long[] h, byte[] s, byte[] pk) {
        byte[] publicKeySeed = new byte[this.SEED_SIZE];
        System.arraycopy(pk, 0, publicKeySeed, 0, publicKeySeed.length);
        KeccakRandomGenerator randomPublic = new KeccakRandomGenerator(256);
        randomPublic.seedExpanderInit(publicKeySeed, publicKeySeed.length);
        long[] hLongBytes = new long[this.N_BYTE_64];
        this.generatePublicKeyH(hLongBytes, randomPublic);
        System.arraycopy(hLongBytes, 0, h, 0, h.length);
        System.arraycopy(pk, 40, s, 0, s.length);
    }

    private void extractKeysFromSecretKeys(long[] x, long[] y, byte[] pk, byte[] sk) {
        byte[] secretKeySeed = new byte[this.SEED_SIZE];
        System.arraycopy(sk, 0, secretKeySeed, 0, secretKeySeed.length);
        KeccakRandomGenerator secretKeySeedExpander = new KeccakRandomGenerator(256);
        secretKeySeedExpander.seedExpanderInit(secretKeySeed, secretKeySeed.length);
        this.generateRandomFixedWeight(x, secretKeySeedExpander, this.w);
        this.generateRandomFixedWeight(y, secretKeySeedExpander, this.w);
        System.arraycopy(sk, this.SEED_SIZE, pk, 0, pk.length);
    }

    private void extractCiphertexts(byte[] u, byte[] v, byte[] d, byte[] salt, byte[] ct) {
        System.arraycopy(ct, 0, u, 0, u.length);
        System.arraycopy(ct, u.length, v, 0, v.length);
        System.arraycopy(ct, u.length + v.length, d, 0, d.length);
        System.arraycopy(ct, u.length + v.length + d.length, salt, 0, salt.length);
    }
}

