/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket.httpforwarding;

import de.ponton.securelistener.administration.Constants;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.listener.servlet.TooMuchDataException;
import de.ponton.securelistener.websocket.ResponseSynchronizer;
import de.ponton.securelistener.websocket.SessionPool;
import de.ponton.securelistener.websocket.SessionPoolManager;
import de.ponton.securelistener.websocket.httpforwarding.HttpResponse;
import jakarta.inject.Inject;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpToWebsocketAdapter {
    private static final Logger LOG = LogManager.getLogger((String)"Listener.HttpToWebsocket");
    private final SessionPool sessionPool;
    private final ListenerProperties listenerConfig;
    private final ResponseSynchronizer synchronizer;

    @Inject
    public HttpToWebsocketAdapter(SessionPoolManager sessionPoolManager, ListenerProperties listenerConfig, ResponseSynchronizer synchronizer) {
        this.sessionPool = sessionPoolManager.getSessionPool("Data");
        this.listenerConfig = listenerConfig;
        this.synchronizer = synchronizer;
    }

    public void forwardHttpRequest(HttpServletRequest request, HttpServletResponse response, long sizeLimit) throws TimeoutException, IOException {
        if (!this.sessionPool.hasSessions()) {
            throw new IOException("No Messenger connected");
        }
        int timeout = this.listenerConfig.getInternalCommunicationTimeout();
        HttpResponse r = new HttpResponse(response);
        Session s = this.sessionPool.borrowSession(timeout, TimeUnit.SECONDS);
        this.synchronizer.prepareSession(s, r);
        try {
            this.sendControlHeaders(s, request);
        }
        catch (IOException e) {
            LOG.error("Error while sending headers on session [{}] : {}.", (Object)s.getId(), (Object)e.getMessage());
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.sendRequestHeaders(s, request);
        byte[] buffer = new byte[64000];
        int totalSize = 0;
        int len = 0;
        try (ServletInputStream in = request.getInputStream();){
            block18: while (len > -1) {
                len = in.read(buffer);
                switch (len) {
                    case -1: {
                        LOG.debug("[{}] sending transmission complete trigger", (Object)s.getId());
                        s.getBasicRemote().sendBinary(ByteBuffer.wrap(Constants.TRANSMISSION_OK), true);
                        continue block18;
                    }
                    case 0: {
                        continue block18;
                    }
                }
                LOG.debug("[{}] sending request data: {} bytes", (Object)s.getId(), (Object)len);
                s.getBasicRemote().sendBinary(ByteBuffer.wrap(buffer, 0, len), false);
                if ((long)(totalSize += len) <= sizeLimit) continue;
                throw new TooMuchDataException();
            }
            this.synchronizer.waitForResponse(s);
        }
        catch (IOException e) {
            s.getBasicRemote().sendBinary(ByteBuffer.wrap(Constants.TRANSMISSION_ABORT), true);
            LOG.error("Error while sending request data on session [{}] : {}.", (Object)s.getId(), (Object)e.toString());
            throw e;
        }
        finally {
            this.sessionPool.returnSession(s);
        }
    }

    private void sendRequestHeaders(Session s, HttpServletRequest request) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                stringBuilder.append(headerName);
                stringBuilder.append(": ");
                stringBuilder.append((String)headerValues.nextElement());
                stringBuilder.append("\r\n");
            }
        }
        stringBuilder.append("X-Remote-Address").append(": ").append(request.getRemoteAddr()).append("\r\n");
        stringBuilder.append("\r\n");
        byte[] data = stringBuilder.toString().getBytes();
        LOG.debug("[{}] sending request headers: {} bytes", (Object)s.getId(), (Object)data.length);
        s.getBasicRemote().sendBinary(ByteBuffer.wrap(data), false);
    }

    private void sendControlHeaders(Session s, HttpServletRequest request) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getMethod().toUpperCase());
        builder.append("\r\n");
        builder.append(request.getServletPath());
        builder.append("\r\n");
        builder.append(this.getOriginalUrl(request));
        builder.append("\r\n");
        builder.append("X-inbound-protocol");
        builder.append(": ");
        builder.append(request.isSecure() ? "HTTPS" : "HTTP");
        builder.append("\r\n");
        builder.append("X-Forwarded-For");
        builder.append(": ");
        builder.append(request.getRemoteAddr());
        builder.append("\r\n");
        LOG.debug("sending control headers");
        s.getBasicRemote().sendText(builder.toString());
    }

    private String getOriginalUrl(HttpServletRequest httpServletRequest) {
        String query = httpServletRequest.getQueryString();
        StringBuffer url = httpServletRequest.getRequestURL();
        if (Objects.nonNull(query)) {
            url.append("?").append(query);
        }
        return URLDecoder.decode(url.toString(), StandardCharsets.UTF_8);
    }
}

