/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.websocket.ConfigEndpoint;
import de.ponton.securelistener.websocket.DataEndpoint;
import de.ponton.securelistener.websocket.DefaultServlet;
import de.ponton.securelistener.websocket.GuiceEndpointFactory;
import de.ponton.securelistener.websocket.SSLCertificateFactory;
import jakarta.inject.Inject;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.management.ManagementFactory;
import java.security.KeyStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class WebsocketServer {
    private static final int SIZE64KB = 65536;
    private static final int IDLE_TIMEOUT = 60000;
    private static final Logger LOG = LogManager.getLogger((String)"Listener.WebsockerServer");
    private final GuiceEndpointFactory myConfigurator;
    private final SSLCertificateFactory certificateFactory;
    private final ListenerProperties listenerProperties;
    private int port;
    private String host;
    private Server server;

    @Inject
    public WebsocketServer(GuiceEndpointFactory myConfigurator, SSLCertificateFactory certificateFactory, ListenerProperties config) {
        this.myConfigurator = myConfigurator;
        this.certificateFactory = certificateFactory;
        this.listenerProperties = config;
    }

    public void startup() throws Exception {
        this.server = this.createServer();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addBean((Object)mbeanContainer);
        try {
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler((Handler)context);
            this.server.setHandler((Handler)stats);
            JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)context, (servletContext, container) -> {
                container.setDefaultMaxBinaryMessageBufferSize(65536);
                container.setDefaultMaxTextMessageBufferSize(65536);
                container.setDefaultMaxSessionIdleTimeout(60000L);
                ServerEndpointConfig configEndpoint = ServerEndpointConfig.Builder.create(ConfigEndpoint.class, (String)"/config").configurator((ServerEndpointConfig.Configurator)this.myConfigurator).build();
                container.addEndpoint(configEndpoint);
                ServerEndpointConfig dataEndpoint = ServerEndpointConfig.Builder.create(DataEndpoint.class, (String)"/data").configurator((ServerEndpointConfig.Configurator)this.myConfigurator).build();
                container.addEndpoint(dataEndpoint);
                context.addServlet(DefaultServlet.class, "/");
            });
            this.server.start();
            LOG.info("started Websocket server on {}:{}", (Object)this.host, (Object)this.port);
        }
        catch (Exception e) {
            LOG.error("could not start Websocket server on {}:{}", (Object)this.host, (Object)this.port, (Object)e);
            this.shutdown();
            throw e;
        }
    }

    private Server createServer() {
        ServerConnector serverConnector;
        QueuedThreadPool tp = new QueuedThreadPool();
        tp.setDaemon(false);
        tp.setName("WebsocketPort");
        Server server = new Server((ThreadPool)tp);
        server.setStopTimeout(1000L);
        HttpConfiguration httpConfig = new HttpConfiguration();
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        src.setSniRequired(false);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)src);
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        this.port = this.listenerProperties.getInternalCommunicationPort();
        if (this.listenerProperties.isInternalCommunicationSSL()) {
            serverConnector = this.createSecureConnector(server, httpFactory);
            serverConnector.setName("Secure WebSocket " + this.port);
        } else {
            serverConnector = new ServerConnector(server, new ConnectionFactory[]{httpFactory});
            serverConnector.setName("Plain WebSocket " + this.port);
        }
        LOG.info("Created {}", (Object)serverConnector.getName());
        this.host = this.listenerProperties.getInternalCommunicationHost();
        if (!"*".equals(this.host)) {
            serverConnector.setHost(this.host);
        }
        serverConnector.setPort(this.port);
        serverConnector.setIdleTimeout(60000L);
        Slf4jRequestLogWriter writer = new Slf4jRequestLogWriter();
        writer.setLoggerName("Listener.HTTP");
        CustomRequestLog requestLog = new CustomRequestLog((RequestLog.Writer)writer, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
        server.setRequestLog((RequestLog)requestLog);
        server.addConnector((Connector)serverConnector);
        return server;
    }

    private ServerConnector createSecureConnector(Server server, HttpConnectionFactory httpFactory) {
        KeyStore serverKeystore = this.certificateFactory.generateCertificate();
        SslContextFactory.Server factory = new SslContextFactory.Server();
        factory.setTrustAll(true);
        factory.setKeyStore(serverKeystore);
        factory.setKeyManagerPassword("changeit");
        factory.setKeyStorePassword("changeit");
        factory.setRenegotiationAllowed(false);
        factory.addExcludeProtocols(new String[]{"SSLv2Hello", "SSLv3"});
        return new ServerConnector(server, factory, new ConnectionFactory[]{httpFactory});
    }

    public void shutdown() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.join();
                LOG.debug("Websocket service stopped");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

