/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.proxy;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.StatusSingleton;
import de.ponton.securelistener.listener.ParanoidErrorHandler;
import de.ponton.securelistener.proxy.IpAccessHandler;
import de.ponton.securelistener.proxy.LoggingConnectHandler;
import de.ponton.securelistener.proxy.LoggingProxyServlet;
import jakarta.servlet.Servlet;
import java.util.Arrays;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ProxyServer {
    private static final int PROXY_CONNECT_TIMEOUT = 10000;
    private static final Logger LOG = LogManager.getLogger((String)"Listener.ProxyServer");
    private Server server;
    private boolean running;

    public void startProxyPort() throws Exception {
        if (!this.running) {
            LOG.debug("starting proxy server");
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setDaemon(true);
            threadPool.setName("Proxy");
            this.server = new Server((ThreadPool)threadPool);
            this.server.setStopTimeout(1L);
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(false);
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
            ServerConnector proxySocket = new ServerConnector(this.server, new ConnectionFactory[]{httpFactory});
            String host = SecureListener.getInstance().getConfig().getProxyAddress();
            int port = SecureListener.getInstance().getConfig().getProxyPort();
            proxySocket.setName(host + ":" + port);
            proxySocket.setPort(port);
            proxySocket.setReuseAddress(true);
            if (!"*".equals(host)) {
                proxySocket.setHost(host);
            }
            ServletContextHandler context = new ServletContextHandler();
            ServletHolder holder = new ServletHolder((Servlet)new LoggingProxyServlet());
            holder.setInitParameter("connectTimeout", String.valueOf(10000));
            holder.setInitParameter("idleTimeout", "" + SecureListener.getInstance().getConfig().getProxyTimeout());
            holder.setInitParameter("timeout", "" + SecureListener.getInstance().getConfig().getProxyTimeout());
            String[] whiteList = SecureListener.getInstance().getConfig().getProxyDestinationWhiteList();
            if (whiteList.length > 0 && !"*".equals(whiteList[0])) {
                StringBuilder b = new StringBuilder();
                b.append(whiteList[0]);
                for (int i = 1; i < whiteList.length; ++i) {
                    b.append(',');
                    b.append(whiteList[i]);
                }
                holder.setInitParameter("whiteList", b.toString());
            }
            holder.setAsyncSupported(true);
            context.addServlet(holder, "/*");
            ParanoidErrorHandler paranoidErrorHandler = new ParanoidErrorHandler();
            context.setErrorHandler((Request.Handler)paranoidErrorHandler);
            LoggingConnectHandler connectHandler = new LoggingConnectHandler((Handler)context);
            connectHandler.setConnectTimeout(10000L);
            if (whiteList.length > 0 && !"*".equals(whiteList[0])) {
                Set set = connectHandler.getWhiteListHosts();
                set.addAll(Arrays.asList(whiteList));
            }
            connectHandler.setIdleTimeout(SecureListener.getInstance().getConfig().getProxyTimeout());
            IpAccessHandler ipAccessHandler = new IpAccessHandler();
            String[] entries = SecureListener.getInstance().getConfig().getProxyAccessList();
            if (entries.length > 0 && !"*".equals(entries[0])) {
                ipAccessHandler.exclude(entries);
            }
            ipAccessHandler.setServer(this.server);
            ipAccessHandler.setHandler((Handler)connectHandler);
            this.server.setHandler((Handler)ipAccessHandler);
            this.server.addBean((Object)paranoidErrorHandler);
            this.server.addConnector((Connector)proxySocket);
            this.server.start();
            this.running = true;
            LOG.info("Proxy Server started on {}", (Object)proxySocket.getName());
            StatusSingleton.getInstance().setProxy(proxySocket.getName());
        }
    }

    public void stopProxyPort() throws InterruptedException {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.join();
            }
            catch (Exception e1) {
                LOG.error("exception during shutdown of proxy port", (Throwable)e1);
            }
        }
        this.running = false;
    }
}

