/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.listener;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.StatusSingleton;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.listener.ParanoidErrorHandler;
import de.ponton.securelistener.listener.servlet.Listener;
import de.ponton.securelistener.security.PontonKeystore;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.Servlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@Singleton
public class HTTPServer {
    private static final Logger _log = LogManager.getLogger((String)"Listener.HTTPServer");
    private final List<Server> servers;
    private final Listener listener;
    private final AtomicBoolean httpActive;
    private final AtomicBoolean httpsActive;
    private String HTTPAddressPort;
    private String HTTPSAddressPort;

    @Inject
    public HTTPServer(Listener listener) {
        this.listener = listener;
        this.httpActive = new AtomicBoolean(false);
        this.httpsActive = new AtomicBoolean(false);
        this.servers = new ArrayList<Server>();
    }

    private Server prepareServer() throws Exception {
        System.setProperty("org.mortbay.http.Version.paranoid", "true");
        QueuedThreadPool tp = new QueuedThreadPool();
        tp.setDaemon(true);
        tp.setName("MessagePort");
        Server server = new Server((ThreadPool)tp);
        server.setStopTimeout(1000L);
        server.setStopAtShutdown(true);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ParanoidErrorHandler paranoidErrorHandler = new ParanoidErrorHandler();
        context.setErrorHandler((Request.Handler)paranoidErrorHandler);
        String[] listeners = this.getConfig().getAllowedListenerTypes();
        ServletHolder holder = new ServletHolder((Servlet)this.listener);
        for (String listener : listeners) {
            context.addServlet(holder, "/pontonxp/" + listener);
        }
        ResourceHandler resource = new ResourceHandler();
        resource.setDirAllowed(false);
        resource.setBaseResourceAsString("webroot");
        ContextHandlerCollection handlers = new ContextHandlerCollection(new ContextHandler[0]);
        handlers.setHandlers(new Handler[]{context, resource});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)handlers);
        server.setHandler(this.wrapWithSecurityHandler((Handler)stats));
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbeanContainer);
        server.start();
        return server;
    }

    private ListenerProperties getConfig() {
        return SecureListener.getInstance().getConfig();
    }

    public void startHttpsPort() throws Exception {
        _log.debug("starting HTTPS server");
        Server server = this.prepareServer();
        this.servers.add(server);
        SecureListener instance = SecureListener.getInstance();
        PontonSslContextFactory sslContextFactory = new PontonSslContextFactory(!instance.getConfig().isSenderCertificateAuth());
        sslContextFactory.setProvider("BCJSSE");
        sslContextFactory.setProtocol("TLS");
        sslContextFactory.setRenegotiationAllowed(false);
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
        secureRequestCustomizer.setSniHostCheck(instance.getConfig().isSecureListenerSniEnabled());
        sslContextFactory.setProvider("BCJSSE");
        sslContextFactory.setCertificateFactoryProvider("BC");
        sslContextFactory.setKeyStore(this.buildKeyStoreWithPrivateKeys());
        sslContextFactory.setKeyManagerPassword("changeit");
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyManagerFactoryAlgorithm("PKIX");
        sslContextFactory.setKeyStoreProvider("BC");
        sslContextFactory.setTrustStore(this.buildTrustStore());
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustManagerFactoryAlgorithm("PKIX");
        sslContextFactory.setTrustStoreProvider("BC");
        sslContextFactory.setUseCipherSuitesOrder(false);
        this.initProtocols((SslContextFactory)sslContextFactory, instance.getConfig());
        this.initCiphers((SslContextFactory)sslContextFactory, instance.getConfig());
        if (instance.getConfig().isSenderCertificateAuth()) {
            sslContextFactory.setNeedClientAuth(true);
        } else {
            sslContextFactory.setWantClientAuth(instance.getConfig().isSenderCertificateCheck());
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        HTTP2ServerConnectionFactory http2ServerConnectionFactory = new HTTP2ServerConnectionFactory(httpsConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(httpConnectionFactory.getProtocol());
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory.Server)sslContextFactory, alpn.getProtocol());
        ServerConnector httpsSocket = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, alpn, http2ServerConnectionFactory, httpConnectionFactory});
        httpsSocket.setReuseAddress(true);
        String host = instance.getConfig().getSecureListenerHttpsAddress();
        int port = instance.getConfig().getSecureListenerHttpsPort();
        httpsSocket.setName(host + ":" + port);
        httpsSocket.setPort(port);
        if (!"*".equals(host)) {
            httpsSocket.setHost(host);
        }
        httpsSocket.setIdleTimeout((long)this.getConfig().getSecureListenerIdleConnectionTimeout());
        server.addConnector((Connector)httpsSocket);
        try {
            Enumeration<String> aliases = instance.getTrustKeystore().getRawKeystore().aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert;
                String alias = aliases.nextElement();
                if (!instance.getTrustKeystore().getRawKeystore().isCertificateEntry(alias) || (cert = (X509Certificate)instance.getTrustKeystore().getRawKeystore().getCertificate(alias)).getIssuerX500Principal().equals(cert.getSubjectX500Principal())) continue;
                _log.debug("trusted certificate: " + cert.getSubjectX500Principal().getName());
            }
        }
        catch (KeyStoreException e) {
            _log.error("error during HTTPS server startup: " + String.valueOf(e));
        }
        httpsSocket.start();
        this.httpsActive.set(true);
        this.HTTPSAddressPort = this.getAddressAndPort(httpsSocket);
        StatusSingleton.getInstance().setHttps(this.HTTPSAddressPort);
        StatusSingleton.getInstance().setHttpsClientCertCheck(instance.getConfig().isSenderCertificateCheck());
        StatusSingleton.getInstance().setHttpsClientCertAuth(instance.getConfig().isSenderCertificateAuth());
        _log.info("HTTPS server started on " + this.HTTPSAddressPort);
    }

    private KeyStore buildTrustStore() throws KeyStoreException, NoSuchProviderException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore pkcs12KeyStore = KeyStore.getInstance("PKCS12", "BC");
        pkcs12KeyStore.load(null, "changeit".toCharArray());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        PontonKeystore pontonKeystore = SecureListener.getInstance().getTrustKeystore();
        pontonKeystore.getAllCACertificates().forEach(cert -> {
            try {
                pkcs12KeyStore.setCertificateEntry(UUID.nameUUIDFromBytes(cert.getEncoded()).toString(), certificateFactory.generateCertificate(new ByteArrayInputStream(cert.getEncoded())));
            }
            catch (KeyStoreException | CertificateException e) {
                _log.error("Could not load SSL Server Certificate for alias '%s'".formatted(cert.getSubjectX500Principal().getName()), (Throwable)e);
            }
        });
        return pkcs12KeyStore;
    }

    private KeyStore buildKeyStoreWithPrivateKeys() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyStore pkcs12KeyStore = KeyStore.getInstance("PKCS12", "BC");
        pkcs12KeyStore.load(null, "changeit".toCharArray());
        PontonKeystore keystore = SecureListener.getInstance().getServerKeystore();
        this.getConfig().getPrivateKeyInfos().forEach(privateKeyInfo -> {
            try {
                PrivateKey key = keystore.getPrivateKey(privateKeyInfo.alias(), privateKeyInfo.password().toCharArray());
                Certificate[] certificateChain = keystore.getCertificateChainForPrivateKey(privateKeyInfo.alias());
                X509Certificate cert = (X509Certificate)certificateChain[0];
                pkcs12KeyStore.setKeyEntry(privateKeyInfo.alias(), key, "changeit".toCharArray(), certificateChain);
                _log.info("Loaded SSL Server Certificate with alias '%s', serial number '%s' and subject '%s' ".formatted(privateKeyInfo.alias(), cert.getSerialNumber(), cert.getSubjectX500Principal()));
            }
            catch (Exception e) {
                _log.error("Could not load SSL Server Certificate for alias '%s'".formatted(privateKeyInfo.alias()), (Throwable)e);
            }
        });
        return pkcs12KeyStore;
    }

    private void initProtocols(SslContextFactory factory, ListenerProperties config) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException {
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        sslContext.init(null, null, null);
        String[] allProtocols = sslContext.createSSLEngine().getSupportedProtocols();
        String[] disabledProtocols = config.getDisabledProtocols();
        ArrayList<String> includedProtocols = new ArrayList<String>();
        ArrayList<String> excludedProtocols = new ArrayList<String>();
        for (String protocol : allProtocols) {
            boolean exclude = false;
            for (String disabledProtocol : disabledProtocols) {
                if (!protocol.matches(disabledProtocol)) continue;
                exclude = true;
                break;
            }
            if (exclude) {
                excludedProtocols.add(protocol);
                continue;
            }
            includedProtocols.add(protocol);
        }
        _log.info("Included SSL Protocols:");
        factory.setIncludeProtocols(includedProtocols.toArray(new String[0]));
        Collections.sort(includedProtocols);
        for (String included : includedProtocols) {
            _log.info("  " + included);
        }
        _log.info("Excluded SSL Protocols:");
        factory.setExcludeProtocols(excludedProtocols.toArray(new String[0]));
        Collections.sort(excludedProtocols);
        for (String excluded : excludedProtocols) {
            _log.info("  " + excluded);
        }
    }

    private void initCiphers(SslContextFactory factory, ListenerProperties config) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        sslContext.init(null, null, null);
        String[] allCiphers = sslContext.createSSLEngine().getSupportedCipherSuites();
        String[] disabledCiphers = config.getDisabledSSLCiphers();
        ArrayList<String> includedCiphers = new ArrayList<String>();
        ArrayList<String> excludedCiphers = new ArrayList<String>();
        for (String cipher : allCiphers) {
            boolean exclude = false;
            for (String disabledCipher : disabledCiphers) {
                if (!cipher.matches(disabledCipher)) continue;
                exclude = true;
                break;
            }
            if (exclude) {
                excludedCiphers.add(cipher);
                continue;
            }
            includedCiphers.add(cipher);
        }
        _log.info("Included SSL Ciphers:");
        factory.setIncludeCipherSuites(includedCiphers.toArray(new String[0]));
        Collections.sort(includedCiphers);
        for (String included : includedCiphers) {
            _log.info("  " + included);
        }
        _log.info("Excluded SSL Ciphers:");
        factory.setExcludeCipherSuites(excludedCiphers.toArray(new String[0]));
        Collections.sort(excludedCiphers);
        for (String excluded : excludedCiphers) {
            _log.info("  " + excluded);
        }
    }

    private String getAddressAndPort(ServerConnector connector) {
        return connector.getName();
    }

    public void startHttpPort() throws Exception {
        _log.debug("starting HTTP server");
        Server server = this.prepareServer();
        this.servers.add(server);
        SecureListener instance = SecureListener.getInstance();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        ServerConnector httpSocket = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig), new HTTP2CServerConnectionFactory(httpConfig)});
        httpSocket.setReuseAddress(true);
        String host = instance.getConfig().getSecureListenerHttpAddress();
        int port = instance.getConfig().getSecureListenerHttpPort();
        httpSocket.setName(host + ":" + port);
        httpSocket.setPort(port);
        if (!"*".equals(host)) {
            httpSocket.setHost(host);
        }
        httpSocket.setIdleTimeout((long)this.getConfig().getSecureListenerIdleConnectionTimeout());
        server.addConnector((Connector)httpSocket);
        httpSocket.start();
        this.httpActive.set(true);
        this.HTTPAddressPort = this.getAddressAndPort(httpSocket);
        StatusSingleton.getInstance().setHttp(this.HTTPAddressPort);
        _log.info("HTTP server started on " + this.HTTPAddressPort);
    }

    public void shutdown() {
        this.servers.forEach(server -> {
            try {
                Arrays.stream(server.getConnectors()).forEach(connector -> {
                    try {
                        connector.stop();
                        server.removeConnector(connector);
                        if (connector.getName().equals(this.HTTPAddressPort)) {
                            this.HTTPAddressPort = null;
                            this.httpActive.set(false);
                        }
                        if (connector.getName().equals(this.HTTPSAddressPort)) {
                            this.HTTPSAddressPort = null;
                            this.httpsActive.set(false);
                        }
                    }
                    catch (Exception e) {
                        _log.error("Cannot remove connector (" + connector.getName() + ") from server " + String.valueOf(e));
                    }
                });
                server.stop();
                server.join();
            }
            catch (Exception e) {
                _log.error("Cannot stop server " + String.valueOf(e));
            }
        });
        this.servers.clear();
    }

    public boolean isHttpSocketActive() {
        return this.httpActive.get();
    }

    public boolean isHttpsSocketActive() {
        return this.httpsActive.get();
    }

    public String getHttpsAddressPort() {
        return this.HTTPSAddressPort;
    }

    public String getHttpAddressPort() {
        return this.HTTPAddressPort;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    private Handler wrapWithSecurityHandler(Handler h) {
        ConstraintMapping traceMapping = new ConstraintMapping();
        traceMapping.setConstraint(Constraint.FORBIDDEN);
        traceMapping.setMethod("TRACE");
        traceMapping.setPathSpec("/");
        ConstraintMapping optionsMapping = new ConstraintMapping();
        optionsMapping.setConstraint(Constraint.FORBIDDEN);
        optionsMapping.setMethod("OPTIONS");
        optionsMapping.setPathSpec("/");
        ConstraintSecurityHandler handler = new ConstraintSecurityHandler();
        handler.addConstraintMapping(traceMapping);
        handler.addConstraintMapping(optionsMapping);
        handler.setHandler(h);
        return handler;
    }

    private static class PontonSslContextFactory
    extends SslContextFactory.Server {
        private String certificateFactoryProvider;
        private final boolean usePontonTrustManager;

        private PontonSslContextFactory(boolean usePontonTrustManager) {
            this.usePontonTrustManager = usePontonTrustManager;
        }

        public void setCertificateFactoryProvider(String provider) {
            this.certificateFactoryProvider = provider;
        }

        protected CertificateFactory getCertificateFactoryInstance(String type) throws CertificateException {
            if (this.certificateFactoryProvider != null) {
                try {
                    return CertificateFactory.getInstance(type, this.certificateFactoryProvider);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.getCertificateFactoryInstance(type);
        }

        protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
            if (this.usePontonTrustManager) {
                return new TrustManager[]{new PontonTrustManager(SecureListener.getInstance().getTrustKeystore())};
            }
            return super.getTrustManagers(trustStore, crls);
        }
    }

    private static class PontonTrustManager
    implements X509TrustManager {
        private final PontonKeystore trustKeystore;
        private final X509Certificate[] caCertificates;

        private PontonTrustManager(PontonKeystore trustKeystore) {
            this.trustKeystore = trustKeystore;
            this.caCertificates = this.trustKeystore.getAllCACertificates().toArray(new X509Certificate[0]);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.trustKeystore.checkCertificate(chain);
            }
            catch (GeneralSecurityException e) {
                throw new CertificateException(e);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.trustKeystore.checkCertificate(chain);
            }
            catch (GeneralSecurityException e) {
                throw new CertificateException(e);
            }
        }

        @Override
        public synchronized X509Certificate[] getAcceptedIssuers() {
            return this.caCertificates;
        }
    }
}

