/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp.filesystem;

import de.ponton.securelistener.ftp.FtpUser;
import de.ponton.securelistener.ftp.filesystem.ListenerFileSystemView;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;

public class ListenerFtpFile
implements FtpFile,
Comparable<ListenerFtpFile> {
    private boolean _isHidden;
    private boolean _isDirectory;
    private boolean _isFile;
    private boolean _fileExists = true;
    private boolean _writePermission;
    private long _fileSize;
    private long _fileLastModified;
    private boolean _fileCanRead;
    private final String _fileName;
    private final String _fullName;
    private final Set<ListenerFtpFile> _children = new TreeSet<ListenerFtpFile>();
    private final ListenerFtpFile _parent;
    private final FtpUser _user;
    private final ListenerFileSystemView _fileSystemView;
    private String _listener;

    protected ListenerFtpFile(ListenerFtpFile parent, String fileName, User user, boolean isDirectory, ListenerFileSystemView view) {
        String parentFullName;
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this._fileName = fileName.trim();
        if (this._fileName.length() == 0) {
            throw new IllegalArgumentException("fileName can not be empty");
        }
        this._fileSystemView = view;
        this._parent = parent;
        this._fullName = this._parent != null ? ((parentFullName = this._parent.getAbsolutePath()).endsWith("/") ? parentFullName + fileName : parentFullName + "/" + fileName) : "/";
        this._isDirectory = isDirectory;
        this._user = (FtpUser)user;
    }

    public String getAbsolutePath() {
        return this._fullName;
    }

    public String getName() {
        return this._fileName;
    }

    public boolean isHidden() {
        return this._isHidden;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public boolean isFile() {
        return this._isFile;
    }

    public boolean doesExist() {
        return this._fileExists;
    }

    public boolean isReadable() {
        return this._fileCanRead;
    }

    public boolean isWritable() {
        return this._writePermission;
    }

    public boolean isRemovable() {
        if ("/".equals(this._fileName)) {
            return false;
        }
        return this.isWritable();
    }

    public String getOwnerName() {
        return "user";
    }

    public String getGroupName() {
        return "group";
    }

    public int getLinkCount() {
        return this._isDirectory ? 3 : 1;
    }

    public long getLastModified() {
        return this._fileLastModified;
    }

    public boolean setLastModified(long time) {
        this._fileLastModified = time;
        return true;
    }

    public long getSize() {
        return this._fileSize;
    }

    public boolean mkdir() {
        if ("PlainListener".equals(this.getParent().getListener())) {
            this._isDirectory = true;
            this._fileSystemView.addChildObject(this);
            this.setListener("PlainListener");
            return true;
        }
        return false;
    }

    public boolean delete() {
        boolean retVal = false;
        if (this.isRemovable()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean move(FtpFile destination) {
        return false;
    }

    public List<FtpFile> listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        return new ArrayList<FtpFile>(this._children);
    }

    public OutputStream createOutputStream(long offset) throws IOException {
        return null;
    }

    public InputStream createInputStream(long offset) throws IOException {
        if (!this.isReadable()) {
            throw new IOException("No read permission : " + this._fileName);
        }
        return null;
    }

    public void addChildObject(ListenerFtpFile child) {
        this._children.add(child);
    }

    public ListenerFtpFile getChild(String childName) {
        ListenerFtpFile child2 = null;
        for (ListenerFtpFile child2 : this._children) {
            if (child2.getName().equals(childName)) break;
            child2 = null;
        }
        return child2;
    }

    @Override
    public int compareTo(ListenerFtpFile o) {
        return this.getName().compareTo(o.getName());
    }

    public ListenerFtpFile getParent() {
        return this._parent;
    }

    public FtpUser getFtpUser() {
        return this._user;
    }

    public void setWritePermission(boolean writePermission) {
        this._writePermission = writePermission;
    }

    public String getListener() {
        return this._listener;
    }

    public void setListener(String listener) {
        this._listener = listener;
    }

    public void setSize(long transmittedBytes) {
        this._fileSize = transmittedBytes;
    }

    public void setExists(boolean exists) {
        this._fileExists = exists;
    }

    public void setFile(boolean isFile) {
        this._isFile = isFile;
    }

    public Object getPhysicalFile() {
        return null;
    }
}

