/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp;

import de.ponton.securelistener.StatusSingleton;
import de.ponton.securelistener.ftp.filesystem.ListenerFileSystemView;
import de.ponton.securelistener.ftp.filesystem.ListenerFtpFile;
import de.ponton.securelistener.websocket.ftpforwarding.FtpResponse;
import de.ponton.securelistener.websocket.ftpforwarding.FtpToWebsocketAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.TimeoutException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.util.IoUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class STOR
extends AbstractCommand {
    private static final Logger _transferLog = LogManager.getLogger((String)"transfer.ftp");
    private static final Logger LOG = LogManager.getLogger(STOR.class);
    private FtpToWebsocketAdapter websocketAdapter;

    public STOR(FtpToWebsocketAdapter websocketAdapter) {
        this.websocketAdapter = websocketAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            ServerDataConnectionFactory dataConnectionFactory;
            InetAddress address;
            String fileName = request.getArgument();
            if (fileName == null) {
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)501, (String)"STOR", null));
                return;
            }
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write((Object)new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            FtpFile file = null;
            try {
                file = session.getFileSystemView().getFile(fileName);
            }
            catch (Exception ex) {
                LOG.debug("Exception getting file object", (Throwable)ex);
            }
            if (file == null) {
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)550, (String)"STOR.invalid", (String)fileName));
                return;
            }
            fileName = file.getAbsolutePath();
            if (!file.isWritable()) {
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)550, (String)"STOR.permission", (String)fileName));
                return;
            }
            session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)150, (String)"STOR", (String)fileName)).awaitUninterruptibly(10000L);
            try {
                dataConnectionFactory = session.getDataConnection();
                dataConnection = dataConnectionFactory.openConnection();
            }
            catch (Exception e) {
                LOG.debug("Exception getting the input data stream", (Throwable)e);
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)425, (String)"STOR", (String)fileName));
                session.resetState();
                session.getDataConnection().closeDataConnection();
                return;
            }
            boolean failure = false;
            OutputStream outStream = null;
            try {
                String userName = session.getUser().getName();
                _transferLog.info("receiving message from " + userName + "[" + String.valueOf(dataConnectionFactory.getInetAddress()) + "]");
                StatusSingleton.getInstance().setLastMessageIP(dataConnectionFactory.getInetAddress().getHostAddress());
                StatusSingleton.getInstance().setLastMessageReceivedTime(System.currentTimeMillis());
                FtpResponse response = this.websocketAdapter.forwardFtpRequest(dataConnection, session, (ListenerFtpFile)file);
                LOG.info("File uploaded {}", (Object)fileName);
                ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                ftpStat.setUpload(session, file, response.getTransmittedBytes());
                int responseCode = response.getResponseCode();
                if (responseCode >= 400) {
                    failure = true;
                    String error = response.getMessage();
                    session.write((Object)new DefaultFtpReply(451, "Requested action aborted. Error in processing: " + error));
                } else {
                    ListenerFtpFile ftpFile = (ListenerFtpFile)file;
                    ftpFile.setSize(response.getTransmittedBytes());
                    ftpFile.setExists(true);
                    ftpFile.setFile(true);
                    ((ListenerFileSystemView)session.getFileSystemView()).addChildObject(ftpFile);
                }
            }
            catch (SocketException ex) {
                _transferLog.error("Socket exception during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)426, (String)"STOR", (String)fileName));
            }
            catch (IOException ex) {
                _transferLog.error("IOException during data transfer: " + ex.toString());
                failure = true;
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)551, (String)"STOR", (String)fileName));
            }
            catch (TimeoutException e) {
                _transferLog.error("timeout while waiting for a free Messenger connection to forward FTP request");
                failure = true;
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)550, (String)"STOR", (String)fileName));
            }
            finally {
                IoUtils.close(outStream);
            }
            if (!failure) {
                session.write((Object)LocalizedFtpReply.translate((FtpIoSession)session, (FtpRequest)request, (FtpServerContext)context, (int)226, (String)"STOR", (String)fileName));
            }
        }
        finally {
            session.resetState();
            session.getDataConnection().closeDataConnection();
        }
    }
}

