/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp;

import de.ponton.securelistener.ftp.FtpExchangeUser;
import de.ponton.securelistener.ftp.FtpUser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.impl.AbstractUserManager;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginRequest;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.apache.ftpserver.util.BaseProperties;
import org.apache.ftpserver.util.IoUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesUserManager
extends AbstractUserManager {
    public static final String ATTR_PARTNER_LOCAL_ID = "partnerlocalid";
    public static final String UNCHANGED_PASSWORD = "***";
    private final Logger LOG = LogManager.getLogger(PropertiesUserManager.class);
    private static final String PREFIX = "ftpserver.user.";
    private BaseProperties userDataProp;
    private File userDataFile;
    private URL userUrl;

    public PropertiesUserManager(PasswordEncryptor passwordEncryptor, File userDataFile, String adminName) {
        super(adminName, passwordEncryptor);
        this.loadFromFile(userDataFile);
    }

    public PropertiesUserManager(PasswordEncryptor passwordEncryptor, URL userDataPath, String adminName) {
        super(adminName, passwordEncryptor);
        this.loadFromUrl(userDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(File userDataFile) {
        block9: {
            try {
                this.userDataProp = new BaseProperties();
                if (userDataFile == null) break block9;
                this.LOG.debug("File configured, will try loading");
                if (userDataFile.exists()) {
                    this.userDataFile = userDataFile;
                    this.LOG.debug("File found on file system");
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(userDataFile);
                        this.userDataProp.load((InputStream)fis);
                    }
                    catch (Throwable throwable) {
                        IoUtils.close(fis);
                        throw throwable;
                    }
                    IoUtils.close((InputStream)fis);
                    break block9;
                }
                this.LOG.debug("File not found on file system, try loading from classpath");
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(userDataFile.getPath());
                if (is != null) {
                    try {
                        this.userDataProp.load(is);
                        break block9;
                    }
                    finally {
                        IoUtils.close((InputStream)is);
                    }
                }
                throw new FtpServerConfigurationException("User data file specified but could not be located, neither on the file system or in the classpath: " + userDataFile.getPath());
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Error loading user data file : " + String.valueOf(userDataFile), (Throwable)e);
            }
        }
    }

    private void loadFromUrl(URL userDataPath) {
        block5: {
            try {
                this.userDataProp = new BaseProperties();
                if (userDataPath == null) break block5;
                this.LOG.debug("URL configured, will try loading");
                this.userUrl = userDataPath;
                InputStream is = null;
                is = userDataPath.openStream();
                try {
                    this.userDataProp.load(is);
                }
                finally {
                    IoUtils.close((InputStream)is);
                }
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Error loading user data resource : " + String.valueOf(userDataPath), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        BaseProperties baseProperties = this.userDataProp;
        synchronized (baseProperties) {
            if (this.userDataFile != null) {
                this.LOG.debug("Refreshing user manager using file: " + this.userDataFile.getAbsolutePath());
                this.loadFromFile(this.userDataFile);
            } else {
                this.LOG.debug("Refreshing user manager using URL: " + this.userUrl.toString());
                this.loadFromUrl(this.userUrl);
            }
        }
    }

    public File getFile() {
        return this.userDataFile;
    }

    public synchronized void save(User usr) throws FtpException {
        if (usr.getName() == null) {
            throw new NullPointerException("User name is null.");
        }
        String thisPrefix = PREFIX + usr.getName() + ".";
        this.userDataProp.setProperty(thisPrefix + "userpassword", this.getPassword(usr));
        String home = usr.getHomeDirectory();
        if (home == null) {
            home = "/";
        }
        this.userDataProp.setProperty(thisPrefix + "homedirectory", home);
        this.userDataProp.setProperty(thisPrefix + "enableflag", usr.getEnabled());
        this.userDataProp.setProperty(thisPrefix + "writepermission", usr.authorize((AuthorizationRequest)new WriteRequest()) != null);
        this.userDataProp.setProperty(thisPrefix + "idletime", usr.getMaxIdleTime());
        if (usr instanceof FtpUser) {
            FtpUser ftpUser = (FtpUser)usr;
            if (ftpUser.getPartnerLocalId() != null && ftpUser.getPartnerLocalId().length() > 0) {
                this.userDataProp.setProperty(thisPrefix + ATTR_PARTNER_LOCAL_ID, ftpUser.getPartnerLocalId());
            } else {
                this.userDataProp.remove((Object)(thisPrefix + ATTR_PARTNER_LOCAL_ID));
            }
        }
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        if ((transferRateRequest = (TransferRateRequest)usr.authorize((AuthorizationRequest)transferRateRequest)) != null) {
            this.userDataProp.setProperty(thisPrefix + "uploadrate", transferRateRequest.getMaxUploadRate());
            this.userDataProp.setProperty(thisPrefix + "downloadrate", transferRateRequest.getMaxDownloadRate());
        } else {
            this.userDataProp.remove((Object)(thisPrefix + "uploadrate"));
            this.userDataProp.remove((Object)(thisPrefix + "downloadrate"));
        }
        ConcurrentLoginRequest concurrentLoginRequest = new ConcurrentLoginRequest(0, 0);
        concurrentLoginRequest = (ConcurrentLoginRequest)usr.authorize((AuthorizationRequest)concurrentLoginRequest);
        if (concurrentLoginRequest != null) {
            this.userDataProp.setProperty(thisPrefix + "maxloginnumber", concurrentLoginRequest.getMaxConcurrentLogins());
            this.userDataProp.setProperty(thisPrefix + "maxloginperip", concurrentLoginRequest.getMaxConcurrentLoginsPerIP());
        } else {
            this.userDataProp.remove((Object)(thisPrefix + "maxloginnumber"));
            this.userDataProp.remove((Object)(thisPrefix + "maxloginperip"));
        }
        this.saveUserData();
    }

    private void saveUserData() throws FtpException {
        if (this.userDataFile == null) {
            return;
        }
        File dir = this.userDataFile.getAbsoluteFile().getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            String dirName = dir.getAbsolutePath();
            throw new FtpServerConfigurationException("Cannot create directory for user data file : " + dirName);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.userDataFile);
            this.userDataProp.store((OutputStream)fos, "Generated file - don't edit (please)");
        }
        catch (IOException ex) {
            try {
                this.LOG.error("Failed saving user data", (Throwable)ex);
                throw new FtpException("Failed saving user data", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(fos);
                throw throwable;
            }
        }
        IoUtils.close((OutputStream)fos);
    }

    public void delete(String usrName) throws FtpException {
        String thisPrefix = PREFIX + usrName + ".";
        Enumeration propNames = this.userDataProp.propertyNames();
        ArrayList<String> remKeys = new ArrayList<String>();
        while (propNames.hasMoreElements()) {
            String thisKey = propNames.nextElement().toString();
            if (!thisKey.startsWith(thisPrefix)) continue;
            remKeys.add(thisKey);
        }
        Iterator remKeysIt = remKeys.iterator();
        while (remKeysIt.hasNext()) {
            this.userDataProp.remove(remKeysIt.next());
        }
        this.saveUserData();
    }

    private String getPassword(User usr) {
        String name = usr.getName();
        String password = usr.getPassword();
        String encryptedPassword = null;
        if (usr instanceof FtpUser) {
            FtpUser ftpUser = (FtpUser)usr;
            encryptedPassword = ftpUser.getEncryptedPassword();
        }
        if (encryptedPassword != null) {
            password = encryptedPassword;
        } else if (password != null) {
            password = this.getPasswordEncryptor().encrypt(password);
        } else {
            String blankPassword = this.getPasswordEncryptor().encrypt("");
            if (this.doesExist(name)) {
                String key = PREFIX + name + ".userpassword";
                password = this.userDataProp.getProperty(key, blankPassword);
            } else {
                password = blankPassword;
            }
        }
        return password;
    }

    public String[] getAllUserNames() {
        String suffix = ".homedirectory";
        ArrayList<String> ulst = new ArrayList<String>();
        Enumeration allKeys = this.userDataProp.propertyNames();
        int prefixlen = PREFIX.length();
        int suffixlen = suffix.length();
        while (allKeys.hasMoreElements()) {
            String key = (String)allKeys.nextElement();
            if (!key.endsWith(suffix)) continue;
            String name = key.substring(prefixlen);
            int endIndex = name.length() - suffixlen;
            name = name.substring(0, endIndex);
            ulst.add(name);
        }
        Collections.sort(ulst);
        return ulst.toArray(new String[0]);
    }

    public synchronized FtpUser getUserByName(String userName) {
        if (!this.doesExist(userName)) {
            return null;
        }
        String baseKey = PREFIX + userName + ".";
        FtpUser user = new FtpUser();
        user.setName(userName);
        user.setEnabled(this.userDataProp.getBoolean(baseKey + "enableflag", true));
        user.setHomeDirectory(this.userDataProp.getProperty(baseKey + "homedirectory", "/"));
        ArrayList<Object> authorities = new ArrayList<Object>();
        if (this.userDataProp.getBoolean(baseKey + "writepermission", false)) {
            authorities.add(new WritePermission());
        }
        int maxLogin = this.userDataProp.getInteger(baseKey + "maxloginnumber", 0);
        int maxLoginPerIP = this.userDataProp.getInteger(baseKey + "maxloginperip", 0);
        authorities.add(new ConcurrentLoginPermission(maxLogin, maxLoginPerIP));
        int uploadRate = this.userDataProp.getInteger(baseKey + "uploadrate", 0);
        int downloadRate = this.userDataProp.getInteger(baseKey + "downloadrate", 0);
        authorities.add(new TransferRatePermission(downloadRate, uploadRate));
        user.setAuthorities(authorities);
        user.setMaxIdleTime(this.userDataProp.getInteger(baseKey + "idletime", 0));
        user.setPartnerLocalId(this.userDataProp.getString(baseKey + ATTR_PARTNER_LOCAL_ID, null));
        user.setEncryptedPassword(this.userDataProp.getString(baseKey + "userpassword", null));
        return user;
    }

    public synchronized boolean doesExist(String name) {
        String key = PREFIX + name + ".homedirectory";
        return this.userDataProp.containsKey((Object)key);
    }

    public synchronized User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            String storedPassword;
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String user = upauth.getUsername();
            String password = upauth.getPassword();
            if (user == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            if ((storedPassword = this.userDataProp.getProperty(PREFIX + user + ".userpassword")) == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (this.getPasswordEncryptor().matches(password, storedPassword)) {
                FtpUser ftpUser = this.getUserByName(user);
                ftpUser.setPassword(password);
                return ftpUser;
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        if (authentication instanceof AnonymousAuthentication) {
            if (this.doesExist("anonymous")) {
                return this.getUserByName("anonymous");
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        throw new IllegalArgumentException("Authentication not supported by this user manager");
    }

    public synchronized List<FtpExchangeUser> getFtpExchangeUsers() {
        String[] userNames = this.getAllUserNames();
        ArrayList<FtpExchangeUser> exchangeUsers = new ArrayList<FtpExchangeUser>(userNames.length);
        for (String userName : userNames) {
            FtpUser user = this.getUserByName(userName);
            FtpExchangeUser exchangeUser = new FtpExchangeUser();
            exchangeUser.setUserName(user.getName());
            exchangeUser.setEncryptedPassword(user.getEncryptedPassword());
            exchangeUser.setPassword(user.getEncryptedPassword() == null ? user.getPassword() : null);
            exchangeUser.setPartnerLocalId(user.getPartnerLocalId());
            exchangeUsers.add(exchangeUser);
        }
        return exchangeUsers;
    }

    public synchronized void overwriteUsers(List<FtpExchangeUser> exchangeUsers) throws FtpException {
        String[] userNames = this.getAllUserNames();
        HashMap<String, FtpUser> oldFtpUsers = new HashMap<String, FtpUser>();
        for (String userName : userNames) {
            oldFtpUsers.put(userName, this.getUserByName(userName));
            this.delete(userName);
        }
        List<FtpUser> newFtpUsers = this.getFtpUsers(exchangeUsers);
        for (FtpUser ftpUser : newFtpUsers) {
            FtpUser oldFtpUser = (FtpUser)((Object)oldFtpUsers.get(ftpUser.getName()));
            Optional<FtpExchangeUser> exchangeUserOptional = exchangeUsers.stream().filter(user -> user.getUserName().equals(ftpUser.getName())).findFirst();
            if (oldFtpUser != null && exchangeUserOptional.isPresent() && UNCHANGED_PASSWORD.equals(exchangeUserOptional.get().getPassword())) {
                ftpUser.setEncryptedPassword(oldFtpUser.getEncryptedPassword());
            }
            this.save((User)ftpUser);
        }
    }

    private List<FtpUser> getFtpUsers(List<FtpExchangeUser> exchangeUsers) {
        ArrayList<FtpUser> ftpUsers = new ArrayList<FtpUser>(exchangeUsers.size());
        for (FtpExchangeUser user : exchangeUsers) {
            FtpUser ftpUser = new FtpUser();
            ftpUser.setName(user.getUserName());
            ftpUser.setEnabled(true);
            ftpUser.setHomeDirectory("./res/home");
            ArrayList<Object> authorities = new ArrayList<Object>();
            authorities.add(new WritePermission());
            int maxLogin = 0;
            int maxLoginPerIP = 0;
            authorities.add(new ConcurrentLoginPermission(maxLogin, maxLoginPerIP));
            int uploadRate = 0;
            int downloadRate = 0;
            authorities.add(new TransferRatePermission(downloadRate, uploadRate));
            ftpUser.setAuthorities(authorities);
            ftpUser.setMaxIdleTime(0);
            ftpUser.setPartnerLocalId(user.getPartnerLocalId());
            ftpUser.setPassword(user.getPassword());
            ftpUser.setEncryptedPassword(user.getEncryptedPassword());
            ftpUsers.add(ftpUser);
        }
        return ftpUsers;
    }

    public synchronized void dispose() {
        if (this.userDataProp != null) {
            this.userDataProp.clear();
            this.userDataProp = null;
        }
    }
}

