/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.ponton.securelistener.StatusSingleton;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.FtpListener;
import de.ponton.securelistener.listener.HTTPServer;
import de.ponton.securelistener.proxy.ProxyServer;
import de.ponton.securelistener.security.PontonKeystore;
import de.ponton.securelistener.websocket.WebsocketModule;
import de.ponton.securelistener.websocket.WebsocketServer;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jul.Log4jBridgeHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class SecureListener {
    public static final String CERT_ALIAS = "jetty";
    public static final String CONFIG_LISTENER_PROPERTIES;
    public static final String FTP_USERS_PROPERTIES;
    private static final String LISTENER_VERSION;
    private static final Pattern NON_DIGIT_PATTERN;
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final File CONFIG_FOLDER;
    private static SecureListener _instance;
    private PontonKeystore _serverKeystore;
    private PontonKeystore _tempServerKeystore;
    private PontonKeystore _trustKeystore;
    private ListenerProperties _config;
    private static final Logger LOG;
    private HTTPServer httpServer;
    private ProxyServer _proxy;
    private FtpListener _ftpListener;
    private Injector injector;
    private WebsocketServer websocketServer;

    public static SecureListener getInstance() {
        return _instance;
    }

    public SecureListener() {
        try {
            Object message = "********* Ponton X/P Listener V" + SecureListener.getVERSION() + " starting *********";
            System.out.println((String)message);
            LOG.info((String)message);
            this.injector = Guice.createInjector((Module[])new Module[]{new WebsocketModule()});
            this.readConfig();
            message = "Loading keystores.";
            LOG.info((String)message);
            this.loadKeystores();
            _instance = this;
            this.startupWebsocket();
            this.startServices();
            message = "startup completed.";
            LOG.info((String)message);
            System.out.println((String)message);
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        }
        catch (Throwable e) {
            LOG.error("Problem during startup ", e);
            System.out.println("Problem during startup, check log file.");
            this.shutdown();
        }
    }

    public synchronized void readConfig() throws IOException {
        File configFile = new File(CONFIG_LISTENER_PROPERTIES);
        LOG.info("Reading configuration file: {}", (Object)configFile.getAbsolutePath());
        this._config = (ListenerProperties)this.injector.getInstance(ListenerProperties.class);
        this._config.readConfig(configFile, configFile);
    }

    public ListenerProperties getConfig() {
        return this._config;
    }

    public synchronized void startServices() throws Exception {
        LOG.info("Starting services ... ");
        StatusSingleton.getInstance().setStartTime(System.currentTimeMillis());
        StringBuilder buffer = new StringBuilder();
        String secureListenerError = this.startupSecureListener();
        String ftpListenerError = this.startupFtpListener();
        String proxyError = this.startupProxy();
        if (!secureListenerError.isEmpty()) {
            buffer.append(secureListenerError);
        }
        if (!ftpListenerError.isEmpty()) {
            buffer.append(ftpListenerError);
        }
        if (!proxyError.isEmpty()) {
            buffer.append(proxyError);
        }
        if (buffer.length() != 0) {
            LOG.error("Not all Services started as expected.");
            throw new Exception(buffer.toString());
        }
        LOG.info("All services started.");
    }

    private void startupWebsocket() throws Exception {
        this.websocketServer = (WebsocketServer)this.injector.getInstance(WebsocketServer.class);
        this.websocketServer.startup();
    }

    private void shutdownWebsocket() {
        if (this.websocketServer != null) {
            this.websocketServer.shutdown();
        }
    }

    private String startupFtpListener() {
        StringBuilder errors = new StringBuilder();
        try {
            if (this._config.isFtpListenerEnabled() && this._ftpListener == null) {
                this._ftpListener = (FtpListener)this.injector.getInstance(FtpListener.class);
            }
        }
        catch (Exception e) {
            if (this._ftpListener != null) {
                this._ftpListener.stopFtpServer();
                this._ftpListener = null;
            }
            LOG.error("could not configure FTP Listener.", (Throwable)e);
            errors.append('\n');
            errors.append("Error while starting up FTP Listener: ");
            errors.append(e.getMessage());
        }
        return errors.toString();
    }

    public synchronized void restartServices() throws IOException {
        this.shutdownServices();
        this.readConfig();
        String lastResult = null;
        for (int i = 1; i <= this._config.getStartupRetries(); ++i) {
            try {
                Thread.interrupted();
                this.startServices();
                lastResult = null;
                break;
            }
            catch (Throwable e) {
                LOG.warn(e.getMessage());
                lastResult = e.getMessage();
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lastResult != null) {
            throw new IOException(lastResult);
        }
    }

    public synchronized void shutdown() {
        this.shutdownServices();
        this.shutdownWebsocket();
    }

    public synchronized void shutdownServices() {
        LOG.info("shutting down services...");
        if (this.httpServer != null && !this.httpServer.getServers().isEmpty()) {
            this.httpServer.shutdown();
        }
        LOG.debug("SecureListener http/https service stopped.");
        if (this._proxy != null) {
            try {
                this._proxy.stopProxyPort();
                LOG.debug("Proxy services stopped.");
                this._proxy = null;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.fatal("Unable to stop the proxy service.");
            }
        }
        if (this._ftpListener != null) {
            try {
                this._ftpListener.stopFtpServer();
                LOG.debug("SecureListener ftp(s) service stopped.");
                this._ftpListener = null;
            }
            catch (Exception e) {
                LOG.fatal("Unable to stop the SecureListener ftp(s) service.");
            }
        }
        StatusSingleton.getInstance().reset();
        LOG.info("Services were shut down.");
    }

    public synchronized String startupProxy() {
        StringBuilder errors = new StringBuilder();
        try {
            if (this._config.isProxyEnabled() && this._proxy == null) {
                this._proxy = new ProxyServer();
                this._proxy.startProxyPort();
            }
        }
        catch (Exception e) {
            if (this._proxy != null) {
                try {
                    this._proxy.stopProxyPort();
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                this._proxy = null;
            }
            errors.append('\n');
            errors.append("Error while starting up ProxyServer: ").append(e.getMessage());
        }
        return errors.toString();
    }

    public synchronized String startupSecureListener() {
        StringBuilder errors = new StringBuilder();
        this.httpServer = (HTTPServer)this.injector.getInstance(HTTPServer.class);
        try {
            if (!this.httpServer.getServers().isEmpty()) {
                try {
                    this.httpServer.shutdown();
                }
                catch (Exception e) {
                    errors.append('\n');
                    errors.append("Error while stopping SecureListener HTTP/HTTPS: ");
                    errors.append(e);
                }
            }
            if (this._config.isSecureListenerHttpEnabled() && !this.httpServer.isHttpSocketActive()) {
                try {
                    this.httpServer.startHttpPort();
                }
                catch (Exception b) {
                    errors.append('\n');
                    errors.append("Error while starting up SecureListener HTTP Port: ");
                    errors.append(this.httpServer.getHttpAddressPort());
                    errors.append(" ");
                    errors.append(b);
                }
            }
            if (this._config.isSecureListenerHttpsEnabled() && !this.httpServer.isHttpsSocketActive()) {
                try {
                    this.httpServer.startHttpsPort();
                }
                catch (Exception b) {
                    errors.append('\n');
                    errors.append("Error while starting up SecureListener HTTPS Port: ");
                    errors.append(this.httpServer.getHttpsAddressPort());
                    errors.append("  ");
                    errors.append(b);
                }
            }
        }
        catch (Exception e) {
            errors.append("Error while starting up SecureListener: ").append(e.getMessage());
            errors.append('\n');
        }
        return errors.toString();
    }

    public synchronized void loadKeystores() throws GeneralSecurityException {
        this._serverKeystore = new PontonKeystore(new File(SecureListener.getRealPath(this._config.getServerKeystoreLocation())), DEFAULT_KEYSTORE_PASSWORD);
        this._tempServerKeystore = new PontonKeystore(new File(SecureListener.getRealPath(this._config.getServerKeystoreLocation()) + "Temp"), DEFAULT_KEYSTORE_PASSWORD);
        this._trustKeystore = new PontonKeystore(new File(SecureListener.getRealPath(this._config.getTrustKeystoreLocation())), DEFAULT_KEYSTORE_PASSWORD);
    }

    public static String getRealPath(String path) {
        if (path != null && path.startsWith("config/")) {
            return CONFIG_FOLDER.getPath() + path.substring("config".length());
        }
        return path;
    }

    public PontonKeystore getServerKeystore() {
        return this._serverKeystore;
    }

    public PontonKeystore getTempServerKeystore() {
        return this._tempServerKeystore;
    }

    public PontonKeystore getTrustKeystore() {
        return this._trustKeystore;
    }

    public static String getVERSION() {
        return LISTENER_VERSION;
    }

    public static void main(String[] args) {
        new SecureListener();
    }

    static {
        String buildDate;
        Object build;
        NON_DIGIT_PATTERN = Pattern.compile("\\D*");
        LOG = LogManager.getLogger((String)"Listener.Listener");
        Log4jBridgeHandler.install((boolean)true, (String)"", (boolean)true);
        BouncyCastleProvider bc = new BouncyCastleProvider();
        bc.put((Object)"Alg.Alias.Cipher.PBEWithSHAAnd3KeyTripleDES", (Object)"PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bc.put((Object)"Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", (Object)"PBE/PKCS12");
        bc.put((Object)"Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", (Object)"PKCS12PBE");
        System.setProperty("jdk.tls.namedGroups", System.getProperty("jdk.tls.namedGroups", "brainpoolP256r1, brainpoolP256r1tls13, brainpoolP384r1tls13, brainpoolP512r1tls13, brainpoolP384r1, brainpoolP512r1, secp256r1, secp384r1"));
        Security.removeProvider("SunEC");
        Security.addProvider((Provider)bc);
        Security.addProvider((Provider)new BouncyCastleJsseProvider((Provider)bc));
        try {
            ResourceBundle resource = ResourceBundle.getBundle("ponton-securelistener-version");
            String versionString = resource.getString("ponton.version").trim();
            String buildString = resource.getString("ponton.buildnumber").trim();
            Matcher m = NON_DIGIT_PATTERN.matcher(buildString);
            buildString = m.replaceAll("");
            build = versionString + " (Build " + buildString + ")";
            buildDate = resource.getString("ponton.builddate").trim();
        }
        catch (Exception e) {
            build = "3.2.0 (unversioned Build)";
            buildDate = "undefined";
        }
        LISTENER_VERSION = (String)build + " " + buildDate;
        String configFolderString = System.getProperty("CONFIG_FOLDER", "config");
        CONFIG_FOLDER = new File(configFolderString);
        CONFIG_LISTENER_PROPERTIES = CONFIG_FOLDER.getPath() + "/Listener.properties";
        FTP_USERS_PROPERTIES = CONFIG_FOLDER.getPath() + "/ftpuser.properties";
    }
}

