/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.security.AlgorithmConstraints;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ReflectionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLParametersUtil {
    private static final Method getNamedGroups;
    private static final Method setNamedGroups;
    private static final Method getSignatureSchemes;
    private static final Method setSignatureSchemes;

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters prov) {
        BCSSLParameters ssl = new BCSSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setWantClientAuth(prov.getWantClientAuth());
        }
        ssl.setEndpointIdentificationAlgorithm(prov.getEndpointIdentificationAlgorithm());
        ssl.setAlgorithmConstraints(prov.getAlgorithmConstraints());
        ssl.setServerNames(prov.getServerNames());
        ssl.setSNIMatchers(prov.getSNIMatchers());
        ssl.setUseCipherSuitesOrder(prov.getUseCipherSuitesOrder());
        ssl.setApplicationProtocols(prov.getApplicationProtocols());
        ssl.setEnableRetransmissions(prov.getEnableRetransmissions());
        ssl.setMaximumPacketSize(prov.getMaximumPacketSize());
        ssl.setSignatureSchemes(prov.getSignatureSchemes());
        ssl.setSignatureSchemesCert(prov.getSignatureSchemesCert());
        ssl.setNamedGroups(prov.getNamedGroups());
        return ssl;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters prov) {
        Collection<BCSNIMatcher> matchers;
        SSLParameters ssl = new SSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setWantClientAuth(prov.getWantClientAuth());
        }
        ssl.setEndpointIdentificationAlgorithm(prov.getEndpointIdentificationAlgorithm());
        ssl.setAlgorithmConstraints(JsseUtils_7.exportAlgorithmConstraints(prov.getAlgorithmConstraints()));
        List<BCSNIServerName> serverNames = prov.getServerNames();
        if (null != serverNames) {
            ssl.setServerNames(JsseUtils_8.exportSNIServerNames(serverNames));
        }
        if (null != (matchers = prov.getSNIMatchers())) {
            ssl.setSNIMatchers(JsseUtils_8.exportSNIMatchers(matchers));
        }
        ssl.setUseCipherSuitesOrder(prov.getUseCipherSuitesOrder());
        String[] applicationProtocols = prov.getApplicationProtocols();
        if (null != applicationProtocols) {
            ssl.setApplicationProtocols(applicationProtocols);
        }
        ssl.setEnableRetransmissions(prov.getEnableRetransmissions());
        ssl.setMaximumPacketSize(prov.getMaximumPacketSize());
        if (null != setSignatureSchemes) {
            SSLParametersUtil.set(ssl, setSignatureSchemes, prov.getSignatureSchemes());
        }
        if (null != setNamedGroups) {
            SSLParametersUtil.set(ssl, setNamedGroups, prov.getNamedGroups());
        }
        return ssl;
    }

    static BCSSLParameters importSSLParameters(SSLParameters ssl) {
        Collection<SNIMatcher> matchers;
        List<SNIServerName> serverNames;
        AlgorithmConstraints constraints;
        BCSSLParameters bc = new BCSSLParameters(ssl.getCipherSuites(), ssl.getProtocols());
        if (ssl.getNeedClientAuth()) {
            bc.setNeedClientAuth(true);
        } else {
            bc.setWantClientAuth(ssl.getWantClientAuth());
        }
        String endpointIdentificationAlgorithm = ssl.getEndpointIdentificationAlgorithm();
        if (null != endpointIdentificationAlgorithm) {
            bc.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != (constraints = ssl.getAlgorithmConstraints())) {
            bc.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints(constraints));
        }
        if (null != (serverNames = ssl.getServerNames())) {
            bc.setServerNames(JsseUtils_8.importSNIServerNames(serverNames));
        }
        if (null != (matchers = ssl.getSNIMatchers())) {
            bc.setSNIMatchers(JsseUtils_8.importSNIMatchers(matchers));
        }
        bc.setUseCipherSuitesOrder(ssl.getUseCipherSuitesOrder());
        String[] applicationProtocols = ssl.getApplicationProtocols();
        if (null != applicationProtocols) {
            bc.setApplicationProtocols(applicationProtocols);
        }
        bc.setEnableRetransmissions(ssl.getEnableRetransmissions());
        bc.setMaximumPacketSize(ssl.getMaximumPacketSize());
        if (null != getSignatureSchemes) {
            bc.setSignatureSchemes((String[])SSLParametersUtil.get(ssl, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            bc.setNamedGroups((String[])SSLParametersUtil.get(ssl, getNamedGroups));
        }
        return bc;
    }

    static void setParameters(ProvSSLParameters prov, BCSSLParameters ssl) {
        Collection<BCSNIMatcher> sniMatchers;
        List<BCSNIServerName> serverNames;
        BCAlgorithmConstraints algorithmConstraints;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (null != cipherSuites) {
            prov.setCipherSuites(cipherSuites);
        }
        if (null != (protocols = ssl.getProtocols())) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else {
            prov.setWantClientAuth(ssl.getWantClientAuth());
        }
        String endpointIdentificationAlgorithm = ssl.getEndpointIdentificationAlgorithm();
        if (null != endpointIdentificationAlgorithm) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != (algorithmConstraints = ssl.getAlgorithmConstraints())) {
            prov.setAlgorithmConstraints(algorithmConstraints);
        }
        if (null != (serverNames = ssl.getServerNames())) {
            prov.setServerNames(serverNames);
        }
        if (null != (sniMatchers = ssl.getSNIMatchers())) {
            prov.setSNIMatchers(sniMatchers);
        }
        prov.setUseCipherSuitesOrder(ssl.getUseCipherSuitesOrder());
        String[] applicationProtocols = ssl.getApplicationProtocols();
        if (null != applicationProtocols) {
            prov.setApplicationProtocols(applicationProtocols);
        }
        prov.setEnableRetransmissions(ssl.getEnableRetransmissions());
        prov.setMaximumPacketSize(ssl.getMaximumPacketSize());
        prov.setSignatureSchemes(ssl.getSignatureSchemes());
        prov.setNamedGroups(ssl.getNamedGroups());
        prov.setSignatureSchemesCert(ssl.getSignatureSchemesCert());
    }

    static void setSSLParameters(ProvSSLParameters prov, SSLParameters ssl) {
        Collection<SNIMatcher> matchers;
        List<SNIServerName> serverNames;
        AlgorithmConstraints constraints;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (null != cipherSuites) {
            prov.setCipherSuites(cipherSuites);
        }
        if (null != (protocols = ssl.getProtocols())) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else {
            prov.setWantClientAuth(ssl.getWantClientAuth());
        }
        String endpointIdentificationAlgorithm = ssl.getEndpointIdentificationAlgorithm();
        if (null != endpointIdentificationAlgorithm) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != (constraints = ssl.getAlgorithmConstraints())) {
            prov.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints(constraints));
        }
        if (null != (serverNames = ssl.getServerNames())) {
            prov.setServerNames(JsseUtils_8.importSNIServerNames(serverNames));
        }
        if (null != (matchers = ssl.getSNIMatchers())) {
            prov.setSNIMatchers(JsseUtils_8.importSNIMatchers(matchers));
        }
        prov.setUseCipherSuitesOrder(ssl.getUseCipherSuitesOrder());
        String[] applicationProtocols = ssl.getApplicationProtocols();
        if (null != applicationProtocols) {
            prov.setApplicationProtocols(applicationProtocols);
        }
        prov.setEnableRetransmissions(ssl.getEnableRetransmissions());
        prov.setMaximumPacketSize(ssl.getMaximumPacketSize());
        if (null != getSignatureSchemes) {
            prov.setSignatureSchemes((String[])SSLParametersUtil.get(ssl, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            prov.setNamedGroups((String[])SSLParametersUtil.get(ssl, getNamedGroups));
        }
    }

    private static Object get(Object obj, Method method) {
        return ReflectionUtil.invokeGetter(obj, method);
    }

    private static void set(Object obj, Method method, Object arg) {
        ReflectionUtil.invokeSetter(obj, method, arg);
    }

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getNamedGroups = ReflectionUtil.findMethod(methods, "getNamedGroups");
        setNamedGroups = ReflectionUtil.findMethod(methods, "setNamedGroups");
        getSignatureSchemes = ReflectionUtil.findMethod(methods, "getSignatureSchemes");
        setSignatureSchemes = ReflectionUtil.findMethod(methods, "setSignatureSchemes");
    }
}

