/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecL {
    Poly[] vec;
    private MLDSAEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumL;
    private int dilithiumK;

    public PolyVecL(MLDSAEngine engine) {
        this.engine = engine;
        this.mode = engine.getDilithiumMode();
        this.dilithiumL = engine.getDilithiumL();
        this.dilithiumK = engine.getDilithiumK();
        this.vec = new Poly[this.dilithiumL];
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.vec[i] = new Poly(engine);
        }
    }

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    public void expandMatrix(byte[] rho, int i) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.vec[j].uniformBlocks(rho, (short)((i << 8) + j));
        }
    }

    public void uniformEta(byte[] seed, short nonce) {
        short n = nonce;
        for (int i = 0; i < this.dilithiumL; ++i) {
            short s = n;
            n = (short)(n + 1);
            this.getVectorIndex(i).uniformEta(seed, s);
        }
    }

    public void copyPolyVecL(PolyVecL outPoly) {
        for (int i = 0; i < this.dilithiumL; ++i) {
            for (int j = 0; j < 256; ++j) {
                outPoly.getVectorIndex(i).setCoeffIndex(j, this.getVectorIndex(i).getCoeffIndex(j));
            }
        }
    }

    public void polyVecNtt() {
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.vec[i].polyNtt();
        }
    }

    public void uniformGamma1(byte[] seed, short nonce) {
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.getVectorIndex(i).uniformGamma1(seed, (short)(this.dilithiumL * nonce + i));
        }
    }

    public void pointwisePolyMontgomery(Poly a, PolyVecL v) {
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.getVectorIndex(i).pointwiseMontgomery(a, v.getVectorIndex(i));
        }
    }

    public void invNttToMont() {
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.getVectorIndex(i).invNttToMont();
        }
    }

    public void addPolyVecL(PolyVecL v) {
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.getVectorIndex(i).addPoly(v.getVectorIndex(i));
        }
    }

    public void reduce() {
        for (int i = 0; i < this.dilithiumL; ++i) {
            this.getVectorIndex(i).reduce();
        }
    }

    public boolean checkNorm(int bound) {
        for (int i = 0; i < this.dilithiumL; ++i) {
            if (!this.getVectorIndex(i).checkNorm(bound)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Object out = "\n[";
        for (int i = 0; i < this.dilithiumL; ++i) {
            out = (String)out + "Inner Matrix " + i + " " + this.getVectorIndex(i).toString();
            if (i == this.dilithiumL - 1) continue;
            out = (String)out + ",\n";
        }
        out = (String)out + "]";
        return out;
    }

    public String toString(String name) {
        return name + ": " + this.toString();
    }
}

