/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.websocket.ConnectionLimitException;
import jakarta.websocket.Session;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionPool {
    private static final Logger LOG = LogManager.getLogger((String)"Listener.SessionPool");
    public static int CONNECTION_LIMIT = 500;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ArrayBlockingQueue<Session> free = new ArrayBlockingQueue(CONNECTION_LIMIT, true);
    private final ArrayList<Session> allSessions = new ArrayList(6);
    private final String poolName;

    public SessionPool(String name) {
        this.poolName = name;
    }

    public boolean hasSessions() {
        this.lock.lock();
        try {
            boolean bl = !this.allSessions.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeSession(Session session) {
        this.lock.lock();
        try {
            this.free.remove(session);
            this.allSessions.remove(session);
        }
        finally {
            LOG.debug("Removed session {} on {}, total count {}.", (Object)session.getId(), (Object)this.poolName, (Object)this.allSessions.size());
            this.lock.unlock();
        }
    }

    public void addSession(Session session) throws ConnectionLimitException {
        this.lock.lock();
        try {
            if (this.allSessions.size() >= CONNECTION_LIMIT) {
                throw new ConnectionLimitException();
            }
            this.free.add(session);
            this.allSessions.add(session);
        }
        finally {
            LOG.debug("Added session {} on {}, total count {}.", (Object)session.getId(), (Object)this.poolName, (Object)this.allSessions.size());
            this.lock.unlock();
        }
    }

    public Session borrowSession(long timeout, TimeUnit unit) throws TimeoutException {
        Session use = null;
        try {
            do {
                LOG.debug("Borrowing session on {} (max wait: {} {})", (Object)this.poolName, (Object)timeout, (Object)unit);
                use = this.free.poll(timeout, unit);
                if (use == null) {
                    LOG.warn("no session available for " + timeout + String.valueOf((Object)unit));
                    throw new TimeoutException("no session available for " + timeout + String.valueOf((Object)unit));
                }
                if (use.isOpen()) continue;
                LOG.debug("removing closed session from pool {}", (Object)use);
                this.removeSession(use);
            } while (!use.isOpen());
            LOG.debug("Borrowed session {} on {}, remaining {}.", (Object)use.getId(), (Object)this.poolName, (Object)this.free.size());
        }
        catch (InterruptedException e) {
            LOG.debug("waiting was interrupted.");
            Thread.currentThread().interrupt();
            throw new TimeoutException("waiting was interrupted.");
        }
        return use;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSession(Session session) {
        LOG.debug("Session {} returned on {}, remaining {}.", (Object)session.getId(), (Object)this.poolName, (Object)(this.free.size() + 1));
        Map map = session.getUserProperties();
        synchronized (map) {
            session.getUserProperties().clear();
        }
        this.free.add(session);
    }
}

