/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.websocket.Response;
import jakarta.inject.Singleton;
import jakarta.websocket.Session;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ResponseSynchronizer {
    private static final String RESPONSE = "response";
    private static final String RESPONSE_COMPLETE_CONDITION = "responseCompleteCondition";
    private static final Logger LOG = LogManager.getLogger((String)"Listener.ResponseSynchronizer");
    private final ReentrantLock lock = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSession(Session session, Response r) {
        Map map = session.getUserProperties();
        synchronized (map) {
            session.getUserProperties().put(RESPONSE_COMPLETE_CONDITION, this.lock.newCondition());
            session.getUserProperties().put(RESPONSE, r);
        }
    }

    public void notify(Session session) {
        this.lock.lock();
        try {
            Condition responseCompleteCondition = this.getResponseAndRemoveCompleteCondition(session);
            if (responseCompleteCondition != null) {
                LOG.debug("notify about complete response on session {}", (Object)session.getId());
                responseCompleteCondition.signalAll();
            } else {
                LOG.warn("no response condition for notification on session {}", (Object)session.getId());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Condition getResponseAndRemoveCompleteCondition(Session session) {
        Map map = session.getUserProperties();
        synchronized (map) {
            return (Condition)session.getUserProperties().remove(RESPONSE_COMPLETE_CONDITION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Condition getResponseCompleteCondition(Session session) {
        Map map = session.getUserProperties();
        synchronized (map) {
            return (Condition)session.getUserProperties().get(RESPONSE_COMPLETE_CONDITION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResponse(Session session) {
        this.lock.lock();
        try {
            Condition responseCompleteCondition = this.getResponseCompleteCondition(session);
            if (responseCompleteCondition == null) {
                LOG.debug("Response already received on session {}.", (Object)session.getId());
            } else {
                LOG.debug("Waiting for response on session {}.", (Object)session.getId());
                boolean receivedResponse = responseCompleteCondition.await(1L, TimeUnit.HOURS);
                if (receivedResponse) {
                    LOG.debug("Received response on session {}.", (Object)session.getId());
                } else {
                    LOG.error("did not receive response within 1 hour on session {}.", (Object)session.getId());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponseForSession(Session session) {
        Map map = session.getUserProperties();
        synchronized (map) {
            return (Response)session.getUserProperties().get(RESPONSE);
        }
    }
}

