/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.security.RandomGenerator;
import de.ponton.securelistener.websocket.AbstractEndpoint;
import de.ponton.securelistener.websocket.ClientWebsocketAuthorization;
import de.ponton.securelistener.websocket.Response;
import de.ponton.securelistener.websocket.ResponseSynchronizer;
import de.ponton.securelistener.websocket.SessionPoolManager;
import jakarta.inject.Inject;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEndpoint
extends AbstractEndpoint {
    public static final String NAME = "Data";
    private static final Logger LOG = LoggerFactory.getLogger((String)"Listener.DataEndpoint");
    private final ResponseSynchronizer synchronizer;

    @Inject
    public DataEndpoint(SessionPoolManager sessionPoolManager, RandomGenerator generator, ClientWebsocketAuthorization authorization, ResponseSynchronizer synchronizer) {
        super(sessionPoolManager.getSessionPool(NAME), generator, authorization);
        this.synchronizer = synchronizer;
    }

    public void onMessage(String message) {
        LOG.debug("receiving Response Headers");
        BufferedReader reader = new BufferedReader(new StringReader(message));
        Response response = this.getResponse(this.session);
        if (response == null) {
            LOG.error("received response from Messenger but sender already disconnected. {}", (Object)this.session.getId());
            return;
        }
        String line = null;
        try {
            String statusCode = reader.readLine();
            String statusMessage = reader.readLine();
            int code = Integer.parseInt(statusCode);
            while ((line = reader.readLine()) != null) {
                String[] text = line.split(": ");
                if (text[0].startsWith("X-Result-")) continue;
                response.addHeader(text[0], text[1]);
            }
            LOG.debug("result:{} {}", (Object)statusCode, (Object)statusMessage);
            response.setMessage(code, statusMessage);
        }
        catch (IOException e) {
            LOG.error("error while receiving response headers: {}", (Object)e.toString());
            response.setMessage(500, "error while forwarding data");
            this.sendNotification(this.session);
        }
    }

    public void onMessage(byte[] partialMessage, boolean last) {
        if (!this.authenticated) {
            this.handleChallengeResponse(partialMessage);
        } else {
            this.handleDataPacket(partialMessage, last);
        }
    }

    private void handleDataPacket(byte[] partialMessage, boolean last) {
        LOG.debug("receiving Response Data: {} bytes, last={}", (Object)partialMessage.length, (Object)last);
        Response response = this.getResponse(this.session);
        if (response == null) {
            LOG.error("received response from Messenger but sender already disconnected.");
            return;
        }
        if (last) {
            try {
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                LOG.error("error while forwarding response data: {}", (Object)e.toString());
            }
            this.sendNotification(this.session);
        } else {
            try {
                response.getOutputStream().write(partialMessage);
            }
            catch (IOException e) {
                LOG.error("error while forwarding response data: {}", (Object)e.toString());
                response.setMessage(500, "error while forwarding data");
                this.sendNotification(this.session);
            }
        }
    }

    private void sendNotification(Session session) {
        this.synchronizer.notify(session);
    }

    @Override
    public void onClose(Session session, CloseReason close) {
        Response response = this.getResponse(session);
        if (response != null) {
            LOG.error("network connection to Messenger disconnected. {}", (Object)session);
            response.setMessage(500, "error while forwarding data");
        }
        super.onClose(session, close);
        this.synchronizer.notify(session);
    }

    private Response getResponse(Session session) {
        return this.synchronizer.getResponseForSession(session);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

