/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.listener.servlet;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.StatusSingleton;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.listener.servlet.TooMuchDataException;
import de.ponton.securelistener.websocket.httpforwarding.HttpToWebsocketAdapter;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Listener
extends HttpServlet {
    private static final String HTTP = "HTTP";
    private static final String HTTPS = "HTTPS";
    private static final AtomicInteger _count = new AtomicInteger(1);
    private static final long serialVersionUID = -6311110347852494463L;
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    private static final Logger _transferLog = LogManager.getLogger((String)"transfer.http");
    private static final Logger _log = LogManager.getLogger((String)"Listener.SecureListener");
    private HttpToWebsocketAdapter _httpToWebsocket;

    @Inject
    public Listener(HttpToWebsocketAdapter httpToWebsocketAdapter) {
        this._httpToWebsocket = httpToWebsocketAdapter;
    }

    public String getServletName() {
        return "SecureListener-[" + Thread.currentThread().getId() + "]-" + super.getServletName();
    }

    public synchronized void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        _transferLog.debug("[{}] start GET {}", (Object)Thread.currentThread().getId(), (Object)request.getPathInfo());
        int count = _count.getAndIncrement();
        this.handleGetRequest(request, response, count);
        _transferLog.info("message [{}] from {} completed (GET) status:{}", (Object)count, (Object)request.getRemoteAddr(), (Object)response.getStatus());
        _transferLog.debug("[{}] end GET", (Object)Thread.currentThread().getId());
    }

    private void handleGetRequest(HttpServletRequest request, HttpServletResponse response, int count) throws IOException {
        try {
            this.checkAuthentication(request, count);
        }
        catch (Exception e) {
            response.sendError(403, e.getMessage());
            return;
        }
        if (!this.isUrlAllowed(request)) {
            _transferLog.error("message [" + count + "] from " + request.getRemoteAddr() + " FAILED. due to incorrect URL: " + request.getPathInfo());
            response.sendError(404, "resource not found.");
            return;
        }
        try {
            this._httpToWebsocket.forwardHttpRequest(request, response, 1000L);
        }
        catch (IOException e) {
            _transferLog.error("error while forwarding http request: {}", (Object)e.getMessage());
            response.sendError(503, "Service is unavailable");
        }
        catch (TimeoutException e) {
            _transferLog.error("timeout while waiting for a free Messenger connection to forward http request");
            response.sendError(503, "Server is busy");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int count = _count.getAndIncrement();
        long start = System.currentTimeMillis();
        _transferLog.debug("[{}] start POST {}", (Object)Thread.currentThread().getId(), (Object)request.getPathInfo());
        this.handlePostRequest(request, response, count);
        long duration = System.currentTimeMillis() - start;
        _transferLog.info("message [{}] from {} completed in {}ms (POST) status:{}", (Object)count, (Object)request.getRemoteAddr(), (Object)duration, (Object)response.getStatus());
        _transferLog.debug("[{}] end POST", (Object)Thread.currentThread().getId());
    }

    private void handlePostRequest(HttpServletRequest request, HttpServletResponse response, int count) throws IOException {
        long expectedLength;
        try {
            this.checkAuthentication(request, count);
        }
        catch (Exception e) {
            response.sendError(403, e.getMessage());
            return;
        }
        if (!this.isUrlAllowed(request)) {
            _transferLog.error("message [" + count + "] from " + request.getRemoteAddr() + " FAILED. due to incorrect URL: " + request.getPathInfo());
            response.sendError(404, "resource not found.");
            return;
        }
        long sizeLimit = SecureListener.getInstance().getConfig().getForwardMaxDatasize();
        String contentLength = request.getHeader("Content-Length");
        if (contentLength != null && (expectedLength = Long.parseLong(contentLength)) > sizeLimit) {
            _transferLog.error("message [" + count + "] from " + request.getRemoteAddr() + " FAILED. data size exceeded the allowed limit of " + sizeLimit);
            response.sendError(413, "transmitted data is too large.");
            return;
        }
        StatusSingleton.getInstance().setLastMessageIP(request.getRemoteAddr());
        StatusSingleton.getInstance().setLastMessageReceivedTime(System.currentTimeMillis());
        try {
            this._httpToWebsocket.forwardHttpRequest(request, response, sizeLimit);
        }
        catch (TooMuchDataException e) {
            _transferLog.error("message [{}] from {} FAILED. data size exceeded the allowed limit of {}", (Object)count, (Object)request.getRemoteAddr(), (Object)sizeLimit);
            response.sendError(413, "transmitted data is too large.");
        }
        catch (IOException e) {
            _transferLog.error("error while forwarding http request: {}", (Object)e.getMessage());
            response.sendError(503, "Service is unavailable");
        }
        catch (TimeoutException e) {
            _transferLog.error("timeout while waiting for a free Messenger connection to forward http request");
            response.sendError(503, "Server is busy");
        }
    }

    private String determineListener(HttpServletRequest request) {
        String listener = null;
        String fullUri = request.getRequestURI();
        ListenerProperties config = SecureListener.getInstance().getConfig();
        String[] allowedListenerTypes = config.getAllowedListenerTypes();
        for (int i = 0; i < allowedListenerTypes.length; ++i) {
            if (!fullUri.endsWith(allowedListenerTypes[i])) continue;
            listener = allowedListenerTypes[i];
            break;
        }
        return listener;
    }

    private boolean isUrlAllowed(HttpServletRequest request) {
        return this.determineListener(request) != null;
    }

    protected static String reverseString(String string) {
        Object result = "";
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            result = (String)result + c;
        }
        return result;
    }

    private void checkAuthentication(HttpServletRequest request, int count) throws ServletException {
        String protocol;
        String remoteIp = request.getRemoteAddr();
        String string = protocol = request.isSecure() ? HTTPS : HTTP;
        if (!request.isSecure() || !SecureListener.getInstance().getConfig().isSenderCertificateCheck()) {
            if (SecureListener.getInstance().getConfig().isSenderCertificateCheck()) {
                _log.warn("client certificate check is enabled, but is not possible with HTTP requests.");
            }
            _transferLog.info("incoming connection [" + count + "] from " + remoteIp + " (" + protocol + ")");
            return;
        }
        X509Certificate[] newCertChain = (X509Certificate[])request.getAttribute(JAVAX_SERVLET_REQUEST_X509CERTIFICATE);
        if (newCertChain == null) {
            _transferLog.error("rejected connection [" + count + "] from " + remoteIp + " that didnt supply a client certificate");
            throw new ServletException("no certificate supplied");
        }
        this.doCertificateCheck(newCertChain[0], remoteIp, count);
        _transferLog.info("incoming connection [" + count + "] from " + remoteIp + " (" + protocol + ")  using certificate " + newCertChain[0].getSubjectDN().toString());
    }

    private void doCertificateCheck(X509Certificate certificate, String remoteIp, int count) throws ServletException {
        try {
            String alias = SecureListener.getInstance().getTrustKeystore().getRawKeystore().getCertificateAlias(certificate);
            if (alias == null) {
                String certificateDN = certificate.getSubjectDN().toString();
                _transferLog.error("rejected connection [" + count + "] from " + remoteIp + " because the supplied client certificate is not trusted (" + certificateDN + ")");
                throw new ServletException("untrusted client Certificate: " + certificateDN);
            }
        }
        catch (KeyStoreException e) {
            _transferLog.error("rejected connection [" + count + "] from " + remoteIp + " client certificate could not be checked due to Keystore problem: " + e.getMessage());
            throw new ServletException("Could not access Keystore");
        }
    }
}

