/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp.filesystem;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.ftp.filesystem.ListenerFtpFile;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;

public class ListenerFileSystemView
implements FileSystemView {
    public static final String PLAIN_LISTENER = "PlainListener";
    private ListenerFtpFile _rootDir;
    private ListenerFtpFile _currentDir;
    private final TreeMap<String, ListenerFtpFile> _allFiles;
    private User _user;

    protected ListenerFileSystemView(User user) throws FtpException {
        if (user == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        this._user = user;
        this._currentDir = this._rootDir = new ListenerFtpFile(null, "/", null, true, this);
        this._allFiles = new TreeMap();
        this._allFiles.put("/", this._rootDir);
        Map ftpPathes = SecureListener.getInstance().getConfig().getFtpPathes();
        Set pathes = ftpPathes.keySet();
        for (String path : pathes) {
            String[] folders = path.split("/");
            ListenerFtpFile parent = this._rootDir;
            for (String folder : folders) {
                if (folder.length() <= 0) continue;
                ListenerFtpFile child = new ListenerFtpFile(parent, folder, this._user, true, this);
                ListenerFtpFile oldChild = this._allFiles.get(child.getAbsolutePath());
                if (oldChild != null) {
                    child = oldChild;
                }
                this.addChildObject(child);
                parent = child;
            }
            String listenerName = (String)ftpPathes.get(path);
            if (!PLAIN_LISTENER.equals(listenerName)) {
                this._allFiles.get(path).setWritePermission(true);
            }
            this._allFiles.get(path).setListener(listenerName);
        }
    }

    public FtpFile getHomeDirectory() {
        return this._rootDir;
    }

    public FtpFile getWorkingDirectory() throws FtpException {
        return this._currentDir;
    }

    public FtpFile getFile(String file) {
        if (file.equals("./")) {
            return this._currentDir;
        }
        Object absoluteFileName = file.startsWith("/") ? file : this._currentDir.getAbsolutePath() + (this._currentDir.getAbsolutePath().endsWith("/") ? "" : "/") + file;
        FtpFile existing = this._allFiles.get(absoluteFileName);
        if (existing == null) {
            Path path = Path.of((String)absoluteFileName, new String[0]);
            Optional<Map.Entry<String, ListenerFtpFile>> parent = this.findParent(path);
            ListenerFtpFile e = new ListenerFtpFile(parent.isPresent() ? parent.get().getValue() : this._currentDir, parent.map(stringListenerFtpFileEntry -> path.toString().replaceAll((String)stringListenerFtpFileEntry.getKey() + "/", "")).orElse(file), this._user, false, this);
            parent.ifPresentOrElse(f -> e.setWritePermission(((ListenerFtpFile)f.getValue()).isWritable()), () -> e.setWritePermission(this._currentDir.isWritable()));
            existing = e;
        }
        return existing;
    }

    private Optional<Map.Entry<String, ListenerFtpFile>> findParent(Path path) {
        Optional<Map.Entry<String, ListenerFtpFile>> parent = this._allFiles.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(path.getParent().toString())).findFirst();
        if (parent.isPresent()) {
            return parent;
        }
        if (path.getParent() != null && path.getParent().getParent() != null && path.getParent().getParent().getFileName().equals("plain")) {
            return this.findParent(path.getParent());
        }
        return Optional.empty();
    }

    public boolean changeWorkingDirectory(String dir) {
        ListenerFtpFile newDir = null;
        if (dir.startsWith("/")) {
            newDir = "/".equals(dir) ? this._allFiles.get(dir) : (dir.endsWith("/") ? this._allFiles.get(dir.substring(0, dir.length() - 1)) : this._allFiles.get(dir));
            if (newDir == null) {
                String parentPath;
                ListenerFtpFile parent;
                String fixedDir = dir;
                int index = fixedDir.lastIndexOf(47);
                if (index == fixedDir.length() - 1) {
                    fixedDir = fixedDir.substring(0, index);
                    index = fixedDir.lastIndexOf("/");
                }
                if (index == 0) {
                    index = 1;
                }
                if ((parent = this._allFiles.get(parentPath = fixedDir.substring(0, index))) != null && PLAIN_LISTENER.equals(parent.getListener())) {
                    String childName = parent.getParent() == null ? fixedDir.substring(parentPath.length()) : fixedDir.substring(parentPath.length() + 1);
                    ListenerFtpFile child = new ListenerFtpFile(parent, childName, this._user, true, this);
                    child.setWritePermission(true);
                    child.setListener(parent.getListener());
                    this.addChildObject(child);
                    newDir = child;
                }
            }
        } else if (dir.equals("..")) {
            newDir = this._currentDir.equals(this._rootDir) ? this._currentDir : this._currentDir.getParent();
        } else {
            if (this._currentDir.equals(this._rootDir)) {
                return this.changeWorkingDirectory(this._currentDir.getAbsolutePath() + dir);
            }
            return this.changeWorkingDirectory(this._currentDir.getAbsolutePath() + "/" + dir);
        }
        if (newDir != null && newDir.isDirectory()) {
            this._currentDir = newDir;
            return true;
        }
        return false;
    }

    public void addChildObject(ListenerFtpFile child) {
        if (child.getParent() != null) {
            child.getParent().addChildObject(child);
        }
        this._allFiles.put(child.getAbsolutePath(), child);
    }

    public boolean isRandomAccessible() {
        return false;
    }

    public void dispose() {
    }
}

