/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.PropertiesUserManager;
import de.ponton.securelistener.ftp.STOR;
import de.ponton.securelistener.ftp.STOU;
import de.ponton.securelistener.ftp.SaltedPasswordEncryptor;
import de.ponton.securelistener.ftp.filesystem.ListenerFileSystemFactory;
import de.ponton.securelistener.security.PontonKeystore;
import de.ponton.securelistener.websocket.ftpforwarding.FtpToWebsocketAdapter;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.command.Command;
import org.apache.ftpserver.command.CommandFactory;
import org.apache.ftpserver.command.CommandFactoryFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.impl.DefaultSslConfiguration;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FtpListener {
    private static final Logger _log = LogManager.getLogger((String)("Messenger." + FtpListener.class.getName()));
    private FtpServer _ftpServer;

    @Inject
    public FtpListener(FtpToWebsocketAdapter websocketAdapter) throws Exception {
        _log.debug("starting up FTP Listener");
        ListenerProperties ftpProperties = SecureListener.getInstance().getConfig();
        FtpServerFactory serverFactory = new FtpServerFactory();
        CommandFactoryFactory commandFactoryFactory = new CommandFactoryFactory();
        commandFactoryFactory.addCommand("STOR", (Command)new STOR(websocketAdapter));
        commandFactoryFactory.addCommand("STOU", (Command)new STOU(websocketAdapter));
        CommandFactory commandFactory = commandFactoryFactory.createCommandFactory();
        serverFactory.setCommandFactory(commandFactory);
        ListenerFactory factory = new ListenerFactory();
        String ftpAddress = ftpProperties.getFtpListenerAddress();
        if (ftpAddress != null && !"*".equals(ftpAddress)) {
            factory.setServerAddress(ftpAddress);
        }
        factory.setPort(ftpProperties.getFtpListenerPort());
        SslConfiguration sslConfiguration = this.buildSslConfiguration(ftpProperties);
        factory.setSslConfiguration(sslConfiguration);
        factory.setImplicitSsl(false);
        DataConnectionConfiguration dataConnectionConfiguration = this.buildDataConnectionConfiguration(ftpProperties, sslConfiguration);
        factory.setDataConnectionConfiguration(dataConnectionConfiguration);
        serverFactory.addListener("default", factory.createListener());
        ListenerFileSystemFactory fileSystemFactory = new ListenerFileSystemFactory();
        serverFactory.setFileSystem((FileSystemFactory)fileSystemFactory);
        PropertiesUserManager userManager = new PropertiesUserManager((PasswordEncryptor)new SaltedPasswordEncryptor(), new File(SecureListener.FTP_USERS_PROPERTIES), "admin");
        serverFactory.setUserManager((UserManager)userManager);
        this._ftpServer = serverFactory.createServer();
        this._ftpServer.start();
        try {
            _log.info("FTP Listener started on " + ftpProperties.getFtpListenerAddress() + ":" + ftpProperties.getFtpListenerPort());
        }
        catch (Exception e) {
            this.stopFtpServer();
            _log.error("FTP Listener couldn't start. ", (Throwable)e);
            throw e;
        }
    }

    private DataConnectionConfiguration buildDataConnectionConfiguration(ListenerProperties ftpProperties, SslConfiguration sslConfiguration) {
        DataConnectionConfigurationFactory connectionConfigurationFactory = new DataConnectionConfigurationFactory();
        connectionConfigurationFactory.setImplicitSsl(false);
        connectionConfigurationFactory.setSslConfiguration(sslConfiguration);
        connectionConfigurationFactory.setIdleTime(10);
        connectionConfigurationFactory.setActiveEnabled(ftpProperties.isFtpDataConnectionActiveModeAllowed());
        String dataConnectionActiveLocalAddress = ftpProperties.getFtpDataConnectionActiveLocalAddress();
        if (dataConnectionActiveLocalAddress != null && !"*".equals(dataConnectionActiveLocalAddress)) {
            connectionConfigurationFactory.setActiveLocalAddress(dataConnectionActiveLocalAddress);
        }
        connectionConfigurationFactory.setActiveLocalPort(ftpProperties.getFtpDataConnectionActiveLocalPort());
        String dataConnectionAddress = ftpProperties.getFtpDataConnectionAddress();
        if (dataConnectionAddress != null && !"*".equals(dataConnectionAddress)) {
            connectionConfigurationFactory.setPassiveAddress(dataConnectionAddress);
        }
        connectionConfigurationFactory.setPassivePorts(ftpProperties.getFtpDataConnectionPorts());
        return connectionConfigurationFactory.createDataConnectionConfiguration();
    }

    private SslConfiguration buildSslConfiguration(ListenerProperties ftpProperties) throws GeneralSecurityException, IOException {
        ListenerProperties.PrivateKeyInfo privateKeyInfo = (ListenerProperties.PrivateKeyInfo)ftpProperties.getPrivateKeyInfos().get(0);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
        PontonKeystore serverKeystore = SecureListener.getInstance().getServerKeystore();
        PrivateKey privateKey = serverKeystore.getPrivateKey(privateKeyInfo.alias(), privateKeyInfo.password().toCharArray());
        Certificate[] certificateChain = serverKeystore.getCertificateChainForPrivateKey(privateKeyInfo.alias());
        KeyStore newKeyStore = KeyStore.getInstance("PKCS12", "BC");
        newKeyStore.load(null, "changeit".toCharArray());
        newKeyStore.setKeyEntry(privateKeyInfo.alias(), privateKey, "changeit".toCharArray(), certificateChain);
        keyManagerFactory.init(newKeyStore, "changeit".toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        KeyStore newTrustKeyStore = KeyStore.getInstance("PKCS12", "BC");
        newTrustKeyStore.load(null, "changeit".toCharArray());
        PontonKeystore trustKeystore = SecureListener.getInstance().getTrustKeystore();
        trustKeystore.getAllCACertificates().forEach(certificate -> {
            try {
                newTrustKeyStore.setCertificateEntry(UUID.nameUUIDFromBytes(certificate.getEncoded()).toString(), (Certificate)certificate);
            }
            catch (Exception e) {
                _log.error("Error while adding certificate to truststore", (Throwable)e);
            }
        });
        trustManagerFactory.init(newTrustKeyStore);
        return new DefaultSslConfiguration(keyManagerFactory, trustManagerFactory, ClientAuth.NONE, this.getEnabledProtocols(ftpProperties), this.getEnabledCiphers(ftpProperties), privateKeyInfo.alias());
    }

    private String[] getEnabledProtocols(ListenerProperties ftpProperties) throws NoSuchAlgorithmException {
        String[] allProtocols = SSLContext.getDefault().getDefaultSSLParameters().getProtocols();
        String[] disabledProtocols = ftpProperties.getDisabledProtocols();
        return this.calculateEffectiveValues(allProtocols, disabledProtocols, "SSL Protocols");
    }

    private String[] getEnabledCiphers(ListenerProperties config) throws GeneralSecurityException {
        String[] allCiphers = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
        String[] disabledCiphers = config.getDisabledSSLCiphers();
        return this.calculateEffectiveValues(allCiphers, disabledCiphers, "SSL Ciphers");
    }

    private String[] calculateEffectiveValues(String[] allCiphers, String[] disabledCiphers, String logMessage) {
        ArrayList<String> includedCiphers = new ArrayList<String>();
        ArrayList<String> excludedCiphers = new ArrayList<String>();
        for (String allCipher : allCiphers) {
            boolean exclude = false;
            for (String disabledCipher : disabledCiphers) {
                if (!allCipher.matches(disabledCipher)) continue;
                exclude = true;
                break;
            }
            if (exclude) {
                excludedCiphers.add(allCipher);
                continue;
            }
            includedCiphers.add(allCipher);
        }
        _log.info("Included " + logMessage);
        Collections.sort(includedCiphers);
        for (String included : includedCiphers) {
            _log.info("  " + included);
        }
        _log.info("Excluded " + logMessage);
        Collections.sort(excludedCiphers);
        for (String excluded : excludedCiphers) {
            _log.info("  " + excluded);
        }
        return includedCiphers.toArray(new String[0]);
    }

    public void stopFtpServer() {
        if (this._ftpServer != null) {
            this._ftpServer.stop();
            this._ftpServer = null;
        }
    }
}

