/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.administration;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.StatusSingleton;
import de.ponton.securelistener.administration.CommandRequest;
import de.ponton.securelistener.administration.CommandResponse;
import de.ponton.securelistener.administration.Constants;
import de.ponton.securelistener.administration.certs.CertRequest;
import de.ponton.securelistener.administration.certs.GenerateCertificateRequest;
import de.ponton.securelistener.administration.certs.InstallCertException;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.FtpExchangeUserProperties;
import de.ponton.securelistener.ftp.PropertiesUserManager;
import de.ponton.securelistener.ftp.SaltedPasswordEncryptor;
import de.ponton.securelistener.security.CertificateUtils;
import de.ponton.securelistener.security.PontonKeystore;
import jakarta.websocket.CloseReason;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class CommandTask
implements Runnable {
    private static final String LOCALHOST_IP4 = "127.0.0.1";
    private static final String TEXT_PLAIN = "text/plain";
    private static final Logger LOG = LogManager.getLogger((String)"admin");
    private final CommandRequest commandRequest;
    private final Session webSocketSession;

    public CommandTask(Map<String, String> requestHeaders, byte[] requestData, Session webSocketSession) {
        this.commandRequest = new CommandRequest(requestHeaders, requestData);
        this.webSocketSession = webSocketSession;
    }

    @Override
    public void run() {
        CommandResponse commandResponse;
        try {
            commandResponse = this.executeCommand(SecureListener.getInstance(), this.commandRequest);
        }
        catch (Exception e) {
            LOG.error("Could not execute command. Reason: {}", (Object)e, (Object)e);
            commandResponse = this.createErrorCommandResponse("Could not execute command. Reason: " + String.valueOf(e));
        }
        try {
            RemoteEndpoint.Basic basicRemoteEndpoint = this.webSocketSession.getBasicRemote();
            String headersString = commandResponse.getHeadersAsString();
            basicRemoteEndpoint.sendText(headersString);
            byte[] responseData = commandResponse.getData();
            if (responseData == null) {
                responseData = new byte[]{};
            }
            ByteArrayInputStream in = new ByteArrayInputStream(responseData);
            this.sendData(in, basicRemoteEndpoint);
        }
        catch (IOException e) {
            LOG.error("Could not execute admin command. {}", (Object)e.getMessage());
            try {
                this.webSocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Could not execute admin command. " + String.valueOf(e)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendData(InputStream in, RemoteEndpoint.Basic basicRemoteEndpoint) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        block4: while (len > -1) {
            len = in.read(buffer);
            switch (len) {
                case -1: {
                    LOG.debug("sending transmission complete trigger");
                    basicRemoteEndpoint.sendBinary(ByteBuffer.wrap(Constants.TRANSMISSION_OK), true);
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            LOG.debug("sending {} bytes", (Object)len);
            basicRemoteEndpoint.sendBinary(ByteBuffer.wrap(buffer, 0, len), false);
        }
    }

    private CommandResponse createErrorCommandResponse(String errorText) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Length", "0");
        responseHeaders.put("X-Error", errorText);
        return new CommandResponse(responseHeaders, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandResponse executeCommand(SecureListener secureListener, CommandRequest commandRequest) {
        HashMap<String, Object> responseHeaders = new HashMap<String, Object>();
        String command = commandRequest.getHeader("command");
        if (command == null) {
            return this.createErrorCommandResponse("No command was sent.");
        }
        LOG.info("executing command {}", (Object)command);
        switch (command) {
            case "getConfig": {
                try {
                    return this.getConfig(commandRequest);
                }
                catch (IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
                    LOG.error("Unable to get the listener configuration. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the listener configuration. Reason: " + String.valueOf(e));
                }
            }
            case "updateConfig": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        return this.updateConfig(commandRequest);
                    }
                }
                catch (IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
                    LOG.error("Unable to update the listener configuration. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to update the listener configuration. Reason: " + String.valueOf(e));
                }
            }
            case "getFtpUsersConfig": {
                try {
                    return this.getFtpUsersConfig();
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    LOG.error("Unable to get ftp users configuration. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get ftp users configuration. Reason: " + String.valueOf(e));
                }
            }
            case "updateFtpUsersConfig": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        return this.updateFtpUsersConfig(commandRequest);
                    }
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException | FtpException e) {
                    LOG.error("Unable to update ftp users configuration. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to update ftp users configuration. Reason: " + String.valueOf(e));
                }
            }
            case "getIpAdresses": {
                try {
                    return this.getIps();
                }
                catch (IOException e) {
                    LOG.error("Unable to get IP addresses. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get IP addresses. Reason: " + String.valueOf(e));
                }
            }
            case "shutdown": {
                SecureListener e = secureListener;
                synchronized (e) {
                    secureListener.shutdownServices();
                }
                responseHeaders.put("Content-Length", "0");
                return new CommandResponse(responseHeaders, null);
            }
            case "start": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        secureListener.startServices();
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (Exception e) {
                    LOG.error("Unable to start the services. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to start the services. Reason: " + String.valueOf(e));
                }
            }
            case "restart": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        secureListener.restartServices();
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (Exception e) {
                    LOG.error("Unable to start the services. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to restart the services. Reason: " + e.toString().replace("\n", ""));
                }
            }
            case "getStatus": {
                String http;
                String https = StatusSingleton.getInstance().getHttps();
                if (https != null) {
                    responseHeaders.put("X-HTTPS", https);
                }
                if ((http = StatusSingleton.getInstance().getHttp()) != null) {
                    responseHeaders.put("X-HTTP", http);
                }
                responseHeaders.put("X-HTTP-CALLBACK", "" + StatusSingleton.getInstance().getCallbackHttp());
                responseHeaders.put("X-HTTPS-CALLBACK", "" + StatusSingleton.getInstance().getCallbackHttps());
                responseHeaders.put("X-PROXY", StatusSingleton.getInstance().getProxy());
                responseHeaders.put("X-HTTPS-CLIENTCERTCHECK", "" + StatusSingleton.getInstance().isHttpsClientCertCheck());
                responseHeaders.put("X-HTTPS-CLIENTCERTAUTH", "" + StatusSingleton.getInstance().isHttpsClientCertAuth());
                responseHeaders.put("X-UPTIME", "" + StatusSingleton.getInstance().getStartTime());
                responseHeaders.put("X-MESSAGECOUNT", "" + StatusSingleton.getInstance().getMessageCount());
                responseHeaders.put("X-LASTMESSAGE", "" + StatusSingleton.getInstance().getLastMessageReceivedTime());
                responseHeaders.put("X-LASTIP", StatusSingleton.getInstance().getLastMessageIP());
                responseHeaders.put("X-LISTENER-VERSION", SecureListener.getVERSION());
                responseHeaders.put("Content-Length", "0");
                return new CommandResponse(responseHeaders, null);
            }
            case "addClientCertificate": {
                try {
                    SecureListener https = secureListener;
                    synchronized (https) {
                        return this.installClientCertificate(commandRequest);
                    }
                }
                catch (InstallCertException | KeyStoreException | NoSuchProviderException | CertificateException e) {
                    LOG.error("Unable to install client certificate. Reason: {}", (Object)e.getMessage());
                    return this.createErrorCommandResponse("Unable to install the client certificate. Reason: " + e.getMessage());
                }
                catch (Exception e) {
                    LOG.error("Unable to install client certificate.", (Throwable)e);
                    return this.createErrorCommandResponse("Unable to install the client certificate. Reason: " + String.valueOf(e));
                }
            }
            case "getClientCertificate": {
                String alias = null;
                try {
                    alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
                    if (alias == null) {
                        LOG.error("Could not get certificate. Reason: Alias was not sent.");
                        return this.createErrorCommandResponse("Could not get certificate. Reason: Alias was not sent.");
                    }
                    return this.getCertificate(secureListener.getTrustKeystore(), alias);
                }
                catch (IllegalArgumentException ia) {
                    StringBuilder sb = new StringBuilder("client certificate with alias '");
                    sb.append(alias);
                    sb.append("' is not installed.");
                    LOG.error(sb.toString());
                    return this.createErrorCommandResponse(sb.toString());
                }
                catch (Exception e) {
                    LOG.error("Unable to get client certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the client certificate. Reason: " + String.valueOf(e));
                }
            }
            case "deleteClientCertificate": {
                try {
                    SecureListener alias = secureListener;
                    synchronized (alias) {
                        String alias2 = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
                        secureListener.getTrustKeystore().deleteCertificate(alias2);
                        secureListener.restartServices();
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (Exception e) {
                    LOG.error("Unable to delete client certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to delete the client certificate. Reason: " + String.valueOf(e));
                }
            }
            case "listClientCertificates": {
                return this.listCertificates(secureListener.getTrustKeystore().getCertificateAliases());
            }
            case "addClientCaCertificate": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        X509Certificate caCert = CertificateUtils.readCertificateFromBytes((byte[])commandRequest.getData());
                        if (caCert == null) {
                            throw new InstallCertException("CA certificate format is invald");
                        }
                        secureListener.getTrustKeystore().addCA(caCert);
                        secureListener.restartServices();
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (InstallCertException e) {
                    LOG.error("Unable to install the client ca certificate. : {}", (Object)e.getMessage());
                    return this.createErrorCommandResponse("Unable to install the client ca certificate. Reason: " + e.getMessage());
                }
                catch (Exception e) {
                    LOG.error("Unable to install the client ca certificate.", (Throwable)e);
                    return this.createErrorCommandResponse("Unable to install the client ca certificate. Reason: " + String.valueOf(e));
                }
            }
            case "getClientCaCertificate": {
                try {
                    String alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
                    return this.getCACertificate(secureListener.getTrustKeystore(), alias);
                }
                catch (Exception e) {
                    LOG.error("Unable to get the client ca certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the client ca certificate. Reason: " + String.valueOf(e));
                }
            }
            case "deleteClientCACertificate": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        String alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
                        secureListener.getTrustKeystore().deleteCertificate(alias);
                        secureListener.restartServices();
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (Exception e) {
                    LOG.error("Unable to delete the client ca certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to delete the client ca certificate. Reason: " + String.valueOf(e));
                }
            }
            case "listClientCACertificates": {
                return this.listCertificates(secureListener.getTrustKeystore().getCACertificateAliases());
            }
            case "getClientCertificateAlias": 
            case "getClientCACertificateAlias": {
                try {
                    return this.getAliasForCertificate(secureListener.getTrustKeystore(), commandRequest);
                }
                catch (Exception e) {
                    LOG.error("Unable to get client certificate alias. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the client certificate alias. Reason: " + String.valueOf(e));
                }
            }
            case "addServerCaCertificate": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        X509Certificate caCert = CertificateUtils.readCertificateFromBytes((byte[])commandRequest.getData());
                        if (caCert == null) {
                            throw new InstallCertException("CA certificate format is invald");
                        }
                        PontonKeystore serverKeystore = secureListener.getServerKeystore();
                        serverKeystore.addCA(caCert, commandRequest.getHeader("X-Ponton-SecureListener-CertAlias"));
                        secureListener.getTempServerKeystore().addCA(caCert, commandRequest.getHeader("X-Ponton-SecureListener-CertAlias"));
                        try {
                            this.updateCAsForStoredKeyEntry(secureListener, serverKeystore);
                        }
                        catch (InstallCertException | GeneralSecurityException e2) {
                            LOG.warn("could not update certificate chain of current server key. {}", (Object)e2.toString());
                        }
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (InstallCertException e) {
                    LOG.error("Unable to install server ca certificate. Reason: {}", (Object)e.getMessage());
                    return this.createErrorCommandResponse("Unable to install the server ca certificate. Reason: " + e.getMessage());
                }
                catch (Exception e) {
                    LOG.error("Unable to install server ca certificate.", (Throwable)e);
                    return this.createErrorCommandResponse("Unable to install the server ca certificate. Reason: " + String.valueOf(e));
                }
            }
            case "getServerCACertificate": {
                try {
                    String alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
                    return this.getCACertificate(secureListener.getServerKeystore(), alias);
                }
                catch (Exception e) {
                    LOG.error("Unable to get server ca certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the server ca certificate. Reason: " + String.valueOf(e));
                }
            }
            case "getServerCACertificateAlias": {
                try {
                    return this.getAliasForCertificate(secureListener.getServerKeystore(), commandRequest);
                }
                catch (Exception e) {
                    LOG.error("Unable to get server certificate alias. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the server certificate alias. Reason: " + String.valueOf(e));
                }
            }
            case "deleteServerCACertificate": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        String alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
                        secureListener.getServerKeystore().deleteCertificate(alias);
                    }
                    responseHeaders.put("Content-Length", "0");
                    return new CommandResponse(responseHeaders, null);
                }
                catch (Exception e) {
                    LOG.error("Unable to delete server ca certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to delete the server ca certificate. Reason: " + String.valueOf(e));
                }
            }
            case "listServerCACertificates": {
                return this.listCertificates(secureListener.getServerKeystore().getCACertificateAliases());
            }
            case "getServerCertificateRequest": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        return this.generateCertificateRequest(commandRequest);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to get server certificate request. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get server certificate request. Reason: " + String.valueOf(e));
                }
            }
            case "listServerCertificate": {
                ArrayList<String> aliases = new ArrayList<String>();
                secureListener.getConfig().getPrivateKeyInfos().forEach(privateKeyInfo -> aliases.add(privateKeyInfo.alias()));
                return this.listCertificates(aliases);
            }
            case "getServerCertificate": {
                try {
                    return this.getCertificateForPrivateKey(secureListener.getServerKeystore(), commandRequest.getHeader("X-Ponton-SecureListener-CertAlias"));
                }
                catch (Exception e) {
                    LOG.error("Unable to get server certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to get the server certificate. Reason: " + String.valueOf(e));
                }
            }
            case "exportServerCertificate": {
                try {
                    return this.exportServerCertificate(commandRequest);
                }
                catch (IOException | GeneralSecurityException e) {
                    LOG.error("Unable to export server certificate. Reason: {}", (Object)e.toString());
                    return this.createErrorCommandResponse("Unable to export the server certificate. Reason: " + String.valueOf(e));
                }
            }
            case "installServerCertificate": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        return this.installServerCertificate(secureListener, commandRequest);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to install server certificate.", (Throwable)e);
                    return this.createErrorCommandResponse("Unable to install the server certificate. Reason: " + e.getMessage());
                }
            }
            case "deleteServerCertificate": {
                try {
                    SecureListener e = secureListener;
                    synchronized (e) {
                        return this.deleteServerCertificate(secureListener, commandRequest);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to delete server certificate.", (Throwable)e);
                    return this.createErrorCommandResponse("Unable to delete the server certificate. Reason: " + e.getMessage());
                }
            }
        }
        LOG.warn("command not implemented: {}", (Object)command);
        return this.createErrorCommandResponse("The following command is not implemented:" + command);
    }

    private void updateCAsForStoredKeyEntry(SecureListener instance, PontonKeystore serverKeystore) throws GeneralSecurityException, InstallCertException {
        for (ListenerProperties.PrivateKeyInfo privateKeyInfo : instance.getConfig().getPrivateKeyInfos()) {
            PontonKeystore keystore = instance.getServerKeystore();
            PrivateKey privateKey = serverKeystore.getPrivateKey(privateKeyInfo.alias(), privateKeyInfo.password().toCharArray());
            X509Certificate certificate = serverKeystore.getCertificateForPrivateKey(privateKeyInfo.alias());
            X509Certificate[] certChain = serverKeystore.getCertificateChain(certificate);
            keystore.addPrivateKey(privateKeyInfo.alias(), privateKey, privateKeyInfo.password().toCharArray(), certChain);
        }
    }

    private CommandResponse getIps() throws IOException {
        ArrayList<String> ips = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (ips.contains(address.getHostAddress()) || !(address instanceof Inet4Address) || LOCALHOST_IP4.equals(address.getHostAddress())) continue;
                ips.add(address.getHostAddress());
            }
        }
        if (ips.isEmpty()) {
            ips.add(LOCALHOST_IP4);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashMap<String, Object> responseHeaders = new HashMap<String, Object>();
        responseHeaders.put("X-Ponton-SecureListener-IPCount", "" + ips.size());
        PrintWriter writer = new PrintWriter(baos);
        for (String ip : ips) {
            writer.print(ip);
            writer.print("\r\n");
        }
        writer.flush();
        responseHeaders.put("Content-Length", String.valueOf(baos.size()));
        return new CommandResponse(responseHeaders, baos.toByteArray());
    }

    private ListenerProperties getConfig() {
        return SecureListener.getInstance().getConfig();
    }

    private CommandResponse getConfig(CommandRequest commandRequest) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.getConfig().storeConfig((OutputStream)outputStream);
        byte[] cfg = outputStream.toByteArray();
        MessageDigest md5 = MessageDigest.getInstance("MD5", "BC");
        md5.update(cfg);
        String digest = new String(Base64.encode((byte[])md5.digest()));
        byte[] encoded = Base64.encode((byte[])cfg);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("X-Ponton-SecureListener-CfgDigest", digest);
        header.put("Content-Length", String.valueOf(encoded.length));
        header.put("Content-Type", TEXT_PLAIN);
        return new CommandResponse(header, encoded);
    }

    private PropertiesUserManager getUserManager() {
        return new PropertiesUserManager((PasswordEncryptor)new SaltedPasswordEncryptor(), new File(SecureListener.FTP_USERS_PROPERTIES), "admin");
    }

    private CommandResponse getFtpUsersConfig() throws NoSuchAlgorithmException, NoSuchProviderException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        PropertiesUserManager userManager = this.getUserManager();
        FtpExchangeUserProperties properties = new FtpExchangeUserProperties(userManager.getFtpExchangeUsers());
        byte[] cfg = properties.createConfig().toString().getBytes();
        MessageDigest md5 = MessageDigest.getInstance("MD5", "BC");
        md5.update(cfg);
        String digest = new String(Base64.encode((byte[])md5.digest()));
        byte[] encoded = Base64.encode((byte[])cfg);
        responseHeaders.put("X-Ponton-SecureListener-FtpUsersCfgDigest", digest);
        responseHeaders.put("Content-Length", String.valueOf(encoded.length));
        responseHeaders.put("Content-Type", TEXT_PLAIN);
        return new CommandResponse(responseHeaders, encoded);
    }

    private CommandResponse updateConfig(CommandRequest commandRequest) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        byte[] cfg = Base64.decode((byte[])commandRequest.getData());
        MessageDigest md5 = MessageDigest.getInstance("MD5", "BC");
        md5.update(cfg);
        String digestLocal = new String(Base64.encode((byte[])md5.digest()));
        String digestRemote = commandRequest.getHeader("X-Ponton-SecureListener-CfgDigest");
        if (!digestLocal.equals(digestRemote)) {
            throw new SecurityException("Unable to update the configuration. Digest mismatch.");
        }
        SecureListener.getInstance().getConfig().updateConfig(cfg);
        SecureListener.getInstance().getConfig().storeConfig(new File(SecureListener.CONFIG_LISTENER_PROPERTIES));
        responseHeaders.put("Content-Length", "0");
        return new CommandResponse(responseHeaders, null);
    }

    private CommandResponse updateFtpUsersConfig(CommandRequest commandRequest) throws NoSuchAlgorithmException, NoSuchProviderException, FtpException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        byte[] cfg = Base64.decode((byte[])commandRequest.getData());
        MessageDigest md5 = MessageDigest.getInstance("MD5", "BC");
        md5.update(cfg);
        String digestLocal = new String(Base64.encode((byte[])md5.digest()));
        String digestRemote = commandRequest.getHeader("X-Ponton-SecureListener-FtpUsersCfgDigest");
        if (!digestLocal.equals(digestRemote)) {
            throw new SecurityException("Unable to update the configuration of ftp users. Digest mismatch.");
        }
        FtpExchangeUserProperties properties = new FtpExchangeUserProperties((InputStream)new ByteArrayInputStream(cfg));
        PropertiesUserManager userManager = this.getUserManager();
        userManager.overwriteUsers(properties.getFtpExchangeUsers());
        responseHeaders.put("Content-Length", "0");
        return new CommandResponse(responseHeaders, null);
    }

    private CommandResponse generateCertificateRequest(CommandRequest commandRequest) throws Exception {
        CertRequest csr = new CertRequest(commandRequest.getHeader("X-Ponton-SecureListener-CN"), commandRequest.getHeader("X-Ponton-SecureListener-OU"), commandRequest.getHeader("X-Ponton-SecureListener-O"), commandRequest.getHeader("X-Ponton-SecureListener-L"), commandRequest.getHeader("X-Ponton-SecureListener-ST"), commandRequest.getHeader("X-Ponton-SecureListener-C"), commandRequest.getHeader("X-Ponton-SecureListener-EMAIL"), commandRequest.getHeader("X-Ponton-SecureListener-PHONE"), commandRequest.getHeader("X-Ponton-SecureListener-FAX"), commandRequest.getHeader("X-Ponton-SecureListener-KeyPass"), commandRequest.getHeader("X-Ponton-SecureListener-KeyPair"), commandRequest.getHeader("X-Ponton-SecureListener-Keylength"), commandRequest.getHeader("X-Ponton-SecureListener-SAN"));
        GenerateCertificateRequest genCsr = new GenerateCertificateRequest(csr);
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("X-Ponton-SecureListener-CN", csr.getCn());
        responseHeaders.put("X-Ponton-SecureListener-OU", csr.getOu());
        responseHeaders.put("X-Ponton-SecureListener-O", csr.getO());
        responseHeaders.put("X-Ponton-SecureListener-C", csr.getC());
        responseHeaders.put("X-Ponton-SecureListener-EMAIL", csr.getEmail());
        if (csr.getPhone() != null && !csr.getPhone().isEmpty()) {
            responseHeaders.put("X-Ponton-SecureListener-PHONE", csr.getPhone());
        }
        if (csr.getSan() != null && !csr.getSan().isEmpty()) {
            responseHeaders.put("X-Ponton-SecureListener-SAN", csr.getSan());
        }
        if (csr.getFax() != null && !csr.getFax().isEmpty()) {
            responseHeaders.put("X-Ponton-SecureListener-FAX", csr.getFax());
        }
        responseHeaders.put("X-Ponton-SecureListener-KeyPass", csr.getPassword());
        if (csr.getKeyPair() != null && !csr.getKeyPair().isEmpty()) {
            responseHeaders.put("X-Ponton-SecureListener-KeyPair", csr.getKeyPair());
        }
        if (csr.getKeyLength() != null && !csr.getKeyLength().isEmpty()) {
            responseHeaders.put("X-Ponton-SecureListener-Keylength", csr.getKeyLength());
        }
        byte[] data = genCsr.getCertRequest().getRequest();
        responseHeaders.put("Content-Length", String.valueOf(data.length));
        return new CommandResponse(responseHeaders, data);
    }

    private CommandResponse listCertificates(List<String> aliases) {
        HashMap<String, Object> responseHeaders = new HashMap<String, Object>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        responseHeaders.put("X-Ponton-SecureListener-CertCount", "" + aliases.size());
        if (!aliases.isEmpty()) {
            PrintWriter writer = new PrintWriter(baos);
            for (String ip : aliases) {
                writer.print(ip);
                writer.print("\r\n");
            }
            writer.flush();
            responseHeaders.put("Content-Length", String.valueOf(baos.size()));
        }
        return new CommandResponse(responseHeaders, baos.toByteArray());
    }

    private CommandResponse getCertificate(PontonKeystore keystore, String alias) throws Exception {
        X509Certificate cert = keystore.getCertificate(alias);
        if (cert == null) {
            throw new IllegalArgumentException();
        }
        return this.sendCertificate(cert);
    }

    private CommandResponse getCertificateForPrivateKey(PontonKeystore keystore, String alias) throws Exception {
        return this.sendCertificate(keystore.getCertificateForPrivateKey(alias));
    }

    private CommandResponse getCACertificate(PontonKeystore keystore, String alias) throws Exception {
        return this.sendCertificate(keystore.getCA(alias));
    }

    private CommandResponse sendCertificate(X509Certificate cert) throws Exception {
        byte[] data = CertificateUtils.certificateBase64Encoded((X509Certificate)cert).getBytes();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Length", String.valueOf(data.length));
        return new CommandResponse(responseHeaders, data);
    }

    private CommandResponse installClientCertificate(CommandRequest commandRequest) throws CertificateException, NoSuchProviderException, InstallCertException, KeyStoreException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        X509Certificate cert = CertificateUtils.readCertificateFromBytes((byte[])commandRequest.getData());
        if (cert == null) {
            throw new InstallCertException("certificate format is invalid");
        }
        String alias = CertificateUtils.retrieveCN((X509Certificate)cert) + "_" + cert.getSerialNumber().toString();
        SecureListener.getInstance().getTrustKeystore().addCertificate(alias, cert, Boolean.parseBoolean(commandRequest.getHeader("X-Ponton-SecureListener-Check-Certificate")));
        responseHeaders.put("Content-Length", "0");
        return new CommandResponse(responseHeaders, null);
    }

    private CommandResponse installServerCertificate(SecureListener secureListener, CommandRequest commandRequest) throws IOException, GeneralSecurityException, InstallCertException {
        ListenerProperties.PrivateKeyInfo privateKeyInfo;
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        boolean privateKeyIncluded = Boolean.parseBoolean(commandRequest.getHeader("X-Ponton-SecureListener-Privkey-Included"));
        String password = commandRequest.getHeader("X-Ponton-SecureListener-KeyPass");
        if (!privateKeyIncluded) {
            privateKeyInfo = this.installServerCertificate(CertificateUtils.readCertificateFromBytes((byte[])commandRequest.getData()), password);
        } else {
            String line;
            ByteArrayOutputStream certBytes = new ByteArrayOutputStream();
            ByteArrayOutputStream keyBytes = new ByteArrayOutputStream();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(commandRequest.getData())));
            boolean separatorFound = false;
            while ((line = reader.readLine()) != null) {
                if ("---CERT SEPARATOR---".equals(line)) {
                    separatorFound = true;
                    continue;
                }
                if (!separatorFound) {
                    certBytes.write(line.getBytes());
                    continue;
                }
                keyBytes.write(line.getBytes());
            }
            X509Certificate cert = CertificateUtils.readCertificateFromBytes((byte[])Base64.decode((byte[])certBytes.toByteArray()));
            PrivateKey privateKey = CertificateUtils.readPrivateKeyFromBytes((byte[])Base64.decode((byte[])keyBytes.toByteArray()), (String)cert.getPublicKey().getAlgorithm());
            privateKeyInfo = this.installServerCertificate(secureListener, cert, privateKey, password);
        }
        secureListener.getConfig().addPrivateKeyInfo(privateKeyInfo);
        secureListener.getConfig().storeConfig(new File(SecureListener.CONFIG_LISTENER_PROPERTIES));
        secureListener.loadKeystores();
        responseHeaders.put("X-Ponton-SecureListener-CertAlias", privateKeyInfo.alias());
        responseHeaders.put("Content-Length", "0");
        return new CommandResponse(responseHeaders, null);
    }

    private CommandResponse deleteServerCertificate(SecureListener secureListener, CommandRequest commandRequest) throws GeneralSecurityException, IOException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        String alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
        Optional<ListenerProperties.PrivateKeyInfo> privateKeyInfo = secureListener.getConfig().getPrivateKeyInfos().stream().filter(keyInfo -> keyInfo.alias().equals(alias)).findFirst();
        if (privateKeyInfo.isPresent()) {
            if (secureListener.getConfig().getPrivateKeyInfos().size() == 1) {
                throw new IllegalArgumentException("Cannot delete the last private key.");
            }
        } else {
            throw new IllegalArgumentException("No private key found for alias " + alias);
        }
        secureListener.getServerKeystore().deletePrivateKey(privateKeyInfo.get().alias());
        secureListener.getConfig().removePrivateKeyInfo(privateKeyInfo.get());
        secureListener.getConfig().storeConfig(new File(SecureListener.CONFIG_LISTENER_PROPERTIES));
        secureListener.loadKeystores();
        responseHeaders.put("Content-Length", "0");
        return new CommandResponse(responseHeaders, null);
    }

    private ListenerProperties.PrivateKeyInfo installServerCertificate(X509Certificate cert, String password) throws InstallCertException, CertificateException, KeyStoreException {
        PrivateKey tempPrivateKey;
        try {
            tempPrivateKey = SecureListener.getInstance().getTempServerKeystore().getTempPrivateKey("jetty", password.toCharArray());
        }
        catch (GeneralSecurityException e) {
            throw new InstallCertException("Wrong password. You must supply the password for your private key.");
        }
        if (tempPrivateKey == null) {
            throw new InstallCertException("No matching private key found for local ID. A certificate must be requested first.");
        }
        Certificate[] tempCert = SecureListener.getInstance().getTempServerKeystore().getCertificateChainForTempPrivateKey("jetty");
        if (!Arrays.equals(cert.getPublicKey().getEncoded(), tempCert[0].getPublicKey().getEncoded())) {
            throw new InstallCertException("Public key generated while requesting the certificate doesnot match with signed public key from certificate.");
        }
        PontonKeystore keystore = SecureListener.getInstance().getServerKeystore();
        X509Certificate[] certChain = keystore.getCertificateChain(cert);
        String alias = keystore.buildAliasForCertificate(cert);
        keystore.addPrivateKey(alias, tempPrivateKey, password.toCharArray(), certChain);
        keystore.addCertificate(alias, cert, true);
        return new ListenerProperties.PrivateKeyInfo(alias, password);
    }

    private ListenerProperties.PrivateKeyInfo installServerCertificate(SecureListener secureListener, X509Certificate cert, PrivateKey privateKey, String password) throws InstallCertException {
        try {
            PontonKeystore keystore = secureListener.getServerKeystore();
            X509Certificate[] certChain = keystore.getCertificateChain(cert);
            String alias = keystore.buildAliasForCertificate(cert);
            keystore.addPrivateKey(alias, privateKey, password.toCharArray(), certChain);
            keystore.addCertificate(alias, cert, true);
            return new ListenerProperties.PrivateKeyInfo(alias, password);
        }
        catch (KeyStoreException | CertificateException e) {
            throw new InstallCertException("Unable to install the private key and certificate. " + e.getMessage());
        }
    }

    private CommandResponse getAliasForCertificate(PontonKeystore keystore, CommandRequest commandRequest) throws CertificateException, NoSuchProviderException, KeyStoreException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        X509Certificate caCert = CertificateUtils.readCertificateFromBytes((byte[])commandRequest.getData());
        String alias = keystore.getCertificateAlias(caCert);
        if (alias != null && !alias.isEmpty()) {
            responseHeaders.put("X-Ponton-SecureListener-CertAlias", alias);
        }
        responseHeaders.put("Content-Length", Integer.toString(0));
        return new CommandResponse(responseHeaders, null);
    }

    private CommandResponse exportServerCertificate(CommandRequest commandRequest) throws GeneralSecurityException, IOException {
        PontonKeystore keystore = SecureListener.getInstance().getServerKeystore();
        String alias = commandRequest.getHeader("X-Ponton-SecureListener-CertAlias");
        String password = commandRequest.getHeader("X-Ponton-SecureListener-KeyPass");
        PrivateKey pk = keystore.getPrivateKey(alias, password.toCharArray());
        Certificate[] chain = keystore.getCertificateChainForPrivateKey(alias);
        KeyStore p12store = KeyStore.getInstance("PKCS12", "BC");
        p12store.load(null, password.toCharArray());
        p12store.setKeyEntry(alias, pk, password.toCharArray(), chain);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        p12store.store(out, password.toCharArray());
        byte[] encoded = Base64.encode((byte[])out.toByteArray());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", Integer.toString(encoded.length));
        return new CommandResponse(headers, encoded);
    }
}

