/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener;

import java.util.HashMap;

public class MimeTypeMapper {
    private static final String[][] FILE_EXTENSION_TO_MIME_TYPE;
    private static final String[][] MIME_TYPE_TO_FILE_EXTENSION;
    private static final HashMap<String, String> FILE_EXTENSION_TO_MIME_TYPE_MAP;
    private static final HashMap<String, String> MIME_TYPE_TO_FILE_EXTENSION_MAP;

    public static String getMimeType(String filename) {
        try {
            String mt = FILE_EXTENSION_TO_MIME_TYPE_MAP.get(filename.substring(filename.lastIndexOf(46), filename.length()).toLowerCase());
            if (mt != null) {
                return mt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "application/octet-stream";
    }

    public static String getExtension(String mimetype) {
        if (mimetype != null && MIME_TYPE_TO_FILE_EXTENSION_MAP.containsKey(mimetype.toLowerCase())) {
            return MIME_TYPE_TO_FILE_EXTENSION_MAP.get(mimetype.toLowerCase());
        }
        return ".dat";
    }

    /*
     * Opcode count of 19046 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int i;
        FILE_EXTENSION_TO_MIME_TYPE = new String[][]{{".123", "application/lotus"}, {".3dm", "x-world/x-3dmf"}, {".3dmf", "x-world/x-3dmf"}, {".Z", "application/x-compress"}, {".a", "application/octet-stream"}, {".aab", "application/x-authorware-bin"}, {".aam", "application/x-authorware-map"}, {".aas", "application/x-authorware-seg"}, {".acc", "chemical/x-synopsys-accord"}, {".acgi", "text/html"}, {".acu", "application/vnd.acucobol"}, {".aep", "application/vnd.audiograph"}, {".afl", "video/animaflex"}, {".afp", "application/vnd.ibm.modcap"}, {".ai", "application/postscript"}, {".aif", "audio/x-aiff"}, {".aifc", "audio/x-aiff"}, {".aiff", "audio/x-aiff"}, {".aim", "application/x-aim"}, {".aip", "text/x-audiosoft-intra"}, {".ani", "application/x-navi-animation"}, {".ano", "application/x-annotator"}, {".aos", "application/x-nokia-9000-communicator-add-on-software"}, {".apm", "application/studiom"}, {".apr", "application/vnd.lotus-approach"}, {".aps", "application/mime"}, {".arc", "application/octet-stream"}, {".arj", "application/octet-stream"}, {".art", "image/x-jg"}, {".asc", "text/plain"}, {".asd", "application/astound"}, {".asf", "video/x-ms-asf"}, {".asm", "text/x-asm"}, {".asn", "application/astound"}, {".aso", "application/vnd.accpac.simply.aso"}, {".asp", "text/asp"}, {".asx", "video/x-ms-asf"}, {".au", "audio/x-au"}, {".avb", "application/octet-stream"}, {".avi", "video/avi"}, {".avs", "video/avs-video"}, {".avx", "video/x-rad-screenplay"}, {".bcpio", "application/x-bcpio"}, {".bh2", "application/vnd.fujitsu.oasysprs"}, {".bin", "application/octet-stream"}, {".bld", "application/bld"}, {".bld2", "application/bld2"}, {".bm", "image/bmp"}, {".bmi", "application/vnd.bmi"}, {".bmp", "image/bitmap"}, {".boo", "application/book"}, {".book", "application/book"}, {".box", "application/vnd.previewsystems.box"}, {".boz", "application/x-bzip2"}, {".bpk", "application/octet-stream"}, {".bsh", "application/x-bsh"}, {".btf", "image/prs.btif"}, {".btif", "image/prs.btif"}, {".bz", "application/x-bzip"}, {".bz2", "application/x-bzip2"}, {".c", "text/plain"}, {".c++", "text/plain"}, {".cal", "image/x-cals"}, {".cat", "application/vnd.ms-pki.seccat"}, {".cc", "text/plain"}, {".ccad", "application/clariscad"}, {".ccn", "application/x-cnc"}, {".cco", "application/x-cocoa"}, {".cdf", "application/cdf"}, {".cdkey", "application/vnd.mediastation.cdkey"}, {".cdx", "chemical/x-chem3d"}, {".cer", "application/x-x509-ca-cert"}, {".cgi", "magnus-internal/cgi"}, {".cgm", "image/cgm"}, {".cha", "application/x-chat"}, {".chat", "application/x-chat"}, {".chm", "chemical/x-chemdraw"}, {".cif", "chemical/x-cif"}, {".cii", "application/vnd.anser-web-certificate-issue-initiation"}, {".cla", "application/vnd.claymore"}, {".class", "application/x-java-class"}, {".clp", "application/x-msclip"}, {".cmc", "application/vnd.cosmocaller"}, {".cmdf", "chemical/x-cmdf"}, {".cml", "chemical/x-cml"}, {".cmp", "application/vnd.yellowriver-custom-menu"}, {".cmx", "image/x-cmx"}, {".cod", "image/cis-cod"}, {".com", "application/octet-stream"}, {".conf", "text/plain"}, {".config", "application/x-ns-proxy-autoconfig"}, {".cpio", "application/x-cpio"}, {".cpp", "text/x-c"}, {".cpt", "application/mac-compactpro"}, {".crd", "application/x-mscardfile"}, {".crl", "application/pkcs-crl"}, {".crt", "application/x-x509-user-cert"}, {".csh", "text/x-script.csh"}, {".csm", "chemical/x-csml"}, {".csml", "chemical/x-csml"}, {".csp", "application/vnd.commonspace"}, {".css", "text/css"}, {".cst", "application/vnd.commonspace"}, {".cub", "chemical/x-gaussian-cube"}, {".curl", "text/vnd.curl"}, {".cw", "application/prs.cww"}, {".cww", "application/prs.cww"}, {".cxx", "text/plain"}, {".daf", "application/vnd.Mobius.DAF"}, {".dcm", "x-lml/x-evm"}, {".dcr", "application/x-director"}, {".dcx", "image/x-dcx"}, {".ddd", "application/vnd.fujixerox.ddd"}, {".deepv", "application/x-deepv"}, {".def", "text/plain"}, {".der", "application/x-x509-ca-cert"}, {".dib", "image/bmp"}, {".dic", "text/plain"}, {".dif", "video/x-dv"}, {".dir", "application/x-director"}, {".dis", "application/vnd.Mobius.DIS"}, {".dl", "video/dl"}, {".dll", "application/x-msdownload"}, {".dms", "application/octet-stream"}, {".dna", "application/vnd.dna"}, {".doc", "application/msword"}, {".dor", "model/vnd.gdl"}, {".dot", "application/msword"}, {".dp", "application/commonground"}, {".dpg", "application/vnd.dpgraph"}, {".dpgraph", "application/vnd.dpgraph"}, {".drw", "application/drafting"}, {".dsc", "text/prs.lines.tag"}, {".dtd", "text/xml"}, {".dump", "application/octet-stream"}, {".dv", "video/x-dv"}, {".dvi", "application/x-dvi"}, {".dwf", "drawing/x-dwf"}, {".dwg", "application/autocad"}, {".dx", "chemical/x-jcamp-dx"}, {".dxf", "image/x-dxf"}, {".dxr", "application/x-director"}, {".ebk", "application/x-expandedbook"}, {".ecelp4800", "audio/vnd.nuera.ecelp4800"}, {".ecelp7470", "audio/vnd.nuera.ecelp7470"}, {".edi", "application/EDIFACT"}, {".edm", "application/vnd.novadigm.EDM"}, {".edx", "application/vnd.novadigm.EDX"}, {".ei6", "application/vnd.pg.osasli"}, {".el", "text/x-script.elisp"}, {".elc", "application/x-bytecode.elisp"}, {".emb", "chemical/x-embl-dl-nucleotide"}, {".embl", "chemical/x-embl-dl-nucleotide"}, {".eml", "message/rfc822"}, {".eml", "multipart/related"}, {".eml", "multipart/report"}, {".enc", "video/mpeg"}, {".env", "application/x-envoy"}, {".eol", "audio/vnd.digital-winds"}, {".epb", "application/x-epublisher"}, {".eps", "application/postscript"}, {".es", "audio/echospeech"}, {".esl", "audio/echospeech"}, {".etc", "application/x-earthtime"}, {".etx", "text/x-setext"}, {".evm", "x-lml/x-evm"}, {".evy", "application/envoy"}, {".exc", "text/plain"}, {".exe", "application/octet-stream"}, {".ext", "application/vnd.novadigm.EXT"}, {".ez", "application/andrew-inset"}, {".f", "text/x-fortran"}, {".f77", "text/x-fortran"}, {".f90", "text/x-fortran"}, {".faxmgr", "application/x-fax-manager"}, {".faxmgrjob", "application/x-fax-manager-job"}, {".fbs", "image/vnd.fastbidsheet"}, {".fdf", "application/vnd.fdf"}, {".fdml", "text/html"}, {".fg5", "application/vnd.fujitsu.oasysgp"}, {".fgd", "application/x-director"}, {".fh", "image/x-freehand"}, {".fh4", "image/x-freehand"}, {".fh5", "image/x-freehand"}, {".fh7", "image/x-freehand"}, {".fhc", "image/x-freehand"}, {".fif", "image/fif"}, {".fli", "video/fli"}, {".flo", "image/florian"}, {".flx", "text/html"}, {".fly", "text/vnd.fly"}, {".fm", "application/x-framemaker"}, {".fmf", "video/x-atomic3d-feature"}, {".fml", "application/file-mirror-list"}, {".for", "text/x-fortran"}, {".fp5", "application/filemaker5"}, {".fpx", "image/x-fpx"}, {".frame", "application/x-framemaker"}, {".frl", "application/freeloader"}, {".frm", "application/x-framemaker"}, {".fst", "image/vnd.fst"}, {".fti", "application/vnd.anser-web-funds-transfer-initiation"}, {".funk", "audio/make"}, {".fvi", "video/isivideo"}, {".fvt", "video/vnd.fvt"}, {".g", "text/plain"}, {".g3", "image/g3fax"}, {".gac", "application/vnd.groove-account"}, {".gau", "chemical/x-gaussian-input"}, {".gdb", "x-lml/x-gdb"}, {".gdl", "model/vnd.gdl"}, {".gif", "image/gif"}, {".gim", "application/vnd.groove-identity-message"}, {".gl", "video/gl"}, {".gph", "application/vnd.FloGraphIt"}, {".gps", "application/x-gps"}, {".gqf", "application/vnd.grafeq"}, {".gqs", "application/vnd.grafeq"}, {".grv", "application/vnd.groove-injector"}, {".gsd", "audio/x-gsm"}, {".gsm", "audio/x-gsm"}, {".gsp", "application/x-gsp"}, {".gss", "application/x-gss"}, {".gtar", "application/x-gtar"}, {".gtm", "application/vnd.groove-tool-message"}, {".gtp", "application/bsi-gtp"}, {".gtw", "model/vnd.gtw"}, {".gz", "application/x-gzip"}, {".gzip", "application/x-gzip"}, {".h", "text/plain"}, {".hdf", "application/x-hdf"}, {".hdml", "text/x-hdml"}, {".help", "application/x-helpfile"}, {".hgl", "application/vnd.hp-HPGL"}, {".hh", "text/plain"}, {".hlb", "text/x-script"}, {".hlp", "application/winhlp"}, {".hpg", "application/vnd.hp-HPGL"}, {".hpgl", "application/vnd.hp-HPGL"}, {".hpi", "application/vnd.hp-hpid"}, {".hpid", "application/vnd.hp-hpid"}, {".hps", "application/vnd.hp-hps"}, {".hqx", "application/binhex"}, {".hta", "application/hta"}, {".htc", "text/x-component"}, {".htm", "text/html"}, {".html", "text/html"}, {".htmls", "text/html"}, {".htt", "text/webviewhtml"}, {".htx", "text/html"}, {".ic0", "application/vnd.commerce-battelle"}, {".ic1", "application/vnd.commerce-battelle"}, {".ic2", "application/vnd.commerce-battelle"}, {".ic3", "application/vnd.commerce-battelle"}, {".ic4", "application/vnd.commerce-battelle"}, {".ic5", "application/vnd.commerce-battelle"}, {".ic6", "application/vnd.commerce-battelle"}, {".ic7", "application/vnd.commerce-battelle"}, {".ic8", "application/vnd.commerce-battelle"}, {".ica", "application/vnd.commerce-battelle"}, {".icc", "application/vnd.commerce-battelle"}, {".icd", "application/vnd.commerce-battelle"}, {".ice", "x-conference/x-cooltalk"}, {".icf", "application/vnd.commerce-battelle"}, {".ico", "image/x-icon"}, {".idc", "text/plain"}, {".ief", "image/ief"}, {".iefs", "image/ief"}, {".ifm", "application/vnd.shana.informed.formdata"}, {".ifs", "image/ifs"}, {".iges", "model/iges"}, {".igs", "model/iges"}, {".igs", "application/iges"}, {".iii", "application/x-iphone"}, {".ima", "application/x-ima"}, {".imap", "application/x-httpd-imap"}, {".imd", "application/immedia"}, {".imp", "application/vnd.accpac.simply.imp"}, {".ims", "application/immedia"}, {".inf", "application/inf"}, {".ini", "text/plain"}, {".ins", "application/x-NET-Install"}, {".insight", "application/x-insight"}, {".inst", "application/x-install"}, {".ip", "application/x-ip2"}, {".ipk", "application/vnd.shana.informed.package"}, {".ips", "application/x-ipscript"}, {".ipx", "application/x-ipix"}, {".ism", "model/vnd.gdl"}, {".isp", "application/x-internet-signup"}, {".ist", "chemical/x-isostar"}, {".istr", "chemical/x-isostar"}, {".isu", "video/x-isvideo"}, {".it", "audio/x-mod"}, {".itp", "application/vnd.shana.informed.formtemp"}, {".itz", "audio/x-mod"}, {".iv", "application/x-inventor"}, {".ivf", "video/x-ivf"}, {".ivr", "i-world/i-vrml"}, {".ivy", "application/x-livescreen"}, {".jad", "text/vnd.sun.j2me.app-descriptor"}, {".jam", "audio/x-jam"}, {".jar", "application/x-java-archive"}, {".jav", "text/x-java-source"}, {".java", "text/x-java-source"}, {".jcm", "application/x-java-commerce"}, {".jdx", "chemical/x-jcamp-dx"}, {".jfif", "image/jpeg"}, {".jfif-tbnl", "image/jpeg"}, {".jpe", "image/jpeg"}, {".jpeg", "image/jpeg"}, {".jpg", "image/jpeg"}, {".jps", "image/x-jps"}, {".js", "application/x-javascript"}, {".jut", "image/jutvision"}, {".jvs", "application/x-ns-proxy-autoconfig"}, {".jwc", "application/jwc"}, {".kar", "audio/midi"}, {".kin", "chemical/x-kinemage"}, {".ksh", "application/x-ksh"}, {".la", "audio/nspaudio"}, {".lak", "x-lml/x-lak"}, {".lam", "audio/x-liveaudio"}, {".latex", "application/x-latex"}, {".lcc", "application/fastman"}, {".lcl", "application/x-digitalloca"}, {".lcr", "application/x-digitalloca"}, {".lgh", "application/lgh"}, {".lha", "application/octet-stream"}, {".lhx", "application/octet-stream"}, {".lic", "application/x-enterlicense"}, {".licmgr", "application/x-licensemgr"}, {".list", "text/plain"}, {".list3820", "application/vnd.ibm.modcap"}, {".listafp", "application/vnd.ibm.modcap"}, {".lma", "audio/nspaudio"}, {".lml", "x-lml/x-lml"}, {".lmlpack", "x-lml/x-lmlpack"}, {".lmp", "model/vnd.gdl"}, {".log", "text/plain"}, {".lsf", "video/x-ms-asf"}, {".lsp", "text/x-script.lisp"}, {".lst", "text/plain"}, {".lsx", "video/x-ms-asf"}, {".ltx", "application/x-latex"}, {".lvp", "audio/vnd.lucent.voice"}, {".lwp", "application/vnd.lotus-wordpro"}, {".lzh", "application/octet-stream"}, {".lzx", "application/octet-stream"}, {".m", "text/plain"}, {".m13", "application/x-msmediaview"}, {".m14", "application/x-msmediaview"}, {".m1v", "video/mpeg"}, {".m2a", "audio/mpeg"}, {".m2v", "video/mpeg"}, {".m3a", "audio/mpeg"}, {".m3u", "audio/mpegurl"}, {".ma", "application/mathematica"}, {".mag", "application/vnd.ecowin.chart"}, {".mail", "application/x-mailfolder"}, {".maker", "application/x-framemaker"}, {".man", "application/x-troff-man"}, {".map", "application/x-navimap"}, {".mar", "text/plain"}, {".mb", "application/mathematica"}, {".mbd", "application/mbedlet"}, {".mbm", "image/x-epoc-mbm"}, {".mc$", "application/x-magic-cap-package-1.0"}, {".mcd", "application/x-mathcad"}, {".mcf", "image/vasa"}, {".mcm", "chemical/x-macmolecule"}, {".mcp", "application/netmc"}, {".mct", "application/x-mascot"}, {".mdb", "application/msaccess"}, {".mdz", "audio/x-mod"}, {".me", "application/x-troff-me"}, {".med", "application/x-att-a2bmusic-pu"}, {".mes", "application/x-att-a2bmusic"}, {".mesh", "model/mesh"}, {".mht", "message/rfc822"}, {".mhtml", "message/rfc822"}, {".mi", "application/x-mif"}, {".mid", "audio/midi"}, {".midi", "audio/midi"}, {".mif", "application/x-mif"}, {".mil", "image/x-cals"}, {".mime", "www/mime"}, {".mio", "audio/x-mio"}, {".mjf", "audio/x-vnd.AudioExplosion.MjuiceMediaFile"}, {".mjpg", "video/x-motion-jpeg"}, {".ml5", "application/ml5"}, {".mm", "application/base64"}, {".mmd", "chemical/x-macromodel"}, {".mme", "application/base64"}, {".mmod", "chemical/x-macromodel-input"}, {".mmr", "image/vnd.fujixerox.edmics-mmr"}, {".mng", "video/x-mng"}, {".mny", "application/x-msmoney"}, {".moc", "application/x-mocha"}, {".mocha", "application/x-mocha"}, {".mod", "audio/mod"}, {".mof", "application/x-yumekara"}, {".mol", "chemical/x-mdl-molfile"}, {".moov", "video/quicktime"}, {".mop", "chemical/x-mopac-input"}, {".mov", "video/quicktime"}, {".movie", "video/x-sgi-movie"}, {".mp2", "video/mpeg"}, {".mp2a", "audio/x-mpeg2"}, {".mp2v", "video/x-mpeg2"}, {".mp3", "audio/mp3"}, {".mp3url", "", "audio/x-mpegurl"}, {".mpa", "video/mpeg"}, {".mpa2", "audio/x-mpeg2"}, {".mpc", "application/x-project"}, {".mpd", "application/vnd.ms-project"}, {".mpe", "video/mpeg"}, {".mpeg", "video/mpeg"}, {".mpf", "text/vnd.ms-mediapackage"}, {".mpg", "video/mpeg"}, {".mpga", "audio/mpeg"}, {".mpp", "application/vnd.ms-project"}, {".mps", "application/x-mapserver"}, {".mps", "video/x-mpeg-system"}, {".mpt", "application/vnd.ms-project"}, {".mpv", "video/mpeg"}, {".mpv2", "video/x-mpeg2"}, {".mpx", "application/x-project"}, {".mpy", "application/vnd.ibm.MiniPay"}, {".mrc", "application/marc"}, {".mrl", "text/x-mrml"}, {".ms", "application/x-troff-ms"}, {".msf", "application/vnd.epson.msf"}, {".msh", "model/mesh"}, {".msl", "application/vnd.Mobius.MSL"}, {".msm", "model/vnd.gdl"}, {".mss", "audio/mss"}, {".msv", "application/x-mystars-view"}, {".mts", "application/metastream"}, {".mus", "application/vnd.musician"}, {".mv", "video/x-sgi-movie"}, {".mwc", "application/vnd.dpgraph"}, {".mxs", "application/vnd.triscape.mxs"}, {".my", "audio/make"}, {".mzz", "application/x-vnd.AudioExplosion.mzz"}, {".nap", "image/naplps"}, {".naplps", "image/naplps"}, {".nb", "application/mathematica"}, {".nc", "application/x-netcdf"}, {".nclk", "text/html"}, {".ncm", "application/vnd.nokia.configuration-message"}, {".ndb", "x-lml/x-ndb"}, {".ndl", "application/vnd.lotus-notes"}, {".nif", "image/x-niff"}, {".niff", "image/x-niff"}, {".nix", "application/x-mix-transfer"}, {".nls", "text/nls"}, {".nml", "application/vnd.enliven"}, {".nmz", "application/x-scream"}, {".nnd", "application/vnd.noblenet-directory"}, {".nns", "application/vnd.noblenet-sealer"}, {".nnw", "application/vnd.noblenet-web"}, {".npx", "application/x-netfpx"}, {".ns2", "application/vnd.lotus-notes"}, {".ns3", "application/vnd.lotus-notes"}, {".ns4", "application/vnd.lotus-notes"}, {".nsc", "application/x-conference"}, {".nsf", "application/vnd.lotus-notes"}, {".nsg", "application/vnd.lotus-notes"}, {".nsh", "application/vnd.lotus-notes"}, {".ntf", "application/vnd.lotus-notes"}, {".nvd", "application/x-navidoc"}, {".nvm", "application/x-navimap"}, {".nws", "message/rfc822"}, {".o", "application/octet-stream"}, {".oa2", "application/vnd.fujitsu.oasys2"}, {".oa3", "application/vnd.fujitsu.oasys3"}, {".oas", "application/vnd.fujitsu.oasys"}, {".obd", "application/x-msbinder"}, {".oda", "application/oda"}, {".omc", "application/x-omc"}, {".omcd", "application/x-omcdatamaker"}, {".omcr", "application/x-omcregerator"}, {".or2", "application/vnd.lotus-organizer"}, {".or3", "application/vnd.lotus-organizer"}, {".org", "application/vnd.lotus-organizer"}, {".orq", "application/ocsp-request"}, {".ors", "application/ocsp-response"}, {".ota", "image/x-ota-bitmap"}, {".p", "text/x-pascal"}, {".p10", "application/pkcs10"}, {".p10", "application/x-pkcs10"}, {".p12", "application/pkcs-12"}, {".p12", "application/x-pkcs12"}, {".p7a", "application/x-pkcs7-signature"}, {".p7b", "application/x-pkcs7-certificates"}, {".p7c", "application/pkcs7-mime"}, {".p7c", "application/x-pkcs7-mime"}, {".p7m", "application/pkcs7-mime"}, {".p7m", "application/x-pkcs7-mime"}, {".p7r", "application/x-pkcs7-certreqresp"}, {".p7s", "application/pkcs7-signature"}, {".pac", "application/x-ns-proxy-autoconfig"}, {".pae", "audio/x-epac"}, {".pan", "application/x-pan"}, {".part", "application/pro_eng"}, {".pas", "text/pascal"}, {".pat", "audio/x-pat"}, {".pbd", "application/vnd.powerbuilder7"}, {".pbm", "image/x-portable-bitmap"}, {".pcd", "image/x-photo-cd"}, {".pcl", "application/x-pcl"}, {".pct", "image/x-pict"}, {".pcx", "image/x-pcx"}, {".pda", "image/x-pda"}, {".pdb", "chemical/x-pdb"}, {".pdf", "application/pdf"}, {".pfr", "application/font-tdpfr"}, {".pfunk", "audio/make"}, {".pfx", "application/x-pkcs12"}, {".pgm", "image/x-portable-graymap"}, {".pgn", "application/x-chess-pgn"}, {".pgp", "application/pgp-encrypted"}, {".pic", "image/pict"}, {".pict", "image/pict"}, {".pkg", "application/x-newton-compatible-pkg"}, {".pki", "application/pkixcmp"}, {".pko", "application/vnd.ms-pki.pko"}, {".pl", "text/x-script.perl"}, {".plc", "application/vnd.Mobius.PLC"}, {".plg", "text/html"}, {".plj", "audio/vnd.everad.plj"}, {".pls", "audio/mpegurl"}, {".plx", "application/x-PiXCLscript"}, {".pm", "text/x-script.perl-module"}, {".pm4", "application/x-pagemaker"}, {".pm5", "application/x-pagemaker"}, {".pml", "application/vnd.ctc-posml"}, {".png", "image/png"}, {".pnm", "image/x-portable-anymap"}, {".pot", "application/mspowerpoint"}, {".pov", "model/x-pov"}, {".ppa", "application/vnd.ms-powerpoint"}, {".ppm", "image/x-portable-pixmap"}, {".pps", "application/mspowerpoint"}, {".ppt", "application/mspowerpoint"}, {".ppz", "application/mspowerpoint"}, {".pqf", "application/x-cprplayer"}, {".pqi", "application/cprplayer"}, {".pre", "application/x-freelance"}, {".prf", "application/pics-rules"}, {".proxy", "application/x-ns-proxy-autoconfig"}, {".prt", "application/pro_eng"}, {".prz", "application/vnd.lotus-freelance"}, {".ps", "application/postscript"}, {".psd", "application/octet-stream"}, {".pseg3820", "application/vnd.ibm.modcap"}, {".psid", "audio/prs.sid"}, {".pti", "image/prs.pti"}, {".ptlk", "application/listenup"}, {".pub", "application/x-mspublisher"}, {".puz", "application/x-crossword"}, {".pvu", "paleovu/x-pv"}, {".pwn", "application/vnd.3M.Post-it-Notes"}, {".pwz", "application/vnd.ms-powerpoint"}, {".py", "text/x-script.phyton"}, {".pyc", "applicaiton/x-bytecode.python"}, {".qam", "application/vnd.epson.quickanime"}, {".qbo", "application/vnd.intu.qbo"}, {".qca", "application/vnd.ericsson.quickcall"}, {".qcall", "application/vnd.ericsson.quickcall"}, {".qcp", "audio/vnd.qcelp"}, {".qd3", "x-world/x-3dmf"}, {".qd3d", "x-world/x-3dmf"}, {".qfx", "application/vnd.intu.qfx"}, {".qif", "image/x-quicktime"}, {".qps", "application/vnd.publishare-delta-tree"}, {".qry", "text/html"}, {".qt", "video/quicktime"}, {".qtc", "video/x-qtc"}, {".qti", "image/x-quicktime"}, {".qtif", "image/x-quicktime"}, {".qtvr", "video/quicktime"}, {".r3t", "text/vnd.rn-realtext3d"}, {".ra", "audio/x-pn-realaudio"}, {".ram", "audio/x-pn-realaudio"}, {".rar", "application/rar"}, {".ras", "image/cmu-raster"}, {".rast", "image/cmu-raster"}, {".rb", "application/x-rocketbook"}, {".rct", "application/prs.nprend"}, {".rep", "application/vnd.businessobjects"}, {".rexx", "text/x-script.rexx"}, {".rf", "image/vnd.rn-realflash"}, {".rgb", "image/x-rgb"}, {".rjs", "application/vnd.rn-realsystem-rjs"}, {".rlc", "image/vnd.fujixerox.edmics-rlc"}, {".rlf", "application/x-richlink"}, {".rm", "audio/x-pn-realaudio"}, {".rmi", "audio/mid"}, {".rmm", "audio/x-pn-realaudio"}, {".rmp", "audio/x-pn-realaudio"}, {".rmx", "application/vnd.rn-realsystem-rmx"}, {".rnd", "application/prs.nprend"}, {".rng", "application/ringing-tones"}, {".rnx", "application/vnd.rn-realplayer"}, {".roff", "application/x-troff"}, {".rp", "image/vnd.rn-realpix"}, {".rpm", "application/x-pn-realaudio"}, {".rsm", "model/vnd.gdl"}, {".rsml", "application/vnd.rn-rsml"}, {".rt", "text/richtext"}, {".rte", "x-lml/x-gps"}, {".rtf", "application/rtf"}, {".rtg", "application/metastream"}, {".rts", "application/x-rtsl"}, {".rtx", "application/rtf"}, {".rv", "video/vnd.rn-realvideo"}, {".rxn", "chemical/x-mdl-rxn"}, {".s", "text/x-asm"}, {".s3m", "audio/s3m"}, {".s3z", "audio/x-mod"}, {".sam", "application/vnd.lotus-wordpro"}, {".saveme", "application/octet-stream"}, {".sbk", "application/x-tbook"}, {".sc", "application/x-showcase"}, {".scd", "application/x-msschedule"}, {".scm", "text/x-script.scheme"}, {".scp", "text/plain"}, {".sct", "text/scriptlet"}, {".sdf", "application/e-score"}, {".sdml", "text/plain"}, {".sdp", "application/sdp"}, {".sdr", "application/sounder"}, {".sds", "application/x-onlive"}, {".sea", "application/x-stuffit"}, {".see", "application/vnd.seemail"}, {".ser", "application/x-java-serialized-object"}, {".set", "application/set"}, {".sgi-lpr", "application/x-sgi-lpr"}, {".sgm", "text/sgml"}, {".sgml", "text/sgml"}, {".sh", "application/x-sh"}, {".sha", "application/x-shar"}, {".shar", "application/x-shar"}, {".sho", "application/x-showcase"}, {".show", "application/x-showcase"}, {".showcase", "application/x-showcase"}, {".shtml", "text/x-server-parsed-html"}, {".shw", "application/presentations"}, {".si", "text/vnd.wap.si"}, {".sic", "application/vnd.wap.sic"}, {".sid", "audio/x-psid"}, {".silo", "model/mesh"}, {".sis", "application/vnd.symbian.install"}, {".sit", "application/x-stuffit"}, {".skc", "chemical/x-mdl-isis"}, {".skd", "application/x-koan"}, {".skm", "application/x-koan"}, {".skp", "application/x-koan"}, {".skt", "application/x-koan"}, {".sl", "application/x-seelogo"}, {".slc", "application/x-salsa"}, {".slides", "application/x-showcase"}, {".slt", "application/vnd.epson.salt"}, {".smd", "chemical/x-smd"}, {".smi", "application/smil"}, {".smil", "application/smil"}, {".smp", "application/studiom"}, {".snd", "audio/basic"}, {".sol", "application/solids"}, {".spc", "application/x-pkcs7-certificates"}, {".spl", "application/futuresplash"}, {".spo", "text/vnd.in3d.spot"}, {".spot", "text/vnd.in3d.spot"}, {".spr", "application/x-sprite"}, {".sprite", "application/x-sprite"}, {".spt", "application/x-spt"}, {".src", "application/x-wais-source"}, {".ssi", "text/x-server-parsed-html"}, {".ssm", "application/streamingmedia"}, {".sst", "application/vnd.ms-pki.certstore"}, {".step", "application/step"}, {".stf", "application/vnd.wt.stf"}, {".stk", "application/hyperstudio"}, {".stl", "application/sla"}, {".stp", "application/step"}, {".str", "audio/x-str"}, {".sv4cpio", "application/x-sv4cpio"}, {".sv4crc", "application/x-sv4crc"}, {".svf", "image/vnd"}, {".svg", "image/svg-xml"}, {".svh", "image/svh"}, {".svr", "application/x-world"}, {".swf", "application/x-shockwave-flash"}, {".swfl", "application/x-shockwave-flash"}, {".sys", "video/x-mpeg-system"}, {".t", "application/x-troff"}, {".tad", "application/octet-stream"}, {".tag", "text/prs.lines.tag"}, {".talk", "x-plugin/x-talker"}, {".tar", "application/x-tar"}, {".tardist", "application/x-tardist"}, {".taz", "application/x-tar"}, {".tbk", "application/toolbook"}, {".tbp", "application/x-timbuktu"}, {".tbt", "application/timbuktu"}, {".tcl", "text/x-script.tcl"}, {".tcsh", "text/x-script.tcsh"}, {".tex", "application/x-tex"}, {".texi", "application/x-texinfo"}, {".texinfo", "application/x-texinfo"}, {".text", "text/plain"}, {".tgf", "chemical/x-mdl-tgf"}, {".tgz", "application/x-tar"}, {".tif", "image/tiff"}, {".tiff", "image/tiff"}, {".tki", "application/x-tkined"}, {".tkined", "application/x-tkined"}, {".toc", "application/toc"}, {".tpl", "application/vnd.groove-tool-template"}, {".tr", "application/x-troff"}, {".tra", "application/vnd.trueapp"}, {".trk", "x-lml/x-gps"}, {".trm", "application/x-msterminal"}, {".tsi", "audio/tsp-audio"}, {".tsp", "audio/tsplayer"}, {".tsv", "text/tab-separated-values"}, {".ttf", "application/octet-stream"}, {".ttz", "application/t-time"}, {".turbot", "image/florian"}, {".tvm", "application/x-tvml"}, {".tvml", "application/x-tvml"}, {".txf", "application/vnd.Mobius.TXF"}, {".txt", "text/plain"}, {".ufdl", "application/vnd.ufdl"}, {".uil", "text/x-uil"}, {".uni", "text/uri-list"}, {".unis", "text/uri-list"}, {".unv", "application/i-deas"}, {".uri", "text/uri-list"}, {".urls", "application/x-url-list"}, {".ustar", "multipart/x-ustar"}, {".uu", "text/x-uuencode"}, {".uue", "text/x-uuencode"}, {".v5d", "application/vis5d"}, {".vbk", "audio/vnd.nortel.vbk"}, {".vbox", "application/vnd.previewsystems.box"}, {".vcd", "application/x-cdlink"}, {".vcf", "text/x-vcard"}, {".vcg", "application/vnd.groove-vcard"}, {".vcs", "text/x-vCalendar"}, {".vcx", "application/vnd.vcx"}, {".vda", "application/vda"}, {".vdo", "video/vdo"}, {".vew", "application/groupwise"}, {".vis", "application/vnd.informix-visionary"}, {".viv", "video/vivo"}, {".vivo", "video/vivo"}, {".vmd", "application/vocaltec-media-desc"}, {".vmf", "application/vocaltec-media-file"}, {".vmi", "application/x-dremacast-vms-info"}, {".vms", "application/x-dremacast-vms"}, {".voc", "audio/voc"}, {".vos", "video/vosaic"}, {".vox", "audio/voxware"}, {".vqe", "audio/x-twinvq-plugin"}, {".vqf", "audio/x-twinvq"}, {".vql", "audio/x-twinvq"}, {".vre", "x-world/x-vream"}, {".vrj", "x-world/x-vrt"}, {".vrml", "model/vrml"}, {".vrt", "x-world/x-vrt"}, {".vrw", "x-world/x-vream"}, {".vsd", "application/x-visio"}, {".vsl", "application/x-cnet-vsl"}, {".vss", "application/vnd.visio"}, {".vst", "application/x-visio"}, {".vsw", "application/x-visio"}, {".vts", "workbook/formulaone"}, {".vtu", "model/vnd.vtu"}, {".w60", "application/wordperfect6.0"}, {".w61", "application/wordperfect6.1"}, {".w6w", "application/msword"}, {".wav", "audio/wav"}, {".wax", "audio/x-ms-wax"}, {".wb1", "application/x-qpro"}, {".wbc", "application/x-webshots"}, {".wbmp", "image/vnd.wap.wbmp"}, {".wbxml", "application/vnd.wap.wbxml"}, {".web", "application/vnd.xara"}, {".wi", "image/wavelet"}, {".win", "model/vnd.gdl"}, {".wiz", "application/msword"}, {".wk1", "application/x-123"}, {".wk3", "application/vnd.lotus-1-2-3"}, {".wk4", "application/vnd.lotus-1-2-3"}, {".wkz", "application/x-wingz"}, {".wm", "video/x-ms-asf"}, {".wma", "audio/x-ms-wma"}, {".wmf", "image/x-wmf"}, {".wml", "text/vnd.wap.wml"}, {".wmlc", "application/vnd.wap.wmlc"}, {".wmls", "text/vnd.wap.wmlscript"}, {".wmlsc", "application/vnd.wap.wmlscriptc"}, {".wmv", "video/x-ms-wmv"}, {".wmx", "video/x-ms-wmx"}, {".word", "application/msword"}, {".wp", "application/wordperfect"}, {".wp5", "application/wordperfect"}, {".wp6", "application/wordperfect"}, {".wpd", "application/wordperfect"}, {".wpt", "x-lml/x-gps"}, {".wq1", "application/x-lotus"}, {".wri", "application/mswrite"}, {".wrl", "model/vrml"}, {".wrz", "model/vrml"}, {".wsc", "text/sgml"}, {".wsrc", "application/x-wais-source"}, {".wtb", "application/vnd.webturbo"}, {".wtk", "application/x-wintalk"}, {".wtx", "text/plain"}, {".wv", "video/wavelet"}, {".wvx", "video/x-ms-wvx"}, {".wxl", "application/x-wxl"}, {".x-png", "image/png"}, {".x12", "application/EDI-X12"}, {".x3d", "application/vnd.hzn-3d-crossword"}, {".xar", "application/vnd.xara"}, {".xbd", "application/vnd.fujixerox.docuworks.binder"}, {".xbm", "image/x-xbitmap"}, {".xdm", "application/x-xdma"}, {".xdma", "application/x-xdma"}, {".xdr", "video/x-amt-demorun"}, {".xdw", "application/vnd.fujixerox.docuworks"}, {".xfdl", "application/vnd.xfdl"}, {".xgz", "xgl/drawing"}, {".xif", "image/vnd.xiff"}, {".xl", "application/excel"}, {".xla", "application/excel"}, {".xlb", "application/excel"}, {".xlc", "application/excel"}, {".xld", "application/excel"}, {".xlk", "application/excel"}, {".xll", "application/excel"}, {".xlm", "application/excel"}, {".xls", "application/excel"}, {".xlt", "application/excel"}, {".xlv", "application/excel"}, {".xlw", "application/excel"}, {".xm", "audio/xm"}, {".xml", "application/xml"}, {".xml", "text/xml"}, {".xmz", "audio/x-mod"}, {".xpix", "application/x-vnd.ls-xpix"}, {".xpm", "image/x-xpixmap"}, {".xpr", "application/vnd.is-xpr"}, {".xpw", "application/vnd.intercon.formnet"}, {".xpx", "application/vnd.intercon.formnet"}, {".xsl", "text/xsl"}, {".xsr", "video/x-amt-showrun"}, {".xul", "text/xul"}, {".xwd", "image/x-xwd"}, {".xyz", "chemical/x-xyz"}, {".zac", "application/x-zaurus-zac"}, {".zip", "application/zip"}, {".zoo", "application/octet-stream"}, {".zsh", "text/x-script.zsh"}, {".ztardist", "application/x-ztardist"}};
        MIME_TYPE_TO_FILE_EXTENSION = new String[][]{{"applicaiton/x-bytecode.python", ".pyc"}, {"application/andrew-inset", ".ez"}, {"application/astound", ".asd"}, {"application/autocad", ".dwg"}, {"application/base64", ".mme"}, {"application/binhex", ".hqx"}, {"application/bld", ".bld"}, {"application/bld2", ".bld2"}, {"application/book", ".book"}, {"application/bsi-gtp", ".gtp"}, {"application/cdf", ".cdf"}, {"application/clariscad", ".ccad"}, {"application/commonground", ".dp"}, {"application/cprplayer", ".pqi"}, {"application/drafting", ".drw"}, {"application/EDIFACT", ".edi"}, {"application/EDI-X12", ".x12"}, {"application/envoy", ".evy"}, {"application/e-score", ".sdf"}, {"application/excel", ".xls"}, {"application/fastman", ".lcc"}, {"application/filemaker5", ".fp5"}, {"application/file-mirror-list", ".fml"}, {"application/font-tdpfr", ".pfr"}, {"application/freeloader", ".frl"}, {"application/futuresplash", ".spl"}, {"application/groupwise", ".vew"}, {"application/hta", ".hta"}, {"application/hyperstudio", ".stk"}, {"application/i-deas", ".unv"}, {"application/iges", ".igs"}, {"application/immedia", ".imd"}, {"application/inf", ".inf"}, {"application/jwc", ".jwc"}, {"application/lgh", ".lgh"}, {"application/listenup", ".ptlk"}, {"application/lotus", ".123"}, {"application/mac-compactpro", ".cpt"}, {"application/marc", ".mrc"}, {"application/mathematica", ".ma"}, {"application/mbedlet", ".mbd"}, {"application/metastream", ".mts"}, {"application/mime", ".aps"}, {"application/ml5", ".ml5"}, {"application/msaccess", ".mdb"}, {"application/mspowerpoint", ".ppt"}, {"application/msword", ".doc"}, {"application/mswrite", ".wri"}, {"application/netmc", ".mcp"}, {"application/ocsp-request", ".orq"}, {"application/ocsp-response", ".ors"}, {"application/octet-stream", ".bin"}, {"application/oda", ".oda"}, {"application/pdf", ".pdf"}, {"application/pgp-encrypted", ".pgp"}, {"application/pics-rules", ".prf"}, {"application/pkcs10", ".p10"}, {"application/pkcs-12", ".p12"}, {"application/pkcs7-mime", ".p7m"}, {"application/pkcs7-signature", ".p7s"}, {"application/pkcs-crl", ".crl"}, {"application/pkixcmp", ".pki"}, {"application/postscript", ".ps"}, {"application/presentations", ".shw"}, {"application/pro_eng", ".prt"}, {"application/prs.cww", ".cww"}, {"application/prs.nprend", ".rnd"}, {"application/rar", ".rar"}, {"application/ringing-tones", ".rng"}, {"application/rtf", ".rtf"}, {"application/sdp", ".sdp"}, {"application/set", ".set"}, {"application/sla", ".stl"}, {"application/smil", ".smil"}, {"application/solids", ".sol"}, {"application/sounder", ".sdr"}, {"application/step", ".stp"}, {"application/streamingmedia", ".ssm"}, {"application/studiom", ".smp"}, {"application/timbuktu", ".tbt"}, {"application/toc", ".toc"}, {"application/toolbook", ".tbk"}, {"application/t-time", ".ttz"}, {"application/vda", ".vda"}, {"application/vis5d", ".v5d"}, {"application/vnd.3M.Post-it-Notes", ".pwn"}, {"application/vnd.accpac.simply.aso", ".aso"}, {"application/vnd.accpac.simply.imp", ".imp"}, {"application/vnd.acucobol", ".acu"}, {"application/vnd.anser-web-certificate-issue-initiation", ".cii"}, {"application/vnd.anser-web-funds-transfer-initiation", ".fti"}, {"application/vnd.audiograph", ".aep"}, {"application/vnd.bmi", ".bmi"}, {"application/vnd.businessobjects", ".rep"}, {"application/vnd.claymore", ".cla"}, {"application/vnd.commerce-battelle", ".icf"}, {"application/vnd.commonspace", ".csp"}, {"application/vnd.cosmocaller", ".cmc"}, {"application/vnd.ctc-posml", ".pml"}, {"application/vnd.dna", ".dna"}, {"application/vnd.dpgraph", ".dpg"}, {"application/vnd.ecowin.chart", ".mag"}, {"application/vnd.enliven", ".nml"}, {"application/vnd.epson.msf", ".msf"}, {"application/vnd.epson.quickanime", ".qam"}, {"application/vnd.epson.salt", ".slt"}, {"application/vnd.ericsson.quickcall", ".qca"}, {"application/vnd.fdf", ".fdf"}, {"application/vnd.FloGraphIt", ".gph"}, {"application/vnd.fujitsu.oasys", ".oas"}, {"application/vnd.fujitsu.oasys2", ".oa2"}, {"application/vnd.fujitsu.oasys3", ".oa3"}, {"application/vnd.fujitsu.oasysgp", ".fg5"}, {"application/vnd.fujitsu.oasysprs", ".bh2"}, {"application/vnd.fujixerox.ddd", ".ddd"}, {"application/vnd.fujixerox.docuworks", ".xdw"}, {"application/vnd.fujixerox.docuworks.binder", ".xbd"}, {"application/vnd.grafeq", ".gqf"}, {"application/vnd.groove-account", ".gac"}, {"application/vnd.groove-identity-message", ".gim"}, {"application/vnd.groove-injector", ".grv"}, {"application/vnd.groove-tool-message", ".gtm"}, {"application/vnd.groove-tool-template", ".tpl"}, {"application/vnd.groove-vcard", ".vcg"}, {"application/vnd.hp-HPGL", ".hgl"}, {"application/vnd.hp-hpid", ".hpi"}, {"application/vnd.hp-hps", ".hps"}, {"application/vnd.hzn-3d-crossword", ".x3d"}, {"application/vnd.ibm.MiniPay", ".mpy"}, {"application/vnd.ibm.modcap", ".afp"}, {"application/vnd.informix-visionary", ".vis"}, {"application/vnd.intercon.formnet", ".xpw"}, {"application/vnd.intu.qbo", ".qbo"}, {"application/vnd.intu.qfx", ".qfx"}, {"application/vnd.is-xpr", ".xpr"}, {"application/vnd.lotus-1-2-3", ".wk4"}, {"application/vnd.lotus-approach", ".apr"}, {"application/vnd.lotus-freelance", ".prz"}, {"application/vnd.lotus-notes", ".nsf"}, {"application/vnd.lotus-organizer", ".org"}, {"application/vnd.lotus-wordpro", ".lwp"}, {"application/vnd.mediastation.cdkey", ".cdkey"}, {"application/vnd.Mobius.DAF", ".daf"}, {"application/vnd.Mobius.DIS", ".dis"}, {"application/vnd.Mobius.MSL", ".msl"}, {"application/vnd.Mobius.PLC", ".plc"}, {"application/vnd.Mobius.TXF", ".txf"}, {"application/vnd.ms-pki.certstore", ".sst"}, {"application/vnd.ms-pki.pko", ".pko"}, {"application/vnd.ms-pki.seccat", ".cat"}, {"application/vnd.ms-powerpoint", ".ppa"}, {"application/vnd.ms-project", ".mpp"}, {"application/vnd.musician", ".mus"}, {"application/vnd.noblenet-directory", ".nnd"}, {"application/vnd.noblenet-sealer", ".nns"}, {"application/vnd.noblenet-web", ".nnw"}, {"application/vnd.nokia.configuration-message", ".ncm"}, {"application/vnd.novadigm.EDM", ".edm"}, {"application/vnd.novadigm.EDX", ".edx"}, {"application/vnd.novadigm.EXT", ".ext"}, {"application/vnd.pg.osasli", ".ei6"}, {"application/vnd.powerbuilder7", ".pbd"}, {"application/vnd.previewsystems.box", ".box"}, {"application/vnd.publishare-delta-tree", ".qps"}, {"application/vnd.rn-realplayer", ".rnx"}, {"application/vnd.rn-realsystem-rjs", ".rjs"}, {"application/vnd.rn-realsystem-rmx", ".rmx"}, {"application/vnd.rn-rsml", ".rsml"}, {"application/vnd.seemail", ".see"}, {"application/vnd.shana.informed.formdata", ".ifm"}, {"application/vnd.shana.informed.formtemp", ".itp"}, {"application/vnd.shana.informed.package", ".ipk"}, {"application/vnd.symbian.install", ".sis"}, {"application/vnd.triscape.mxs", ".mxs"}, {"application/vnd.trueapp", ".tra"}, {"application/vnd.ufdl", ".ufdl"}, {"application/vnd.vcx", ".vcx"}, {"application/vnd.visio", ".vss"}, {"application/vnd.wap.sic", ".sic"}, {"application/vnd.wap.wbxml", ".wbxml"}, {"application/vnd.wap.wmlc", ".wmlc"}, {"application/vnd.wap.wmlscriptc", ".wmlsc"}, {"application/vnd.webturbo", ".wtb"}, {"application/vnd.wt.stf", ".stf"}, {"application/vnd.xara", ".web"}, {"application/vnd.xara", ".xar"}, {"application/vnd.xfdl", ".xfdl"}, {"application/vnd.yellowriver-custom-menu", ".cmp"}, {"application/vocaltec-media-desc", ".vmd"}, {"application/vocaltec-media-file", ".vmf"}, {"application/winhlp", ".hlp"}, {"application/wordperfect", ".wp"}, {"application/x-123", ".wk1"}, {"application/x-aim", ".aim"}, {"application/x-annotator", ".ano"}, {"application/x-att-a2bmusic", ".mes"}, {"application/x-att-a2bmusic-pu", ".med"}, {"application/x-authorware-bin", ".aab"}, {"application/x-authorware-map", ".aam"}, {"application/x-authorware-seg", ".aas"}, {"application/x-bcpio", ".bcpio"}, {"application/x-bsh", ".bsh"}, {"application/x-bytecode.elisp", ".elc"}, {"application/x-bzip", ".bz"}, {"application/x-bzip2", ".bz2"}, {"application/x-cdlink", ".vcd"}, {"application/x-chat", ".cha"}, {"application/x-chess-pgn", ".pgn"}, {"application/x-cnc", ".ccn"}, {"application/x-cnet-vsl", ".vsl"}, {"application/x-cocoa", ".cco"}, {"application/x-compress", ".Z"}, {"application/x-conference", ".nsc"}, {"application/x-cpio", ".cpio"}, {"application/x-cprplayer", ".pqf"}, {"application/x-crossword", ".puz"}, {"application/x-deepv", ".deepv"}, {"application/x-digitalloca", ".lcl"}, {"application/x-director", ".dir"}, {"application/x-dremacast-vms", ".vms"}, {"application/x-dremacast-vms-info", ".vmi"}, {"application/x-dvi", ".dvi"}, {"application/x-earthtime", ".etc"}, {"application/x-enterlicense", ".lic"}, {"application/x-envoy", ".env"}, {"application/x-epublisher", ".epb"}, {"application/x-expandedbook", ".ebk"}, {"application/x-fax-manager", ".faxmgr"}, {"application/x-fax-manager-job", ".faxmgrjob"}, {"application/x-framemaker", ".fm"}, {"application/x-freelance", ".pre"}, {"application/x-gps", ".gps"}, {"application/x-gsp", ".gsp"}, {"application/x-gss", ".gss"}, {"application/x-gtar", ".gtar"}, {"application/x-gzip", ".gz"}, {"application/x-hdf", ".hdf"}, {"application/x-helpfile", ".help"}, {"application/x-httpd-imap", ".imap"}, {"application/x-ima", ".ima"}, {"application/x-insight", ".insight"}, {"application/x-install", ".inst"}, {"application/x-internet-signup", ".isp"}, {"application/x-inventor", ".iv"}, {"application/x-ip2", ".ip"}, {"application/x-iphone", ".iii"}, {"application/x-ipix", ".ipx"}, {"application/x-ipscript", ".ips"}, {"application/x-java-archive", ".jar"}, {"application/x-java-class", ".class"}, {"application/x-java-commerce", ".jcm"}, {"application/x-javascript", ".js"}, {"application/x-java-serialized-object", ".ser"}, {"application/x-koan", ".skt"}, {"application/x-ksh", ".ksh"}, {"application/x-latex", ".ltx"}, {"application/x-licensemgr", ".licmgr"}, {"application/x-livescreen", ".ivy"}, {"application/x-lotus", ".wq1"}, {"application/x-magic-cap-package-1.0", ".mc$"}, {"application/x-mailfolder", ".mail"}, {"application/x-mapserver", ".mps"}, {"application/x-mascot", ".mct"}, {"application/x-mathcad", ".mcd"}, {"application/x-mif", ".mif"}, {"application/x-mix-transfer", ".nix"}, {"application/xml", ".xml"}, {"application/x-mocha", ".moc"}, {"application/x-msbinder", ".obd"}, {"application/x-mscardfile", ".crd"}, {"application/x-msclip", ".clp"}, {"application/x-msdownload", ".dll"}, {"application/x-msmediaview", ".m14"}, {"application/x-msmoney", ".mny"}, {"application/x-mspublisher", ".pub"}, {"application/x-msschedule", ".scd"}, {"application/x-msterminal", ".trm"}, {"application/x-mystars-view", ".msv"}, {"application/x-navi-animation", ".ani"}, {"application/x-navidoc", ".nvd"}, {"application/x-navimap", ".nvm"}, {"application/x-netcdf", ".nc"}, {"application/x-netfpx", ".npx"}, {"application/x-NET-Install", ".ins"}, {"application/x-newton-compatible-pkg", ".pkg"}, {"application/x-nokia-9000-communicator-add-on-software", ".aos"}, {"application/x-ns-proxy-autoconfig", ".proxy"}, {"application/x-omc", ".omc"}, {"application/x-omcdatamaker", ".omcd"}, {"application/x-omcregerator", ".omcr"}, {"application/x-onlive", ".sds"}, {"application/x-pagemaker", ".pm5"}, {"application/x-pan", ".pan"}, {"application/x-pcl", ".pcl"}, {"application/x-PiXCLscript", ".plx"}, {"application/x-pkcs10", ".p10"}, {"application/x-pkcs12", ".p12"}, {"application/x-pkcs7-certificates", ".p7b"}, {"application/x-pkcs7-certreqresp", ".p7r"}, {"application/x-pkcs7-mime", ".p7m"}, {"application/x-pkcs7-signature", ".p7a"}, {"application/x-pn-realaudio", ".rpm"}, {"application/x-project", ".mpc"}, {"application/x-qpro", ".wb1"}, {"application/x-richlink", ".rlf"}, {"application/x-rocketbook", ".rb"}, {"application/x-rtsl", ".rts"}, {"application/x-salsa", ".slc"}, {"application/x-scream", ".nmz"}, {"application/x-seelogo", ".sl"}, {"application/x-sgi-lpr", ".sgi-lpr"}, {"application/x-sh", ".sh"}, {"application/x-shar", ".sha"}, {"application/x-shockwave-flash", ".swf"}, {"application/x-showcase", ".sc"}, {"application/x-sprite", ".spr"}, {"application/x-spt", ".spt"}, {"application/x-stuffit", ".sit"}, {"application/x-sv4cpio", ".sv4cpio"}, {"application/x-sv4crc", ".sv4crc"}, {"application/x-tar", ".tar"}, {"application/x-tardist", ".tardist"}, {"application/x-tbook", ".sbk"}, {"application/x-tex", ".tex"}, {"application/x-texinfo", ".texi"}, {"application/x-timbuktu", ".tbp"}, {"application/x-tkined", ".tki"}, {"application/x-troff", ".tr"}, {"application/x-troff-man", ".man"}, {"application/x-troff-me", ".me"}, {"application/x-troff-ms", ".ms"}, {"application/x-tvml", ".tvm"}, {"application/x-url-list", ".urls"}, {"application/x-visio", ".vsd"}, {"application/x-vnd.AudioExplosion.mzz", ".mzz"}, {"application/x-vnd.ls-xpix", ".xpix"}, {"application/x-wais-source", ".src"}, {"application/x-webshots", ".wbc"}, {"application/x-wingz", ".wkz"}, {"application/x-wintalk", ".wtk"}, {"application/x-world", ".svr"}, {"application/x-wxl", ".wxl"}, {"application/x-x509-ca-cert", ".cer"}, {"application/x-x509-user-cert", ".crt"}, {"application/x-xdma", ".xdm"}, {"application/x-yumekara", ".mof"}, {"application/x-zaurus-zac", ".zac"}, {"application/x-ztardist", ".ztardist"}, {"application/zip", ".zip"}, {"audio/basic", ".snd"}, {"audio/echospeech", ".es"}, {"audio/make", ".my"}, {"audio/mid", ".rmi"}, {"audio/midi", ".mid"}, {"audio/mod", ".mod"}, {"audio/mp3", ".mp3"}, {"audio/mpeg", ".mpga"}, {"audio/mpegurl", ".m3u"}, {"audio/mss", ".mss"}, {"audio/nspaudio", ".la"}, {"audio/prs.sid", ".psid"}, {"audio/s3m", ".s3m"}, {"audio/tsp-audio", ".tsi"}, {"audio/tsplayer", ".tsp"}, {"audio/vnd.digital-winds", ".eol"}, {"audio/vnd.everad.plj", ".plj"}, {"audio/vnd.lucent.voice", ".lvp"}, {"audio/vnd.nortel.vbk", ".vbk"}, {"audio/vnd.nuera.ecelp4800", ".ecelp4800"}, {"audio/vnd.nuera.ecelp7470", ".ecelp7470"}, {"audio/vnd.qcelp", ".qcp"}, {"audio/voc", ".voc"}, {"audio/voxware", ".vox"}, {"audio/wav", ".wav"}, {"audio/x-aiff", ".aif"}, {"audio/x-au", ".au"}, {"audio/x-epac", ".pae"}, {"audio/x-gsm", ".gsm"}, {"audio/x-jam", ".jam"}, {"audio/x-liveaudio", ".lam"}, {"audio/xm", ".xm"}, {"audio/x-mio", ".mio"}, {"audio/x-mod", ".mdz"}, {"audio/x-mpeg2", ".mp2a"}, {"audio/x-mpegurl", ".mp3url"}, {"audio/x-ms-wax", ".wax"}, {"audio/x-ms-wma", ".wma"}, {"audio/x-pat", ".pat"}, {"audio/x-pn-realaudio", ".ra"}, {"audio/x-psid", ".sid"}, {"audio/x-str", ".str"}, {"audio/x-twinvq", ".vqf"}, {"audio/x-twinvq-plugin", ".vqe"}, {"audio/x-vnd.AudioExplosion.MjuiceMediaFile", ".mjf"}, {"chemical/x-chem3d", ".cdx"}, {"chemical/x-chemdraw", ".chm"}, {"chemical/x-cif", ".cif"}, {"chemical/x-cmdf", ".cmdf"}, {"chemical/x-cml", ".cml"}, {"chemical/x-csml", ".csm"}, {"chemical/x-embl-dl-nucleotide", ".emb"}, {"chemical/x-gaussian-cube", ".cub"}, {"chemical/x-gaussian-input", ".gau"}, {"chemical/x-isostar", ".ist"}, {"chemical/x-jcamp-dx", ".jdx"}, {"chemical/x-kinemage", ".kin"}, {"chemical/x-macmolecule", ".mcm"}, {"chemical/x-macromodel", ".mmd"}, {"chemical/x-macromodel-input", ".mmod"}, {"chemical/x-mdl-isis", ".skc"}, {"chemical/x-mdl-molfile", ".mol"}, {"chemical/x-mdl-rxn", ".rxn"}, {"chemical/x-mdl-tgf", ".tgf"}, {"chemical/x-mopac-input", ".mop"}, {"chemical/x-pdb", ".pdb"}, {"chemical/x-smd", ".smd"}, {"chemical/x-synopsys-accord", ".acc"}, {"chemical/x-xyz", ".xyz"}, {"drawing/x-dwf", ".dwf"}, {"image/bitmap", ".bmp"}, {"image/bmp", ".bm"}, {"image/cgm", ".cgm"}, {"image/cis-cod", ".cod"}, {"image/cmu-raster", ".ras"}, {"image/fif", ".fif"}, {"image/florian", ".flo"}, {"image/g3fax", ".g3"}, {"image/gif", ".gif"}, {"image/ief", ".ief"}, {"image/ifs", ".ifs"}, {"image/jpeg", ".jpg"}, {"image/jutvision", ".jut"}, {"image/naplps", ".nap"}, {"image/naplps", ".naplps"}, {"image/pict", ".pic"}, {"image/png", ".png"}, {"image/prs.btif", ".btf"}, {"image/prs.pti", ".pti"}, {"image/svg-xml", ".svg"}, {"image/svh", ".svh"}, {"image/tiff", ".tif"}, {"image/vasa", ".mcf"}, {"image/vnd", ".svf"}, {"image/vnd.fastbidsheet", ".fbs"}, {"image/vnd.fst", ".fst"}, {"image/vnd.fujixerox.edmics-mmr", ".mmr"}, {"image/vnd.fujixerox.edmics-rlc", ".rlc"}, {"image/vnd.rn-realflash", ".rf"}, {"image/vnd.rn-realpix", ".rp"}, {"image/vnd.wap.wbmp", ".wbmp"}, {"image/vnd.xiff", ".xif"}, {"image/wavelet", ".wi"}, {"image/x-cals", ".cal"}, {"image/x-cmx", ".cmx"}, {"image/x-dcx", ".dcx"}, {"image/x-dxf", ".dxf"}, {"image/x-epoc-mbm", ".mbm"}, {"image/x-fpx", ".fpx"}, {"image/x-freehand", ".fh"}, {"image/x-icon", ".ico"}, {"image/x-jg", ".art"}, {"image/x-jps", ".jps"}, {"image/x-niff", ".nif"}, {"image/x-ota-bitmap", ".ota"}, {"image/x-pcx", ".pcx"}, {"image/x-pda", ".pda"}, {"image/x-photo-cd", ".pcd"}, {"image/x-pict", ".pct"}, {"image/x-portable-anymap", ".pnm"}, {"image/x-portable-bitmap", ".pbm"}, {"image/x-portable-graymap", ".pgm"}, {"image/x-portable-pixmap", ".ppm"}, {"image/x-quicktime", ".qti"}, {"image/x-rgb", ".rgb"}, {"image/x-wmf", ".wmf"}, {"image/x-xbitmap", ".xbm"}, {"image/x-xpixmap", ".xpm"}, {"image/x-xwd", ".xwd"}, {"i-world/i-vrml", ".ivr"}, {"magnus-internal/cgi", ".cgi"}, {"message/rfc822", ".mht"}, {"model/iges", ".igs"}, {"model/mesh", ".msh"}, {"model/vnd.gdl", ".gdl"}, {"model/vnd.gtw", ".gtw"}, {"model/vnd.vtu", ".vtu"}, {"model/vrml", ".vrml"}, {"model/x-pov", ".pov"}, {"multipart/related", ".eml"}, {"multipart/report", ".eml"}, {"multipart/x-ustar", ".ustar"}, {"paleovu/x-pv", ".pvu"}, {"text/asp", ".asp"}, {"text/css", ".css"}, {"text/html", ".html"}, {"text/nls", ".nls"}, {"text/pascal", ".pas"}, {"text/plain", ".txt"}, {"text/prs.lines.tag", ".tag"}, {"text/richtext", ".rt"}, {"text/scriptlet", ".sct"}, {"text/sgml", ".sgm"}, {"text/tab-separated-values", ".tsv"}, {"text/uri-list", ".uri"}, {"text/vnd.curl", ".curl"}, {"text/vnd.fly", ".fly"}, {"text/vnd.in3d.spot", ".spo"}, {"text/vnd.ms-mediapackage", ".mpf"}, {"text/vnd.rn-realtext3d", ".r3t"}, {"text/vnd.sun.j2me.app-descriptor", ".jad"}, {"text/vnd.wap.si", ".si"}, {"text/vnd.wap.wml", ".wml"}, {"text/vnd.wap.wmlscript", ".wmls"}, {"text/webviewhtml", ".htt"}, {"text/x-asm", ".asm"}, {"text/x-audiosoft-intra", ".aip"}, {"text/x-c", ".cpp"}, {"text/x-component", ".htc"}, {"text/x-fortran", ".f90"}, {"text/x-hdml", ".hdml"}, {"text/x-java-source", ".java"}, {"text/xml", ".xml"}, {"text/x-mrml", ".mrl"}, {"text/x-pascal", ".p"}, {"text/x-script", ".hlb"}, {"text/x-script.csh", ".csh"}, {"text/x-script.elisp", ".el"}, {"text/x-script.lisp", ".lsp"}, {"text/x-script.perl", ".pl"}, {"text/x-script.perl-module", ".pm"}, {"text/x-script.phyton", ".py"}, {"text/x-script.rexx", ".rexx"}, {"text/x-script.scheme", ".scm"}, {"text/x-script.tcl", ".tcl"}, {"text/x-script.tcsh", ".tcsh"}, {"text/x-script.zsh", ".zsh"}, {"text/x-server-parsed-html", ".shtml"}, {"text/x-setext", ".etx"}, {"text/xsl", ".xsl"}, {"text/x-uil", ".uil"}, {"text/xul", ".xul"}, {"text/x-uuencode", ".uue"}, {"text/x-vCalendar", ".vcs"}, {"text/x-vcard", ".vcf"}, {"video/animaflex", ".afl"}, {"video/avi", ".avi"}, {"video/avs-video", ".avs"}, {"video/dl", ".dl"}, {"video/fli", ".fli"}, {"video/gl", ".gl"}, {"video/isivideo", ".fvi"}, {"video/mpeg", ".mpg"}, {"video/quicktime", ".mov"}, {"video/vdo", ".vdo"}, {"video/vivo", ".vivo"}, {"video/vnd.fvt", ".fvt"}, {"video/vnd.rn-realvideo", ".rv"}, {"video/vosaic", ".vos"}, {"video/wavelet", ".wv"}, {"video/x-amt-demorun", ".xdr"}, {"video/x-amt-showrun", ".xsr"}, {"video/x-atomic3d-feature", ".fmf"}, {"video/x-dv", ".dif"}, {"video/x-isvideo", ".isu"}, {"video/x-ivf", ".ivf"}, {"video/x-mng", ".mng"}, {"video/x-motion-jpeg", ".mjpg"}, {"video/x-mpeg2", ".mp2v"}, {"video/x-mpeg-system", ".mps"}, {"video/x-ms-asf", ".asf"}, {"video/x-ms-wmv", ".wmv"}, {"video/x-ms-wmx", ".wmx"}, {"video/x-ms-wvx", ".wvx"}, {"video/x-qtc", ".qtc"}, {"video/x-rad-screenplay", ".avx"}, {"video/x-sgi-movie", ".mv"}, {"workbook/formulaone", ".vts"}, {"www/mime", ".mime"}, {"x-conference/x-cooltalk", ".ice"}, {"xgl/drawing", ".xgz"}, {"x-lml/x-evm", ".evm"}, {"x-lml/x-gdb", ".gdb"}, {"x-lml/x-gps", ".trk"}, {"x-lml/x-lak", ".lak"}, {"x-lml/x-lml", ".lml"}, {"x-lml/x-lmlpack", ".lmlpack"}, {"x-lml/x-ndb", ".ndb"}, {"x-plugin/x-talker", ".talk"}, {"x-world/x-3dmf", ".3dmf"}, {"x-world/x-vream", ".vrw"}, {"x-world/x-vrt", ".vrt"}};
        FILE_EXTENSION_TO_MIME_TYPE_MAP = new HashMap(900);
        MIME_TYPE_TO_FILE_EXTENSION_MAP = new HashMap(600);
        for (i = 0; i < MIME_TYPE_TO_FILE_EXTENSION.length; ++i) {
            MIME_TYPE_TO_FILE_EXTENSION_MAP.put(MIME_TYPE_TO_FILE_EXTENSION[i][0].toLowerCase(), MIME_TYPE_TO_FILE_EXTENSION[i][1]);
        }
        for (i = 0; i < FILE_EXTENSION_TO_MIME_TYPE.length; ++i) {
            FILE_EXTENSION_TO_MIME_TYPE_MAP.put(FILE_EXTENSION_TO_MIME_TYPE[i][0].toLowerCase(), FILE_EXTENSION_TO_MIME_TYPE[i][1]);
        }
    }
}

